/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsLocationMetadataTest
implements JcloudsLocationConfig {
    protected BrooklynProperties brooklynProperties;
    protected LocalManagementContext managementContext;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.managementContext = LocalManagementContextForTests.newInstance((BrooklynProperties)BrooklynProperties.Factory.builderEmpty().build());
        this.brooklynProperties = this.managementContext.getBrooklynProperties();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.managementContext != null) {
            Entities.destroyAll((ManagementContext)this.managementContext);
        }
    }

    @Test
    public void testGetsDefaultAwsEc2Metadata() throws Exception {
        Location loc = this.managementContext.getLocationRegistry().resolve("jclouds:aws-ec2:us-west-1");
        Assert.assertEquals((Object)loc.getConfig(LocationConfigKeys.LATITUDE), (Object)40.0);
        Assert.assertEquals((Object)loc.getConfig(LocationConfigKeys.LONGITUDE), (Object)-120.0);
        Assert.assertEquals((Set)((Set)loc.getConfig(LocationConfigKeys.ISO_3166)), (Set)ImmutableSet.of((Object)"US-CA"));
    }

    @Test
    public void testCanOverrideDefaultAwsEc2Metadata() throws Exception {
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2@us-west-1.latitude", (Object)"41.2");
        Location loc = this.managementContext.getLocationRegistry().resolve("jclouds:aws-ec2:us-west-1");
        Assert.assertEquals((Object)loc.getConfig(LocationConfigKeys.LATITUDE), (Object)41.2);
    }
}

