/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsStubbedLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.collections.MutableMap;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.domain.LoginCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsHardwareProfilesStubbedLiveTest
extends AbstractJcloudsStubbedLiveTest {
    private static final Logger log = LoggerFactory.getLogger(JcloudsHardwareProfilesStubbedLiveTest.class);
    private Template template;

    @Override
    protected AbstractJcloudsStubbedLiveTest.NodeCreator newNodeCreator() {
        return new AbstractJcloudsStubbedLiveTest.NodeCreator(){

            @Override
            protected NodeMetadata newNode(String group, Template template) {
                JcloudsHardwareProfilesStubbedLiveTest.this.template = template;
                NodeMetadata result = new NodeMetadataBuilder().id("myid").credentials(LoginCredentials.builder().identity("myuser").credential("mypassword").build()).loginPort(22).status(NodeMetadata.Status.RUNNING).publicAddresses((Iterable)ImmutableList.of((Object)"173.194.32.123")).privateAddresses((Iterable)ImmutableList.of((Object)"172.168.10.11")).build();
                return result;
            }
        };
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testJcloudsCreateWithHardwareProfiles() throws Exception {
        this.obtainMachine((Map<?, ?>)MutableMap.of((Object)JcloudsLocationConfig.MIN_RAM, (Object)"4096"));
        Assert.assertTrue((this.template.getHardware().getRam() >= 4096 ? 1 : 0) != 0, (String)("template=" + this.template));
        this.obtainMachine((Map<?, ?>)MutableMap.of((Object)JcloudsLocationConfig.MIN_CORES, (Object)"4"));
        Assert.assertTrue((((Processor)this.template.getHardware().getProcessors().get(0)).getCores() >= 4.0 ? 1 : 0) != 0, (String)("template=" + this.template));
        this.obtainMachine((Map<?, ?>)MutableMap.of((Object)JcloudsLocationConfig.MIN_DISK, (Object)"51"));
        Assert.assertTrue((((Volume)this.template.getHardware().getVolumes().get(0)).getSize().floatValue() >= 51.0f ? 1 : 0) != 0, (String)("template=" + this.template));
        String hardwareId = "cpu=1,memory=6144,disk=25,type=LOCAL";
        this.obtainMachine((Map<?, ?>)MutableMap.of((Object)JcloudsLocationConfig.HARDWARE_ID, (Object)hardwareId));
        Assert.assertEquals((String)this.template.getHardware().getId(), (String)hardwareId, (String)("template=" + this.template));
    }
}

