/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import java.util.NoSuchElementException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsByonLocationResolverTest {
    private LocalManagementContext managementContext;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.managementContext = LocalManagementContextForTests.newInstance();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.managementContext != null) {
            Entities.destroyAll((ManagementContext)this.managementContext);
        }
    }

    @Test
    public void testThrowsOnInvalid() throws Exception {
        this.assertThrowsNoSuchElement("wrongprefix:(hosts=\"1.1.1.1\")");
        this.assertThrowsIllegalArgument("jcloudsByon");
        this.assertThrowsIllegalArgument("jcloudsByon:()");
        this.assertThrowsIllegalArgument("jcloudsByon:(hosts=\"\")");
        this.assertThrowsIllegalArgument("jcloudsByon:(hosts=\"i-72b1b132\"");
        this.assertThrowsIllegalArgument("jcloudsByon:(hosts=\"i-72b1b132\", name)");
        this.assertThrowsIllegalArgument("jcloudsByon:(hosts=\"i-72b1b132\", name=)");
    }

    private FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> resolve(String spec) {
        return (FixedListMachineProvisioningLocation)this.managementContext.getLocationRegistry().resolve(spec);
    }

    private void assertThrowsNoSuchElement(String val) {
        try {
            this.resolve(val);
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    private void assertThrowsIllegalArgument(String val) {
        try {
            this.resolve(val);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

