/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class JcloudsByonLocationResolverSoftlayerLiveTest
extends AbstractJcloudsLiveTest {
    private static final String SOFTLAYER_REGION = "dal05";
    private static final String SOFTLAYER_LOCATION_SPEC = "jclouds:softlayer:dal05";
    private String slVmUser;
    private String slVmInstanceId;
    private String slVmIp;
    private String slVmHostname;
    private LocalManagementContext classManagementContext;
    private JcloudsLocation classEc2Loc;
    private JcloudsSshMachineLocation classVm;

    @BeforeClass(groups={"Live"})
    public void setUpClass() throws Exception {
        this.classManagementContext = this.newManagementContext();
        this.classEc2Loc = (JcloudsLocation)this.classManagementContext.getLocationRegistry().resolve(SOFTLAYER_LOCATION_SPEC);
        this.classVm = (JcloudsSshMachineLocation)this.classEc2Loc.obtain((Map)MutableMap.builder().put((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
        this.slVmUser = this.classVm.getUser();
        this.slVmInstanceId = this.classVm.getJcloudsId();
        this.slVmIp = this.classVm.getAddress().getHostAddress();
        this.slVmHostname = this.classVm.getNode().getHostname();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() throws Exception {
        try {
            if (this.classVm != null) {
                this.classEc2Loc.release((MachineLocation)this.classVm);
            }
        }
        finally {
            if (this.classManagementContext != null) {
                this.classManagementContext.terminate();
            }
        }
    }

    @Test(groups={"Live"})
    public void testResolvesJcloudsByonSoftlayer() throws Exception {
        this.checkSoftlayer("jcloudsByon:(provider=\"softlayer\",region=\"dal05\",hosts=\"" + this.slVmInstanceId + "\",user=\"" + this.slVmUser + "\")");
        this.checkSoftlayer("jcloudsByon:(provider=\"softlayer\",region=\"dal05\",hosts=\"" + this.slVmHostname + "\")");
        this.checkSoftlayer("jcloudsByon:(provider=\"softlayer\",region=\"dal05\",hosts=\"" + this.slVmIp + "\")");
        this.checkSoftlayer("jcloudsByon:(provider=\"softlayer\",hosts=\"" + this.slVmIp + "\")");
    }

    private void checkSoftlayer(String spec) {
        FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> loc = this.resolve(spec);
        Set machines = loc.getAllMachines();
        JcloudsSshMachineLocation machine = (JcloudsSshMachineLocation)Iterables.getOnlyElement((Iterable)machines);
        Assert.assertEquals((String)machine.getParent().getProvider(), (String)"softlayer");
        Assert.assertEquals((String)machine.getNode().getId(), (String)this.slVmInstanceId);
        Assert.assertEquals((String)machine.getAddress().getHostAddress(), (String)this.slVmIp);
        Assert.assertTrue((this.slVmHostname.equals(machine.getAddress().getHostName()) || this.slVmIp.equals(machine.getAddress().getHostName()) ? 1 : 0) != 0, (String)("address hostname is: " + machine.getAddress().getHostName()));
        Assert.assertTrue((this.slVmHostname.equals(machine.getNode().getHostname()) || this.slVmIp.equals(machine.getNode().getHostname()) ? 1 : 0) != 0, (String)("node hostname is: " + machine.getNode().getHostname()));
    }

    private FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> resolve(String spec) {
        return (FixedListMachineProvisioningLocation)this.managementContext.getLocationRegistry().resolve(spec);
    }
}

