/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class JcloudsByonLocationResolverAwsLiveTest
extends AbstractJcloudsLiveTest {
    private static final String AWS_REGION = "eu-west-1";
    private static final String AWS_LOCATION_SPEC = "jclouds:aws-ec2:eu-west-1";
    private String awsVmUser;
    private String awsVmInstanceId;
    private String awsVmIp;
    private String awsVmHostname;
    private LocalManagementContext classManagementContext;
    private JcloudsLocation classEc2Loc;
    private JcloudsSshMachineLocation classEc2Vm;

    @BeforeClass(groups={"Live"})
    public void setUpClass() throws Exception {
        this.classManagementContext = this.newManagementContext();
        this.classEc2Loc = (JcloudsLocation)this.classManagementContext.getLocationRegistry().resolve(AWS_LOCATION_SPEC);
        this.classEc2Vm = (JcloudsSshMachineLocation)this.classEc2Loc.obtain((Map)MutableMap.builder().put((Object)"hardwareId", (Object)"m1.small").put((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
        this.awsVmUser = this.classEc2Vm.getUser();
        this.awsVmInstanceId = this.classEc2Vm.getNode().getProviderId();
        this.awsVmIp = this.classEc2Vm.getAddress().getHostAddress();
        this.awsVmHostname = this.classEc2Vm.getAddress().getHostName();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() throws Exception {
        try {
            if (this.classEc2Vm != null) {
                this.classEc2Loc.release((MachineLocation)this.classEc2Vm);
            }
        }
        finally {
            if (this.classManagementContext != null) {
                this.classManagementContext.terminate();
            }
        }
    }

    @Test(groups={"Live"})
    public void testResolvesJcloudsByonAws() throws Exception {
        String spec = "jcloudsByon:(provider=\"aws-ec2\",region=\"eu-west-1\",user=\"" + this.awsVmUser + "\",hosts=\"" + this.awsVmInstanceId + "\",anotherprop=myval)";
        FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> loc = this.resolve(spec);
        Set machines = loc.getAllMachines();
        JcloudsSshMachineLocation machine = (JcloudsSshMachineLocation)Iterables.getOnlyElement((Iterable)machines);
        Assert.assertEquals((String)machine.getParent().getProvider(), (String)"aws-ec2");
        Assert.assertEquals((String)machine.getAddress().getHostAddress(), (String)this.awsVmIp);
        Assert.assertEquals((String)machine.getAddress().getHostName(), (String)this.awsVmHostname);
        Assert.assertEquals((String)machine.getUser(), (String)this.awsVmUser);
        Assert.assertEquals((Object)machine.config().getBag().getStringKey("anotherprop"), (Object)"myval");
        Assert.assertTrue((boolean)machine.isSshable());
    }

    @Test(groups={"Live"})
    public void testResolvesNamedJcloudsByon() throws Exception {
        String spec = "jcloudsByon:(provider=\"aws-ec2\",region=\"eu-west-1\",user=\"" + this.awsVmUser + "\",hosts=\"" + this.awsVmInstanceId + "\")";
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed", (Object)spec);
        FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> loc = this.resolve("named:mynamed");
        Assert.assertEquals((Object)((JcloudsSshMachineLocation)loc.obtain()).getAddress(), (Object)InetAddress.getByName(this.awsVmHostname));
    }

    @Test(groups={"Live"})
    public void testJcloudsPropertiesPrecedence() throws Exception {
        String spec = "jcloudsByon:(provider=\"aws-ec2\",region=\"eu-west-1\",user=\"" + this.awsVmUser + "\",hosts=\"" + this.awsVmInstanceId + "\")";
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed", (Object)spec);
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed.user", (Object)"user-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.user", (Object)"user-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.user", (Object)"user-inProviderSpecificDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.user", (Object)"user-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.user", (Object)"user-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.user", (Object)"user-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed.privateKeyFile", (Object)"privateKeyFile-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.privateKeyFile", (Object)"privateKeyFile-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.privateKeyFile", (Object)"privateKeyFile-inProviderSpecificDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.privateKeyFile", (Object)"privateKeyFile-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.privateKeyFile", (Object)"privateKeyFile-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.privateKeyFile", (Object)"privateKeyFile-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.aws-ec2.publicKeyFile", (Object)"publicKeyFile-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.publicKeyFile", (Object)"publicKeyFile-inProviderSpecificDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.publicKeyFile", (Object)"publicKeyFile-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.publicKeyFile", (Object)"publicKeyFile-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.publicKeyFile", (Object)"publicKeyFile-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.securityGroups", (Object)"securityGroups-inProviderSpecificDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.securityGroups", (Object)"securityGroups-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.securityGroups", (Object)"securityGroups-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.securityGroups", (Object)"securityGroups-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.jclouds.loginUser", (Object)"loginUser-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.loginUser", (Object)"loginUser-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.loginUser", (Object)"loginUser-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.imageId", (Object)"imageId-inJcloudsGenericDeprecated");
        this.brooklynProperties.put((Object)"brooklyn.location.imageId", (Object)"imageId-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.keyPair", (Object)"keyPair-inLocationGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed.private-key-data", (Object)"privateKeyData-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.privateKeyData", (Object)"privateKeyData-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.privateKeyData", (Object)"privateKeyData-inJcloudsGeneric");
        this.brooklynProperties.put((Object)"brooklyn.location.named.mynamed.privateKeyPassphrase", (Object)"privateKeyPassphrase-inNamed");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.aws-ec2.private-key-passphrase", (Object)"privateKeyPassphrase-inProviderSpecific");
        this.brooklynProperties.put((Object)"brooklyn.jclouds.private-key-passphrase", (Object)"privateKeyPassphrase-inJcloudsGeneric");
        Map conf = ((JcloudsSshMachineLocation)this.resolve("named:mynamed").obtain()).config().getBag().getAllConfig();
        Assert.assertEquals(conf.get("user"), (Object)this.awsVmUser);
        Assert.assertEquals(conf.get("privateKeyFile"), (Object)"privateKeyFile-inNamed");
        Assert.assertEquals(conf.get("publicKeyFile"), (Object)"publicKeyFile-inProviderSpecific");
        Assert.assertEquals(conf.get("securityGroups"), (Object)"securityGroups-inProviderSpecificDeprecated");
        Assert.assertEquals(conf.get("loginUser"), (Object)"loginUser-inJcloudsGeneric");
        Assert.assertEquals(conf.get("imageId"), (Object)"imageId-inJcloudsGenericDeprecated");
        Assert.assertEquals(conf.get("keyPair"), (Object)"keyPair-inLocationGeneric");
        Assert.assertEquals(conf.get("privateKeyData"), (Object)"privateKeyData-inNamed");
        Assert.assertEquals(conf.get("privateKeyPassphrase"), (Object)"privateKeyPassphrase-inNamed");
    }

    private FixedListMachineProvisioningLocation<JcloudsSshMachineLocation> resolve(String spec) {
        return (FixedListMachineProvisioningLocation)this.managementContext.getLocationRegistry().resolve(spec);
    }
}

