/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JcloudsAddressesLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsAddressesLiveTest.class);
    public static final String AWS_EC2_REGION_NAME = "us-east-1";
    public static final String AWS_EC2_LOCATION_SPEC = "jclouds:aws-ec2" + ("us-east-1" == null ? "" : ":us-east-1");
    public static final String AWS_EC2_CENTOS_IMAGE_ID = "us-east-1/ami-7d7bfc14";
    public static final String AWS_EC2_UBUNTU_IMAGE_ID = "us-east-1/ami-d0f89fb9";
    public static final String AWS_EC2_UBUNTU_10_IMAGE_ID = "us-east-1/ami-5e008437";
    public static final String RACKSPACE_LOCATION_SPEC = "jclouds:rackspace-cloudservers-uk";
    public static final String RACKSPACE_CENTOS_IMAGE_NAME_REGEX = "CentOS 6.0";
    protected JcloudsSshMachineLocation machine;

    @Test(groups={"Live"})
    protected void testAwsEc2Addresses() throws Exception {
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(AWS_EC2_LOCATION_SPEC);
        this.machine = this.createEc2Machine((Map<String, ? extends Object>)ImmutableMap.of());
        this.assertSshable((SshMachineLocation)this.machine);
        String locationAddress = this.machine.getAddress().getHostName();
        InetAddress address = this.machine.getAddress();
        Set publicAddresses = this.machine.getPublicAddresses();
        Set privateAddresses = this.machine.getPrivateAddresses();
        String subnetIp = this.machine.getSubnetIp();
        String hostname = this.machine.getHostname();
        String subnetHostname = this.machine.getSubnetHostname();
        String msg = "locationAddress=" + locationAddress + "; address=" + address + "; publicAddrs=" + publicAddresses + "; privateAddrs=" + privateAddresses + "; subnetIp=" + subnetIp + "; hostname=" + hostname + "; subnetHostname=" + subnetHostname;
        LOG.info("node: " + msg);
        this.assertReachable((SshMachineLocation)this.machine, locationAddress, msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, locationAddress, msg);
        this.assertReachable((SshMachineLocation)this.machine, address, msg);
        Assert.assertTrue((publicAddresses.size() > 0 ? 1 : 0) != 0, (String)msg);
        for (String publicAddress : publicAddresses) {
            this.assertReachable((SshMachineLocation)this.machine, publicAddress, msg);
        }
        Assert.assertTrue((privateAddresses.size() > 0 ? 1 : 0) != 0, (String)msg);
        for (String privateAddress : privateAddresses) {
            this.assertReachableFromMachine((SshMachineLocation)this.machine, privateAddress, msg);
            this.assertNotReachable((SshMachineLocation)this.machine, privateAddress, msg);
        }
        Assert.assertNotNull((Object)subnetIp, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, subnetIp, msg);
        Assert.assertNotNull((Object)hostname, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, hostname, msg);
        Assert.assertNotNull((Object)subnetHostname, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, subnetHostname, msg);
    }

    @Test(groups={"Live"})
    protected void testRackspaceAddresses() throws Exception {
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(RACKSPACE_LOCATION_SPEC);
        this.machine = this.createRackspaceMachine((Map<String, ? extends Object>)ImmutableMap.of());
        this.assertSshable((SshMachineLocation)this.machine);
        String locationAddress = this.machine.getAddress().getHostAddress();
        InetAddress address = this.machine.getAddress();
        Set publicAddresses = this.machine.getPublicAddresses();
        Set privateAddresses = this.machine.getPrivateAddresses();
        String subnetIp = this.machine.getSubnetIp();
        String hostname = this.machine.getHostname();
        String subnetHostname = this.machine.getSubnetHostname();
        String msg = "locationAddress=" + locationAddress + "; address=" + address + "; publicAddrs=" + publicAddresses + "; privateAddrs=" + privateAddresses + "; subnetIp=" + subnetIp + "; hostname=" + hostname + "; subnetHostname=" + subnetHostname;
        LOG.info("node: " + msg);
        this.assertReachable((SshMachineLocation)this.machine, locationAddress, msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, locationAddress, msg);
        this.assertReachable((SshMachineLocation)this.machine, address, msg);
        Assert.assertTrue((publicAddresses.size() > 0 ? 1 : 0) != 0, (String)msg);
        for (String publicAddress : publicAddresses) {
            this.assertReachable((SshMachineLocation)this.machine, publicAddress, msg);
        }
        for (String privateAddress : privateAddresses) {
            this.assertReachableFromMachine((SshMachineLocation)this.machine, privateAddress, msg);
            this.assertNotReachable((SshMachineLocation)this.machine, privateAddress, msg);
        }
        Assert.assertNotNull((Object)subnetIp, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, subnetIp, msg);
        Assert.assertNotNull((Object)hostname, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, hostname, msg);
        Assert.assertNotNull((Object)subnetHostname, (String)msg);
        this.assertReachableFromMachine((SshMachineLocation)this.machine, subnetHostname, msg);
    }

    private void assertReachable(SshMachineLocation machine, InetAddress addr, String msg) {
        this.assertReachable(machine, addr.getHostAddress(), msg);
    }

    private void assertReachable(SshMachineLocation machine, String addr, String msg) {
        this.assertReachability(true, machine, addr, msg);
    }

    private void assertNotReachable(SshMachineLocation machine, String addr, String msg) {
        this.assertReachability(false, machine, addr, msg);
    }

    private void assertReachability(boolean expectedReachable, SshMachineLocation machine, String addr, String msg) {
        SshMachineLocation tmpMachine = (SshMachineLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).configure(machine.config().getBag().getAllConfig()).configure((CharSequence)"address", (Object)addr));
        try {
            boolean sshable = tmpMachine.isSshable();
            Assert.assertEquals((boolean)sshable, (boolean)expectedReachable, (String)(String.valueOf(addr) + " not sshable; " + msg));
        }
        finally {
            Locations.unmanage((Location)tmpMachine);
        }
    }

    private void assertReachableFromMachine(SshMachineLocation machine, String addr, String msg) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        int result = machine.execScript((Map)MutableMap.of((Object)"out", (Object)outStream, (Object)"err", (Object)errStream), "reach " + addr, (List)ImmutableList.of((Object)("ping -c 1 " + addr)));
        String outString = ((Object)outStream).toString();
        String errString = ((Object)errStream).toString();
        Assert.assertEquals((int)result, (int)0, (String)("result=0; err=" + errString + "; out=" + outString + "; msg=" + msg));
    }

    @Override
    protected void releaseMachine(JcloudsSshMachineLocation machine) {
        this.jcloudsLocation.release((MachineLocation)machine);
    }

    private JcloudsSshMachineLocation createEc2Machine(Map<String, ? extends Object> conf) throws Exception {
        return this.obtainMachine((Map<?, ?>)MutableMap.builder().putAll(conf).putIfAbsent((Object)"imageId", (Object)AWS_EC2_CENTOS_IMAGE_ID).putIfAbsent((Object)"hardwareId", (Object)"m1.small").putIfAbsent((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
    }

    private JcloudsSshMachineLocation createRackspaceMachine(Map<String, ? extends Object> conf) throws Exception {
        return this.obtainMachine((Map<?, ?>)MutableMap.builder().putAll(conf).putIfAbsent((Object)"inboundPorts", (Object)ImmutableList.of((Object)22)).build());
    }

    protected void assertSshable(Map<?, ?> machineConfig) {
        SshMachineLocation machineWithThatConfig = (SshMachineLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).configure(machineConfig));
        try {
            this.assertSshable(machineWithThatConfig);
        }
        finally {
            Streams.closeQuietly((Closeable)machineWithThatConfig);
        }
    }
}

