/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Template;

public class BailOutJcloudsLocation
extends JcloudsLocation {
    public static final String ERROR_MESSAGE = "early termination for test";
    public static final RuntimeException BAIL_OUT_FOR_TESTING = new RuntimeException("early termination for test");
    private static final String US_EAST_IMAGE_ID = "us-east-1/ami-7d7bfc14";
    public static final ConfigKey<Function<ConfigBag, Void>> BUILD_TEMPLATE_INTERCEPTOR = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Function<ConfigBag, Void>>(){}, (String)"buildtemplateinterceptor");
    public static final ConfigKey<Boolean> BUILD_TEMPLATE = ConfigKeys.newBooleanConfigKey((String)"buildtemplate");
    private static final long serialVersionUID = -3373789512935057842L;
    ConfigBag lastConfigBag;
    Template template;

    public BailOutJcloudsLocation() {
    }

    public BailOutJcloudsLocation(Map<?, ?> conf) {
        super(conf);
    }

    public Template buildTemplate(ComputeService computeService, ConfigBag config) {
        this.lastConfigBag = config;
        if (this.getConfig(BUILD_TEMPLATE_INTERCEPTOR) != null) {
            ((Function)this.getConfig(BUILD_TEMPLATE_INTERCEPTOR)).apply((Object)config);
        }
        if (Boolean.TRUE.equals(this.getConfig(BUILD_TEMPLATE))) {
            this.template = super.buildTemplate(computeService, config);
        }
        throw BAIL_OUT_FOR_TESTING;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void tryObtain() {
        this.tryObtain(Collections.emptyMap());
    }

    public void tryObtain(Map<?, ?> flags) {
        this.tryObtainAndCheck(flags, (Predicate<? super ConfigBag>)Predicates.alwaysTrue());
    }

    public void tryObtainAndCheck(Map<?, ?> flags, Predicate<? super ConfigBag> test) {
        try {
            this.obtain(flags);
        }
        catch (Exception e) {
            if (e == BAIL_OUT_FOR_TESTING || e.getCause() == BAIL_OUT_FOR_TESTING || e instanceof CompoundRuntimeException && ((CompoundRuntimeException)e).getAllCauses().contains(BAIL_OUT_FOR_TESTING)) {
                test.apply((Object)this.lastConfigBag);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    public JcloudsLocation.UserCreation createUserStatements(@Nullable Image image, ConfigBag config) {
        return super.createUserStatements(image, config);
    }

    public static BailOutJcloudsLocation newBailOutJcloudsLocation(ManagementContext mgmt) {
        return BailOutJcloudsLocation.newBailOutJcloudsLocation(mgmt, Collections.emptyMap());
    }

    public static BailOutJcloudsLocation newBailOutJcloudsLocation(ManagementContext mgmt, Map<ConfigKey<?>, ?> config) {
        MutableMap allConfig = MutableMap.builder().put((Object)IMAGE_ID, (Object)"bogus").put((Object)CLOUD_PROVIDER, (Object)"aws-ec2").put((Object)ACCESS_IDENTITY, (Object)"bogus").put((Object)CLOUD_REGION_ID, (Object)"bogus").put((Object)ACCESS_CREDENTIAL, (Object)"bogus").put((Object)USER, (Object)"fred").put((Object)MIN_RAM, (Object)16).put((Object)JcloudsLocation.MACHINE_CREATE_ATTEMPTS, (Object)1).putAll(config).build();
        return (BailOutJcloudsLocation)mgmt.getLocationManager().createLocation(LocationSpec.create(BailOutJcloudsLocation.class).configure((Map)allConfig));
    }

    public static CountingBailOutJcloudsLocation newCountingBailOutJcloudsLocation(ManagementContext mgmt, Map flags) {
        LocationSpec spec = LocationSpec.create(CountingBailOutJcloudsLocation.class).configure(flags);
        return (CountingBailOutJcloudsLocation)mgmt.getLocationManager().createLocation(spec);
    }

    public static BailOutJcloudsLocation newBailOutJcloudsLocationForLiveTest(LocalManagementContext mgmt) {
        return BailOutJcloudsLocation.newBailOutJcloudsLocationForLiveTest(mgmt, Collections.emptyMap());
    }

    public static BailOutJcloudsLocation newBailOutJcloudsLocationForLiveTest(LocalManagementContext mgmt, Map<ConfigKey<?>, ?> config) {
        String credential;
        BrooklynProperties brooklynProperties = mgmt.getBrooklynProperties();
        String identity = (String)brooklynProperties.get((Object)"brooklyn.location.jclouds.aws-ec2.identity");
        if (identity == null) {
            identity = (String)brooklynProperties.get((Object)"brooklyn.jclouds.aws-ec2.identity");
        }
        if ((credential = (String)brooklynProperties.get((Object)"brooklyn.location.jclouds.aws-ec2.credential")) == null) {
            credential = (String)brooklynProperties.get((Object)"brooklyn.jclouds.aws-ec2.credential");
        }
        MutableMap allConfig = MutableMap.builder().put((Object)CLOUD_PROVIDER, (Object)"aws-ec2").put((Object)CLOUD_REGION_ID, (Object)"us-east-1").put((Object)IMAGE_ID, (Object)US_EAST_IMAGE_ID).put((Object)ACCESS_IDENTITY, (Object)identity).put((Object)ACCESS_CREDENTIAL, (Object)credential).put((Object)INBOUND_PORTS, (Object)"[22, 80, 9999]").put(BUILD_TEMPLATE, (Object)true).putAll(config).build();
        return BailOutJcloudsLocation.newBailOutJcloudsLocation((ManagementContext)mgmt, allConfig);
    }

    public static class CountingBailOutJcloudsLocation
    extends BailOutJcloudsLocation {
        private static final long serialVersionUID = 2433684033045735773L;
        int buildTemplateCount = 0;

        @Override
        public Template buildTemplate(ComputeService computeService, ConfigBag config) {
            ++this.buildTemplateCount;
            return super.buildTemplate(computeService, config);
        }
    }
}

