/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.AbstractJcloudsLiveTest;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistry;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistryImpl;
import org.apache.brooklyn.location.jclouds.DelegatingComputeService;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractJcloudsStubbedLiveTest
extends AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJcloudsStubbedLiveTest.class);
    public static final String LOCATION_SPEC = "jclouds:softlayer:ams01";
    protected NodeCreator nodeCreator;

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.nodeCreator = this.newNodeCreator();
        ComputeServiceRegistry computeServiceRegistry = new ComputeServiceRegistry(){

            public ComputeService findComputeService(ConfigBag conf, boolean allowReuse) {
                ComputeService delegate = ComputeServiceRegistryImpl.INSTANCE.findComputeService(conf, allowReuse);
                return new StubbedComputeService(delegate, AbstractJcloudsStubbedLiveTest.this.nodeCreator);
            }
        };
        this.jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve(LOCATION_SPEC, (Map)ImmutableMap.of((Object)JcloudsLocationConfig.COMPUTE_SERVICE_REGISTRY, (Object)computeServiceRegistry, (Object)JcloudsLocationConfig.WAIT_FOR_SSHABLE, (Object)"false"));
    }

    protected abstract NodeCreator newNodeCreator();

    public static abstract class NodeCreator {
        public final List<NodeMetadata> created = Lists.newCopyOnWriteArrayList();
        public final List<String> destroyed = Lists.newCopyOnWriteArrayList();

        public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
            LinkedHashSet result = Sets.newLinkedHashSet();
            int i = 0;
            while (i < count) {
                NodeMetadata node = this.newNode(group, template);
                this.created.add(node);
                result.add(node);
                ++i;
            }
            return result;
        }

        public void destroyNode(String id) {
            this.destroyed.add(id);
        }

        protected abstract NodeMetadata newNode(String var1, Template var2);
    }

    public static class StubbedComputeService
    extends DelegatingComputeService {
        private final NodeCreator nodeCreator;

        public StubbedComputeService(ComputeService delegate, NodeCreator nodeCreator) {
            super(delegate);
            this.nodeCreator = nodeCreator;
        }

        @Override
        public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
            return this.nodeCreator.createNodesInGroup(group, count, template);
        }

        @Override
        public void destroyNode(String id) {
            this.nodeCreator.destroyNode(id);
        }

        @Override
        public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
            throw new UnsupportedOperationException();
        }
    }
}

