/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsSshMachineLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class AbstractJcloudsLiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJcloudsLiveTest.class);
    public static final String BROOKLYN_PROPERTIES_PREFIX = "brooklyn.location.jclouds.";
    public static final String BROOKLYN_PROPERTIES_LEGACY_PREFIX = "brooklyn.jclouds.";
    public static final String AWS_EC2_PROVIDER = "aws-ec2";
    public static final String AWS_EC2_MICRO_HARDWARE_ID = "t1.micro";
    public static final String AWS_EC2_SMALL_HARDWARE_ID = "m1.small";
    public static final String AWS_EC2_EUWEST_REGION_NAME = "eu-west-1";
    public static final String AWS_EC2_USEAST_REGION_NAME = "us-east-1";
    public static final String RACKSPACE_PROVIDER = "rackspace-cloudservers-uk";
    public static final String SOFTLAYER_PROVIDER = "softlayer";
    public static final String SOFTLAYER_AMS01_REGION_NAME = "ams01";
    protected BrooklynProperties brooklynProperties;
    protected LocalManagementContext managementContext;
    protected List<JcloudsSshMachineLocation> machines;
    protected JcloudsLocation jcloudsLocation;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.machines = Lists.newCopyOnWriteArrayList();
        this.managementContext = this.newManagementContext();
        this.brooklynProperties = this.managementContext.getBrooklynProperties();
        this.stripBrooklynProperties(this.brooklynProperties);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        ArrayList exceptions = Lists.newArrayList();
        try {
            if (this.machines != null) {
                for (JcloudsSshMachineLocation machine : this.machines) {
                    try {
                        this.releaseMachine(machine);
                    }
                    catch (Exception e) {
                        LOG.warn("Error releasing machine " + machine + "; continuing...", (Throwable)e);
                        exceptions.add(e);
                    }
                }
                this.machines.clear();
            }
        }
        finally {
            try {
                if (this.managementContext != null) {
                    Entities.destroyAll((ManagementContext)this.managementContext);
                }
            }
            catch (Exception e) {
                LOG.warn("Error destroying management context", (Throwable)e);
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new CompoundRuntimeException("Error in tearDown of " + this.getClass(), (Iterable)exceptions);
        }
    }

    protected LocalManagementContext newManagementContext() {
        return LocalManagementContextForTests.builder((boolean)true).useDefaultProperties().build();
    }

    protected void stripBrooklynProperties(BrooklynProperties props) {
        for (String key : ImmutableSet.copyOf(props.asMapWithStringKeys().keySet())) {
            if (key.startsWith(BROOKLYN_PROPERTIES_PREFIX) && !key.endsWith("identity") && !key.endsWith("credential")) {
                props.remove((Object)key);
            }
            if (key.startsWith(BROOKLYN_PROPERTIES_LEGACY_PREFIX) && !key.endsWith("identity") && !key.endsWith("credential")) {
                props.remove((Object)key);
            }
            if (!key.startsWith("brooklyn.ssh")) continue;
            props.remove((Object)key);
        }
    }

    protected void assertSshable(SshMachineLocation machine) {
        int result = machine.execScript("simplecommand", (List)ImmutableList.of((Object)"true"));
        Assert.assertEquals((int)result, (int)0);
    }

    protected JcloudsSshMachineLocation obtainMachine(Map<?, ?> conf) throws Exception {
        Assert.assertNotNull((Object)this.jcloudsLocation);
        JcloudsSshMachineLocation result = (JcloudsSshMachineLocation)this.jcloudsLocation.obtain(conf);
        this.machines.add((JcloudsSshMachineLocation)Preconditions.checkNotNull((Object)result, (Object)"result"));
        return result;
    }

    protected JcloudsSshMachineLocation obtainMachine() throws Exception {
        return this.obtainMachine((Map<?, ?>)ImmutableMap.of());
    }

    protected void releaseMachine(JcloudsSshMachineLocation machine) {
        Assert.assertNotNull((Object)this.jcloudsLocation);
        this.machines.remove(machine);
        this.jcloudsLocation.release((MachineLocation)machine);
    }

    protected void suspendMachine(MachineLocation machine) {
        Assert.assertNotNull((Object)this.jcloudsLocation);
        this.machines.remove(machine);
        this.jcloudsLocation.suspendMachine(machine);
    }

    protected MachineLocation resumeMachine(Map<?, ?> flags) {
        Assert.assertNotNull((Object)this.jcloudsLocation);
        MachineLocation location = this.jcloudsLocation.resumeMachine(flags);
        this.machines.add((JcloudsSshMachineLocation)location);
        return location;
    }
}

