/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import java.io.IOException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistenceStoreObjectAccessorWriterTestFixture;
import org.apache.brooklyn.core.mgmt.persist.StoreObjectAccessorLocking;
import org.apache.brooklyn.core.mgmt.persist.jclouds.JcloudsBlobStoreBasedObjectStore;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live", "Live-sanity"})
public class JcloudsObjectStoreAccessorWriterTest
extends PersistenceStoreObjectAccessorWriterTestFixture {
    private static final Logger log = LoggerFactory.getLogger(JcloudsObjectStoreAccessorWriterTest.class);
    private JcloudsBlobStoreBasedObjectStore store;
    private LocalManagementContextForTests mgmt;

    @BeforeMethod
    public void setUp() throws Exception {
        this.store = new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4));
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        this.store.injectManagementContext((ManagementContext)this.mgmt);
        this.store.prepareForSharedUse(PersistMode.CLEAN, HighAvailabilityMode.DISABLED);
        super.setUp();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.mgmt != null) {
            Entities.destroyAll((ManagementContext)this.mgmt);
        }
        if (this.store != null) {
            this.store.deleteCompletely();
        }
    }

    protected PersistenceObjectStore.StoreObjectAccessorWithLock newPersistenceStoreObjectAccessor() throws IOException {
        return this.newPersistenceStoreObjectAccessor(this.store, "");
    }

    protected PersistenceObjectStore.StoreObjectAccessorWithLock newPersistenceStoreObjectAccessor(JcloudsBlobStoreBasedObjectStore aStore, String prefix) throws IOException {
        return new StoreObjectAccessorLocking(aStore.newAccessor(String.valueOf(prefix) + "sample-file-" + Identifiers.makeRandomId((int)4)));
    }

    protected Duration getLastModifiedResolution() {
        return Duration.seconds((Number)2);
    }

    protected int biggishSize() {
        return 10000;
    }

    @Test(groups={"Live"})
    public void testNestedPath1() throws IOException {
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        String path1 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        String path2 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        String path3 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        JcloudsBlobStoreBasedObjectStore store0 = null;
        try {
            try {
                store0 = new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", Urls.mergePaths((String[])new String[]{path1, path2}));
                store0.injectManagementContext((ManagementContext)this.mgmt);
                store0.prepareForSharedUse(PersistMode.CLEAN, HighAvailabilityMode.DISABLED);
                this.newPersistenceStoreObjectAccessor(store0, String.valueOf(path3) + "/").put("hello world");
            }
            catch (Exception e) {
                log.warn("Failed with: " + e, (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        finally {
            store0.deleteCompletely();
            JcloudsBlobStoreBasedObjectStore storeD = new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", path1);
            storeD.injectManagementContext((ManagementContext)this.mgmt);
            storeD.prepareForSharedUse(PersistMode.CLEAN, HighAvailabilityMode.DISABLED);
            storeD.deleteCompletely();
        }
    }

    @Test(groups={"Live"})
    public void testNestedPath2() throws IOException {
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        String path1 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        String path2 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        String path3 = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4);
        JcloudsBlobStoreBasedObjectStore store1 = null;
        JcloudsBlobStoreBasedObjectStore store2 = null;
        try {
            try {
                store1 = new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", path1);
                store1.injectManagementContext((ManagementContext)this.mgmt);
                store1.prepareForSharedUse(PersistMode.CLEAN, HighAvailabilityMode.DISABLED);
                store1.createSubPath(path2);
                this.newPersistenceStoreObjectAccessor(store1, String.valueOf(path2) + "/" + path3 + "/").put("hello world");
                store2 = new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", Urls.mergePaths((String[])new String[]{path1, path2}));
                store2.injectManagementContext((ManagementContext)this.mgmt);
                store2.prepareForSharedUse(PersistMode.CLEAN, HighAvailabilityMode.DISABLED);
                this.newPersistenceStoreObjectAccessor(store2, String.valueOf(path3) + "/").put("hello world");
            }
            catch (Exception e) {
                e.printStackTrace();
                store1.newAccessor(path2).delete();
                store1.deleteCompletely();
            }
        }
        finally {
            store1.newAccessor(path2).delete();
            store1.deleteCompletely();
        }
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testWriteBacklogThenDeleteWillLeaveFileDeleted() throws Exception {
        super.testWriteBacklogThenDeleteWillLeaveFileDeleted();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testWritesFile() throws Exception {
        super.testWritesFile();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testLastModifiedTime() throws Exception {
        super.testLastModifiedTime();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testExists() throws Exception {
        super.testExists();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testAppendsFile() throws Exception {
        super.testAppendsFile();
    }
}

