/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import ch.qos.logback.classic.Level;
import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.util.text.Identifiers;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JcloudsExpect100ContinueTest {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsExpect100ContinueTest.class);
    private static String LOCATION_SPEC = "named:brooklyn-jclouds-objstore-test-1";
    private static final String OBJECT_NAME_PUT = "test_put";
    private static final String OBJECT_NAME_GET = "test_get";
    private ManagementContext mgmt;
    private BlobStoreContext context;
    private String containerName;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.setInfoLevel("ROOT");
        this.setInfoLevel("jclouds");
        this.setInfoLevel("org.jclouds");
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        JcloudsLocation jcloudsLocation = (JcloudsLocation)this.mgmt.getLocationRegistry().resolve(LOCATION_SPEC);
        this.context = JcloudsUtil.newBlobstoreContext((String)jcloudsLocation.getProvider(), (String)jcloudsLocation.getEndpoint(), (String)jcloudsLocation.getIdentity(), (String)jcloudsLocation.getCredential());
        this.containerName = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)8);
        this.context.getBlobStore().createContainerInLocation(null, this.containerName);
    }

    private void setInfoLevel(String loggerName) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)loggerName);
        logger.setLevel(Level.INFO);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            this.context.getBlobStore().deleteContainer(this.containerName);
        }
        catch (Exception exception) {}
        this.context.close();
        Entities.destroyAll((ManagementContext)this.mgmt);
    }

    @Test(groups={"Live"}, timeOut=240000L)
    public void testPutAfterUnclosedGet() {
        this.put(OBJECT_NAME_PUT, this.getContent());
        this.put(OBJECT_NAME_GET, this.getContent());
        int i = 1;
        while (i <= 50) {
            long start = System.currentTimeMillis();
            this.get(OBJECT_NAME_GET);
            long afterGet = System.currentTimeMillis();
            LOG.info(String.valueOf(i) + ". GET @" + (afterGet - start));
            System.gc();
            System.gc();
            System.gc();
            this.sleep(1000L);
            long beforePut = System.currentTimeMillis();
            this.put(OBJECT_NAME_PUT, this.getContent());
            long end = System.currentTimeMillis();
            LOG.info(String.valueOf(i) + ". PUT @" + (end - beforePut));
            ++i;
        }
    }

    private String getContent() {
        return "1234567890";
    }

    private void put(String name, String content) {
        BlobStore blobStore = this.context.getBlobStore();
        byte[] bytes = content.getBytes(Charsets.UTF_8);
        Blob blob = blobStore.blobBuilder(name).payload(ByteSource.wrap((byte[])bytes)).contentLength((long)bytes.length).build();
        try {
            blobStore.putBlob(this.containerName, blob);
        }
        catch (Exception e) {
            LOG.error("PUT " + name + " failed", (Throwable)e);
        }
    }

    private Blob get(String name) {
        try {
            BlobStore blobStore = this.context.getBlobStore();
            return blobStore.getBlob(this.containerName, name);
        }
        catch (Exception e) {
            LOG.error("GET " + name + " failed", (Throwable)e);
            return null;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {}
    }
}

