/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live", "Live-sanity"})
public class JcloudsBlobStoreBasedObjectStoreTest {
    private static final Logger log = LoggerFactory.getLogger(JcloudsBlobStoreBasedObjectStoreTest.class);
    private List<PersistenceObjectStore> objectStores = MutableList.of();
    private LocalManagementContext mgmt;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.mgmt = LocalManagementContextForTests.builder((boolean)true).useDefaultProperties().build();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (PersistenceObjectStore store : this.objectStores) {
            store.deleteCompletely();
        }
        Entities.destroyAll((ManagementContext)this.mgmt);
        this.objectStores.clear();
    }

    public PersistenceObjectStore newObjectStore(String spec, String container) {
        PersistenceObjectStore newObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.mgmt, (String)spec, (String)container);
        this.objectStores.add(newObjectStore);
        return newObjectStore;
    }

    @Test(groups={"Integration"})
    public void testLocalhost() throws Exception {
        this.doTestWithStore(this.newObjectStore(null, "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4)));
    }

    @Test(groups={"Integration"})
    public void testLocalhostWithSubPathInContainerName() throws Exception {
        this.doTestWithStore(this.newObjectStore(null, "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4) + "/subpath1/subpath2"));
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testJclouds() throws Exception {
        this.doTestWithStore(this.newObjectStore("named:brooklyn-jclouds-objstore-test-1", "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4)));
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testJcloudsWithSubPathInContainerName() throws Exception {
        this.doTestWithStore(this.newObjectStore("named:brooklyn-jclouds-objstore-test-1", "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4) + "/subpath1/subpath2"));
    }

    protected void doTestWithStore(PersistenceObjectStore objectStore) {
        log.info("testing against " + objectStore.getSummaryName());
        objectStore.createSubPath("foo");
        PersistenceObjectStore.StoreObjectAccessor f = objectStore.newAccessor("foo/file1.txt");
        Assert.assertFalse((boolean)f.exists());
        Stopwatch timer = Stopwatch.createStarted();
        f.append("Hello world");
        log.info("created in " + Duration.of((Object)timer));
        timer.reset();
        Assert.assertEquals((String)f.get(), (String)"Hello world");
        log.info("retrieved in " + Duration.of((Object)timer));
        Assert.assertTrue((boolean)f.exists());
        timer.reset();
        List files = objectStore.listContentsWithSubPath("foo");
        log.info("list retrieved in " + Duration.of((Object)timer) + "; is: " + files);
        Assert.assertEquals((Collection)files, (Collection)MutableList.of((Object)"foo/file1.txt"));
        f.delete();
    }
}

