/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.ha.HighAvailabilityManagerTestFixture;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.jclouds.JcloudsBlobStoreBasedObjectStore;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.util.text.Identifiers;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live", "Live-sanity"})
public class HighAvailabilityManagerJcloudsObjectStoreTest
extends HighAvailabilityManagerTestFixture {
    protected ManagementContextInternal newLocalManagementContext() {
        return new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
    }

    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
    }

    protected PersistenceObjectStore newPersistenceObjectStore() {
        return new JcloudsBlobStoreBasedObjectStore("named:brooklyn-jclouds-objstore-test-1", "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)4));
    }

    @Test(groups={"Live"}, invocationCount=5)
    public void testGetManagementPlaneStatusManyTimes() throws Exception {
        this.testGetManagementPlaneStatus();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testDoesNotPromoteIfMasterTimeoutNotExpired() throws Exception {
        super.testDoesNotPromoteIfMasterTimeoutNotExpired();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testGetManagementPlaneStatus() throws Exception {
        super.testGetManagementPlaneStatus();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testPromotes() throws Exception {
        super.testPromotes();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testGetManagementPlaneSyncStateInfersTimedOutNodeAsFailed() throws Exception {
        super.testGetManagementPlaneSyncStateInfersTimedOutNodeAsFailed();
    }

    @Test(groups={"Live", "Live-sanity"})
    public void testGetManagementPlaneSyncStateDoesNotThrowNpeBeforePersisterSet() throws Exception {
        super.testGetManagementPlaneSyncStateDoesNotThrowNpeBeforePersisterSet();
    }
}

