/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live", "Live-sanity"})
public class BlobStoreTest {
    public static final String PERSIST_TO_OBJECT_STORE_FOR_TEST_SPEC = "named:brooklyn-jclouds-objstore-test-1";
    public static final String CONTAINER_PREFIX = "brooklyn-persistence-test";
    private String locationSpec = "named:brooklyn-jclouds-objstore-test-1";
    private JcloudsLocation location;
    private BlobStoreContext context;
    private ManagementContext mgmt;
    private String testContainerName;

    public synchronized BlobStoreContext getBlobStoreContext() {
        if (this.context == null) {
            if (this.location == null) {
                Preconditions.checkNotNull((Object)this.locationSpec, (Object)"locationSpec required for remote object store when location is null");
                Preconditions.checkNotNull((Object)this.mgmt, (Object)"mgmt required for remote object store when location is null");
                this.location = (JcloudsLocation)this.mgmt.getLocationRegistry().resolve(this.locationSpec);
            }
            String identity = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.ACCESS_IDENTITY)), (Object)"identity must not be null");
            String credential = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL)), (Object)"credential must not be null");
            String provider = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.CLOUD_PROVIDER)), (Object)"provider must not be null");
            String endpoint = (String)this.location.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
            this.context = JcloudsUtil.newBlobstoreContext((String)provider, (String)endpoint, (String)identity, (String)credential);
        }
        return this.context;
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.testContainerName = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)8);
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        this.getBlobStoreContext();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        Entities.destroyAll((ManagementContext)this.mgmt);
    }

    public void testCreateListDestroyContainer() throws IOException {
        this.context.getBlobStore().createContainerInLocation(null, this.testContainerName);
        this.context.getBlobStore().list(this.testContainerName);
        PageSet ps = this.context.getBlobStore().list();
        BlobStoreTest.assertHasItemNamed((PageSet<? extends StorageMetadata>)ps, this.testContainerName);
        Blob b = this.context.getBlobStore().blobBuilder("my-blob-1").payload(Streams.newInputStreamWithContents((String)"hello world")).build();
        this.context.getBlobStore().putBlob(this.testContainerName, b);
        Blob b2 = this.context.getBlobStore().getBlob(this.testContainerName, "my-blob-1");
        Assert.assertEquals((String)Streams.readFullyString((InputStream)b2.getPayload().openStream()), (String)"hello world");
        this.context.getBlobStore().deleteContainer(this.testContainerName);
    }

    public void testCreateListDestroySimpleDirInContainer() throws IOException {
        this.context.getBlobStore().createContainerInLocation(null, this.testContainerName);
        this.context.getBlobStore().createDirectory(this.testContainerName, "my-dir-1");
        PageSet ps = this.context.getBlobStore().list(this.testContainerName);
        BlobStoreTest.assertHasItemNamed((PageSet<? extends StorageMetadata>)ps, "my-dir-1");
        Blob b = this.context.getBlobStore().blobBuilder("my-blob-1").payload(Streams.newInputStreamWithContents((String)"hello world")).build();
        this.context.getBlobStore().putBlob(String.valueOf(this.testContainerName) + "/" + "my-dir-1", b);
        ps = this.context.getBlobStore().list(this.testContainerName, ListContainerOptions.Builder.inDirectory((String)"my-dir-1"));
        BlobStoreTest.assertHasItemNamed((PageSet<? extends StorageMetadata>)ps, "my-dir-1/my-blob-1");
        Blob b2 = this.context.getBlobStore().getBlob(String.valueOf(this.testContainerName) + "/" + "my-dir-1", "my-blob-1");
        Assert.assertEquals((String)Streams.readFullyString((InputStream)b2.getPayload().openStream()), (String)"hello world");
        Blob b3 = this.context.getBlobStore().getBlob(this.testContainerName, "my-dir-1/my-blob-1");
        Assert.assertEquals((String)Streams.readFullyString((InputStream)b3.getPayload().openStream()), (String)"hello world");
        this.context.getBlobStore().deleteContainer(this.testContainerName);
    }

    static void assertHasItemNamed(PageSet<? extends StorageMetadata> ps, String name) {
        if (!BlobStoreTest.hasItemNamed(ps, name)) {
            Assert.fail((String)("No item named '" + name + "' in " + ps));
        }
    }

    static boolean hasItemNamed(PageSet<? extends StorageMetadata> ps, String name) {
        for (StorageMetadata sm : ps) {
            if (name != null && !name.equals(sm.getName())) continue;
            return true;
        }
        return false;
    }
}

