/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.persist.jclouds.JcloudsBlobStoreBasedObjectStore;
import org.apache.brooklyn.core.test.qa.performance.AbstractPerformanceTest;
import org.apache.brooklyn.util.text.Identifiers;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BlobStorePersistencePerformanceTest
extends AbstractPerformanceTest {
    public static final String LOCATION_SPEC = "named:brooklyn-jclouds-objstore-test-1";
    JcloudsBlobStoreBasedObjectStore objectStore;
    PersistenceObjectStore.StoreObjectAccessor blobstoreAccessor;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.objectStore = new JcloudsBlobStoreBasedObjectStore(LOCATION_SPEC, "BlobStorePersistencePerformanceTest");
        this.objectStore.injectManagementContext(this.mgmt);
        this.objectStore.prepareForSharedUse(PersistMode.AUTO, HighAvailabilityMode.AUTO);
        this.blobstoreAccessor = this.objectStore.newAccessor(Identifiers.makeRandomId((int)8));
        this.app.start((Collection)ImmutableList.of((Object)this.loc));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.blobstoreAccessor != null) {
            this.blobstoreAccessor.delete();
        }
        if (this.objectStore != null) {
            this.objectStore.deleteCompletely();
            this.objectStore.close();
        }
    }

    protected int numIterations() {
        return 100;
    }

    @Test(groups={"Live", "Acceptance"})
    public void testStoreObjectPuts() throws Exception {
        int numIterations = this.numIterations();
        double minRatePerSec = 10.0 * PERFORMANCE_EXPECTATION;
        final AtomicInteger i = new AtomicInteger();
        this.measureAndAssert("StoreObjectAccessor.put", numIterations, minRatePerSec, new Runnable(){

            @Override
            public void run() {
                BlobStorePersistencePerformanceTest.this.blobstoreAccessor.put("" + i.incrementAndGet());
            }
        });
    }

    @Test(groups={"Live", "Acceptance"})
    public void testStoreObjectGet() throws Exception {
        int numIterations = this.numIterations();
        double minRatePerSec = 10.0 * PERFORMANCE_EXPECTATION;
        this.measureAndAssert("FileBasedStoreObjectAccessor.get", numIterations, minRatePerSec, new Runnable(){

            @Override
            public void run() {
                BlobStorePersistencePerformanceTest.this.blobstoreAccessor.get();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @Test(groups={"Live", "Acceptance"})
    public void testStoreObjectDelete() throws Exception {
        numIterations = this.numIterations();
        minRatePerSec = 10.0 * BlobStorePersistencePerformanceTest.PERFORMANCE_EXPECTATION;
        blobstoreAccessors = Lists.newArrayList();
        i = 0;
        while ((double)i < (double)numIterations * 1.1 + 1.0) {
            blobstoreAccessors.add(this.objectStore.newAccessor("storeObjectDelete-" + i));
            ++i;
        }
        i = new AtomicInteger();
        try {
            this.measureAndAssert("FileBasedStoreObjectAccessor.delete", numIterations, minRatePerSec, new Runnable(){

                @Override
                public void run() {
                    PersistenceObjectStore.StoreObjectAccessor blobstoreAccessor = (PersistenceObjectStore.StoreObjectAccessor)blobstoreAccessors.get(i.getAndIncrement());
                    blobstoreAccessor.delete();
                }
            });
        }
        finally {
            ** for (blobstoreAccessor : blobstoreAccessors)
        }
lbl-1000:
        // 1 sources

        {
            blobstoreAccessor.delete();
            continue;
        }
lbl18:
        // 1 sources

    }
}

