/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.mgmt.persist.jclouds.BlobStoreTest;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.http.HttpTool;
import org.apache.brooklyn.util.core.http.HttpToolResponse;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.http.client.HttpClient;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live", "Live-sanity"})
public class BlobStoreExpiryTest {
    private static final Logger log = LoggerFactory.getLogger(BlobStoreExpiryTest.class);
    public static final String PERSIST_TO_OBJECT_STORE_FOR_TEST_SPEC = "named:brooklyn-jclouds-objstore-test-1";
    public static final String CONTAINER_PREFIX = "brooklyn-persistence-test";
    private String locationSpec = "named:brooklyn-jclouds-objstore-test-1";
    private JcloudsLocation location;
    private BlobStoreContext context;
    private ManagementContext mgmt;
    private String testContainerName;
    private String identity;
    private String credential;
    private String provider;
    private String endpoint;

    public synchronized BlobStoreContext getSwiftBlobStoreContext() {
        if (this.context == null) {
            if (this.location == null) {
                Preconditions.checkNotNull((Object)this.locationSpec, (Object)"locationSpec required for remote object store when location is null");
                Preconditions.checkNotNull((Object)this.mgmt, (Object)"mgmt required for remote object store when location is null");
                this.location = (JcloudsLocation)this.mgmt.getLocationRegistry().resolve(this.locationSpec);
            }
            this.identity = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.ACCESS_IDENTITY)), (Object)"identity must not be null");
            this.credential = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL)), (Object)"credential must not be null");
            this.provider = (String)Preconditions.checkNotNull((Object)((String)this.location.getConfig(LocationConfigKeys.CLOUD_PROVIDER)), (Object)"provider must not be null");
            this.endpoint = (String)this.location.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
            this.context = JcloudsUtil.newBlobstoreContext((String)this.provider, (String)this.endpoint, (String)this.identity, (String)this.credential);
        }
        return this.context;
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.testContainerName = "brooklyn-persistence-test-" + Identifiers.makeRandomId((int)8);
        this.mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        Entities.destroyAll((ManagementContext)this.mgmt);
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
    }

    public void testRenewAuthSucceedsInSwiftObjectStore() throws Exception {
        this.doTestRenewAuth();
    }

    protected void doTestRenewAuth() throws Exception {
        this.getSwiftBlobStoreContext();
        this.injectShortLivedTokenForSwiftAuth();
        this.context.getBlobStore().createContainerInLocation(null, this.testContainerName);
        this.assertContainerFound();
        log.info("created container, now sleeping for expiration");
        Time.sleep((Duration)Duration.TEN_SECONDS);
        this.assertContainerFound();
        this.context.getBlobStore().deleteContainer(this.testContainerName);
    }

    private void assertContainerFound() {
        PageSet ps = this.context.getBlobStore().list();
        BlobStoreTest.assertHasItemNamed((PageSet<? extends StorageMetadata>)ps, this.testContainerName);
    }

    private void injectShortLivedTokenForSwiftAuth() throws Exception {
        URL endpointUrl = new URL(this.endpoint);
        HttpToolResponse tokenHttpResponse1 = BlobStoreExpiryTest.requestTokenWithExplicitLifetime(endpointUrl, this.identity, this.credential, Duration.FIVE_SECONDS);
        ImmutableMap.Builder servicesMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : tokenHttpResponse1.getHeaderLists().entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().endsWith("-Url".toLowerCase()) && !((String)entry.getKey()).toLowerCase().endsWith("X-Auth-Token-Expires".toLowerCase())) continue;
            servicesMapBuilder.put((Object)((String)entry.getKey()), (Object)URI.create((String)((List)entry.getValue()).iterator().next()));
        }
        AuthenticationResponse authResponse = new AuthenticationResponse((String)((List)tokenHttpResponse1.getHeaderLists().get("X-Auth-Token")).get(0), (Map)servicesMapBuilder.build());
        this.getAuthCache().put((Object)new Credentials(this.identity, this.credential), (Object)authResponse);
    }

    private LoadingCache<Credentials, AuthenticationResponse> getAuthCache() {
        return ((CachePeeker)this.context.utils().injector().getInstance(CachePeeker.class)).authenticationResponseCache;
    }

    public static HttpToolResponse requestTokenWithExplicitLifetime(URL url, String user, String key, Duration expiration) throws URISyntaxException {
        HttpClient client = HttpTool.httpClientBuilder().build();
        HttpToolResponse response = HttpTool.httpGet((HttpClient)client, (URI)url.toURI(), (Map)MutableMap.of().add((Object)"X-Auth-User", (Object)user).add((Object)"X-Auth-Key", (Object)key).add((Object)"Host", (Object)url.getHost()).add((Object)"X-Auth-New-Token", (Object)"true").add((Object)"X-Auth-Token-Lifetime", (Object)("" + expiration.toSeconds())));
        log.info("Requested token with explicit lifetime: " + expiration + " at " + url + "\n" + response + "\n" + response.getHeaderLists());
        return response;
    }

    public static class CachePeeker {
        private final LoadingCache<Credentials, AuthenticationResponse> authenticationResponseCache;

        @Inject
        protected CachePeeker(LoadingCache<Credentials, AuthenticationResponse> authenticationResponseCache) {
            this.authenticationResponseCache = authenticationResponseCache;
        }
    }
}

