/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.base.Preconditions;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreCleaner {
    private static String locationSpec = "named:brooklyn-jclouds-objstore-test-1";
    private static final Logger log = LoggerFactory.getLogger(BlobStoreCleaner.class);

    public static void main(String[] args) {
        LocalManagementContextForTests mgmt = new LocalManagementContextForTests(BrooklynProperties.Factory.newDefault());
        JcloudsLocation location = (JcloudsLocation)mgmt.getLocationRegistry().resolve(locationSpec);
        String identity = (String)Preconditions.checkNotNull((Object)((String)location.getConfig(LocationConfigKeys.ACCESS_IDENTITY)), (Object)"identity must not be null");
        String credential = (String)Preconditions.checkNotNull((Object)((String)location.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL)), (Object)"credential must not be null");
        String provider = (String)Preconditions.checkNotNull((Object)((String)location.getConfig(LocationConfigKeys.CLOUD_PROVIDER)), (Object)"provider must not be null");
        String endpoint = (String)location.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
        BlobStoreContext context = (BlobStoreContext)ContextBuilder.newBuilder((String)provider).credentials(identity, credential).endpoint(endpoint).buildView(BlobStoreContext.class);
        PageSet containers = context.getBlobStore().list();
        for (StorageMetadata container : containers) {
            if (container.getName().matches("brooklyn.*-test.*")) {
                log.info("killing - " + container.getName());
                context.getBlobStore().deleteContainer(container.getName());
                continue;
            }
            log.info("KEEPING - " + container.getName());
        }
        context.close();
    }
}

