/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.config.BrooklynProperties;
import brooklyn.entity.basic.Entities;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.launcher.BrooklynServerDetails;
import brooklyn.launcher.BrooklynWebServer;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.test.HttpTestUtils;
import brooklyn.test.TestResourceUnavailableException;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class WebAppRunnerTest {
    public static final Logger log = LoggerFactory.getLogger(WebAppRunnerTest.class);
    List<LocalManagementContext> managementContexts = Lists.newCopyOnWriteArrayList();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (LocalManagementContext managementContext : this.managementContexts) {
            Entities.destroyAll((ManagementContext)managementContext);
        }
        this.managementContexts.clear();
    }

    LocalManagementContext newManagementContext(BrooklynProperties brooklynProperties) {
        LocalManagementContext result = new LocalManagementContext(brooklynProperties);
        this.managementContexts.add(result);
        return result;
    }

    BrooklynWebServer createWebServer(Map properties) {
        MutableMap bigProps = MutableMap.copyOf((Map)properties);
        MutableMap attributes = MutableMap.copyOf((Map)((Map)bigProps.get("attributes")));
        bigProps.put("attributes", attributes);
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newEmpty();
        brooklynProperties.putAll((Map)bigProps);
        brooklynProperties.put((Object)"brooklyn.webconsole.security.provider", (Object)"brooklyn.rest.security.provider.AnyoneSecurityProvider");
        brooklynProperties.put((Object)"brooklyn.webconsole.security.https.required", (Object)"false");
        return new BrooklynWebServer((Map)bigProps, (ManagementContext)this.newManagementContext(brooklynProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartWar1() throws Exception {
        if (!Networking.isPortAvailable((int)8090)) {
            Assert.fail((String)"Another process is using port 8090 which is required for this test.");
        }
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)8090));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:8090/");
        }
        finally {
            server.stop();
        }
    }

    public static void assertBrooklynEventuallyAt(String url) {
        HttpTestUtils.assertContentEventuallyContainsText((String)url, (String)"Brooklyn Web Console", (String[])new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartSecondaryWar() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        if (!Networking.isPortAvailable((int)8090)) {
            Assert.fail((String)"Another process is using port 8090 which is required for this test.");
        }
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)8090, (Object)"war", (Object)"brooklyn.war", (Object)"wars", (Object)MutableMap.of((Object)"hello", (Object)"hello-world.war")));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:8090/");
            HttpTestUtils.assertContentEventuallyContainsText((String)"http://localhost:8090/hello", (String)"This is the home page for a sample application", (String[])new String[0]);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartSecondaryWarAfter() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        if (!Networking.isPortAvailable((int)8090)) {
            Assert.fail((String)"Another process is using port 8090 which is required for this test.");
        }
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)8090, (Object)"war", (Object)"brooklyn.war"));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            server.deploy("/hello", "hello-world.war");
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:8090/");
            HttpTestUtils.assertContentEventuallyContainsText((String)"http://localhost:8090/hello", (String)"This is the home page for a sample application", (String[])new String[0]);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartWithLauncher() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        BrooklynLauncher launcher = BrooklynLauncher.newInstance().brooklynProperties(BrooklynProperties.Factory.newEmpty()).brooklynProperties("brooklyn.webconsole.security.provider", (Object)"brooklyn.rest.security.provider.AnyoneSecurityProvider").webapp("/hello", "hello-world.war").start();
        BrooklynServerDetails details = launcher.getServerDetails();
        try {
            details.getWebServer().deploy("/hello2", "hello-world.war");
            WebAppRunnerTest.assertBrooklynEventuallyAt(details.getWebServerUrl());
            HttpTestUtils.assertContentEventuallyContainsText((String)(details.getWebServerUrl() + "hello"), (String)"This is the home page for a sample application", (String[])new String[0]);
            HttpTestUtils.assertContentEventuallyContainsText((String)(details.getWebServerUrl() + "hello2"), (String)"This is the home page for a sample application", (String[])new String[0]);
            HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)(details.getWebServerUrl() + "hello0"), (int)404);
        }
        finally {
            details.getWebServer().stop();
            ((ManagementContextInternal)details.getManagementContext()).terminate();
        }
    }
}

