/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.catalog.internal.CatalogInitialization;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.entity.Application;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.RebindTestUtils;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.location.Location;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.test.HttpTestUtils;
import brooklyn.test.entity.LocalManagementContextForTests;
import brooklyn.test.entity.TestApplication;
import brooklyn.test.entity.TestApplicationImpl;
import brooklyn.test.entity.TestEntity;
import brooklyn.util.exceptions.FatalRuntimeException;
import brooklyn.util.io.FileUtil;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.api.client.util.Preconditions;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BrooklynLauncherTest {
    private BrooklynLauncher launcher;
    private File persistenceDir;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.launcher != null) {
            this.launcher.terminate();
        }
        if (this.persistenceDir != null) {
            RebindTestUtils.deleteMementoDir((File)this.persistenceDir);
        }
        this.launcher = null;
    }

    @Test(groups={"Integration"})
    public void testStartsWebServerOnExpectectedPort() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsolePort("10000+").start();
        String webServerUrlStr = this.launcher.getServerDetails().getWebServerUrl();
        URI webServerUri = new URI(webServerUrlStr);
        Assert.assertEquals((Collection)this.launcher.getApplications(), (Collection)ImmutableList.of());
        Assert.assertTrue((webServerUri.getPort() >= 10000 && webServerUri.getPort() < 10100 ? 1 : 0) != 0, (String)("port=" + webServerUri.getPort() + "; uri=" + webServerUri));
        HttpTestUtils.assertUrlReachable((String)webServerUrlStr);
    }

    @Test(groups={"Integration"})
    public void testWebServerTempDirRespectsDataDirConfig() throws Exception {
        String dataDirName = ".brooklyn-foo" + Strings.makeRandomId((int)4);
        String dataDir = "~/" + dataDirName;
        this.launcher = this.newLauncherForTests(true).brooklynProperties(BrooklynServerConfig.MGMT_BASE_DIR, (Object)dataDir).start();
        ManagementContext managementContext = this.launcher.getServerDetails().getManagementContext();
        String expectedTempDir = Os.mergePaths((String[])new String[]{Os.home(), dataDirName, "planes", managementContext.getManagementPlaneId(), managementContext.getManagementNodeId(), "jetty"});
        File webappTempDir = this.launcher.getServerDetails().getWebServer().getWebappTempDir();
        Assert.assertEquals((String)webappTempDir.getAbsolutePath(), (String)expectedTempDir);
    }

    @Test
    public void testCanDisableWebServerStartup() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).start();
        Assert.assertNull((Object)this.launcher.getServerDetails().getWebServer());
        Assert.assertNull((Object)this.launcher.getServerDetails().getWebServerUrl());
        Assert.assertTrue((boolean)((ManagementContextInternal)this.launcher.getServerDetails().getManagementContext()).errors().isEmpty());
    }

    @Test
    public void testStartsAppInstance() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).application((Application)new TestApplicationImpl()).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromSpec() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).application(EntitySpec.create(TestApplication.class)).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromBuilder() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).application(new ApplicationBuilder(EntitySpec.create(TestApplication.class)){

            protected void doBuild() {
            }
        }).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromYAML() throws Exception {
        String yaml = "name: example-app\nservices:\n- serviceType: brooklyn.test.entity.TestEntity\n  name: test-app";
        this.launcher = this.newLauncherForTests(true).webconsole(false).application(yaml).start();
        Assert.assertEquals((int)this.launcher.getApplications().size(), (int)1, (String)("apps=" + this.launcher.getApplications()));
        Application app = (Application)Iterables.getOnlyElement((Iterable)this.launcher.getApplications());
        Assert.assertEquals((int)app.getChildren().size(), (int)1, (String)("children=" + app.getChildren()));
        Assert.assertTrue((boolean)(Iterables.getOnlyElement((Iterable)app.getChildren()) instanceof TestEntity));
    }

    @Test
    public void testStartsAppInSuppliedLocations() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).location("localhost").application(new ApplicationBuilder(EntitySpec.create(TestApplication.class)){

            protected void doBuild() {
            }
        }).start();
        Application app = (Application)Iterables.find((Iterable)this.launcher.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class));
        this.assertOnlyLocation(app, LocalhostMachineProvisioningLocation.class);
    }

    @Test
    public void testUsesSuppliedManagementContext() throws Exception {
        LocalManagementContext myManagementContext = LocalManagementContextForTests.newInstance();
        this.launcher = this.newLauncherForTests(false).webconsole(false).managementContext((ManagementContext)myManagementContext).start();
        Assert.assertSame((Object)this.launcher.getServerDetails().getManagementContext(), (Object)myManagementContext);
    }

    @Test
    public void testUsesSuppliedBrooklynProperties() throws Exception {
        BrooklynProperties props = LocalManagementContextForTests.builder((boolean)true).buildProperties();
        props.put((Object)"mykey", (Object)"myval");
        this.launcher = this.newLauncherForTests(false).webconsole(false).brooklynProperties(props).start();
        Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    @Test
    public void testUsesSupplementaryBrooklynProperties() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).brooklynProperties("mykey", (Object)"myval").start();
        Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    @Test
    public void testReloadBrooklynPropertiesRestoresProgrammaticProperties() throws Exception {
        this.launcher = this.newLauncherForTests(true).webconsole(false).brooklynProperties("mykey", (Object)"myval").start();
        LocalManagementContext managementContext = (LocalManagementContext)this.launcher.getServerDetails().getManagementContext();
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
        managementContext.getBrooklynProperties().put((Object)"mykey", (Object)"newval");
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"newval");
        managementContext.reloadBrooklynProperties();
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadBrooklynPropertiesFromFile() throws Exception {
        File globalPropertiesFile = File.createTempFile("local-brooklyn-properties-test", ".properties");
        FileUtil.setFilePermissionsTo600((File)globalPropertiesFile);
        try {
            String property = "mykey=myval";
            Files.append((CharSequence)(this.getMinimalLauncherPropertiesString() + property), (File)globalPropertiesFile, (Charset)Charsets.UTF_8);
            this.launcher = this.newLauncherForTests(false).webconsole(false).globalBrooklynPropertiesFile(globalPropertiesFile.getAbsolutePath()).start();
            LocalManagementContext managementContext = (LocalManagementContext)this.launcher.getServerDetails().getManagementContext();
            Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
            property = "mykey=newval";
            Files.write((CharSequence)(this.getMinimalLauncherPropertiesString() + property), (File)globalPropertiesFile, (Charset)Charsets.UTF_8);
            managementContext.reloadBrooklynProperties();
            Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"newval");
        }
        finally {
            globalPropertiesFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testChecksGlobalBrooklynPropertiesPermissionsX00() throws Exception {
        File propsFile = File.createTempFile("testChecksGlobalBrooklynPropertiesPermissionsX00", ".properties");
        propsFile.setReadable(true, false);
        try {
            this.launcher = this.newLauncherForTests(false).webconsole(false).globalBrooklynPropertiesFile(propsFile.getAbsolutePath()).start();
            Assert.fail((String)"Should have thrown");
        }
        catch (FatalRuntimeException e) {
            if (!e.toString().contains("Invalid permissions for file")) {
                throw e;
            }
        }
        finally {
            propsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testChecksLocalBrooklynPropertiesPermissionsX00() throws Exception {
        File propsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00", ".properties");
        propsFile.setReadable(true, false);
        try {
            this.launcher = this.newLauncherForTests(false).webconsole(false).localBrooklynPropertiesFile(propsFile.getAbsolutePath()).start();
            Assert.fail((String)"Should have thrown");
        }
        catch (FatalRuntimeException e) {
            if (!e.toString().contains("Invalid permissions for file")) {
                throw e;
            }
        }
        finally {
            propsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testStartsWithBrooklynPropertiesPermissionsX00() throws Exception {
        File globalPropsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00_global", ".properties");
        Files.write((CharSequence)(this.getMinimalLauncherPropertiesString() + "key_in_global=1"), (File)globalPropsFile, (Charset)Charset.defaultCharset());
        File localPropsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00_local", ".properties");
        Files.write((CharSequence)"key_in_local=2", (File)localPropsFile, (Charset)Charset.defaultCharset());
        FileUtil.setFilePermissionsTo600((File)globalPropsFile);
        FileUtil.setFilePermissionsTo600((File)localPropsFile);
        try {
            this.launcher = this.newLauncherForTests(false).webconsole(false).localBrooklynPropertiesFile(localPropsFile.getAbsolutePath()).globalBrooklynPropertiesFile(globalPropsFile.getAbsolutePath()).start();
            Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"key_in_global"}), (String)"1");
            Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"key_in_local"}), (String)"2");
        }
        finally {
            globalPropsFile.delete();
            localPropsFile.delete();
        }
    }

    @Test
    public void testErrorsCaughtByApiAndRestApiWorks() throws Exception {
        this.launcher = this.newLauncherForTests(true).catalogInitialization(new CatalogInitialization(null, false, null, false).addPopulationCallback((Function)new Function<CatalogInitialization, Void>(){

            public Void apply(CatalogInitialization input) {
                throw new RuntimeException("deliberate-exception-for-testing");
            }
        })).start();
        ManagementContext mgmt = this.launcher.getServerDetails().getManagementContext();
        Assert.assertFalse((boolean)((ManagementContextInternal)mgmt).errors().isEmpty());
        Assert.assertTrue((boolean)((Throwable)((ManagementContextInternal)mgmt).errors().get(0)).toString().contains("deliberate"), (String)("" + ((ManagementContextInternal)mgmt).errors()));
        HttpTestUtils.assertContentMatches((String)Urls.mergePaths((String[])new String[]{this.launcher.getServerDetails().getWebServerUrl(), "v1/server/up"}), (String)"true");
        HttpTestUtils.assertContentMatches((String)Urls.mergePaths((String[])new String[]{this.launcher.getServerDetails().getWebServerUrl(), "v1/server/healthy"}), (String)"false");
    }

    private BrooklynLauncher newLauncherForTests(boolean minimal) {
        Preconditions.checkArgument((this.launcher == null ? 1 : 0) != 0, (Object)"can only be used if no launcher yet");
        BrooklynLauncher launcher = BrooklynLauncher.newInstance();
        if (minimal) {
            launcher.brooklynProperties(LocalManagementContextForTests.builder((boolean)true).buildProperties());
        }
        return launcher;
    }

    private String getMinimalLauncherPropertiesString() throws IOException {
        BrooklynProperties p1 = LocalManagementContextForTests.builder((boolean)true).buildProperties();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)Maps.transformValues((Map)p1.asMapWithStringKeys(), (Function)StringFunctions.toStringFunction()));
        StringWriter w = new StringWriter();
        p.store(w, "test");
        ((Writer)w).close();
        return ((Object)w).toString() + "\n";
    }

    private void assertOnlyApp(BrooklynLauncher launcher, Class<? extends Application> expectedType) {
        Assert.assertEquals((int)launcher.getApplications().size(), (int)1, (String)("apps=" + launcher.getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)launcher.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class), null), (String)("apps=" + launcher.getApplications()));
    }

    private void assertOnlyLocation(Application app, Class<? extends Location> expectedType) {
        Assert.assertEquals((int)app.getLocations().size(), (int)1, (String)("locs=" + app.getLocations()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)app.getLocations(), (Predicate)Predicates.instanceOf(LocalhostMachineProvisioningLocation.class), null), (String)("locs=" + app.getLocations()));
    }
}

