/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServerPaths;
import brooklyn.config.StringConfigMap;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.persister.FileBasedObjectStore;
import brooklyn.entity.rebind.persister.PersistMode;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.launcher.BrooklynLauncherRebindTestFixture;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.test.entity.TestApplication;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.os.Os;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynLauncherRebindTestToFiles
extends BrooklynLauncherRebindTestFixture {
    @Override
    protected String newTempPersistenceContainerName() {
        File persistenceDirF = Files.createTempDir();
        Os.deleteOnExitRecursively((File)persistenceDirF);
        return persistenceDirF.getAbsolutePath();
    }

    @Override
    protected String badContainerName() {
        return "/path/does/not/exist/" + Identifiers.makeRandomId((int)4);
    }

    @Override
    protected void checkPersistenceContainerNameIs(String expected) {
        String expectedFqp = new File(Os.tidyPath((String)expected)).getAbsolutePath();
        Assert.assertEquals((String)BrooklynLauncherRebindTestToFiles.getPersistenceDir(this.lastMgmt()).getAbsolutePath(), (String)expectedFqp);
    }

    static File getPersistenceDir(ManagementContext managementContext) {
        BrooklynMementoPersisterToObjectStore persister = (BrooklynMementoPersisterToObjectStore)managementContext.getRebindManager().getPersister();
        FileBasedObjectStore store = (FileBasedObjectStore)persister.getObjectStore();
        return store.getBaseDir();
    }

    @Override
    protected void checkPersistenceContainerNameIsDefault() {
        String expected = BrooklynServerPaths.newMainPersistencePathResolver((StringConfigMap)BrooklynProperties.Factory.newEmpty()).location(null).dir(null).resolve();
        this.checkPersistenceContainerNameIs(expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistenceFailsIfIsFile() throws Exception {
        File tempF = File.createTempFile("test-" + JavaClassNames.niceClassAndMethod(), ".not_dir");
        tempF.deleteOnExit();
        String tempFileName = tempF.getAbsolutePath();
        try {
            this.runRebindFails(PersistMode.AUTO, tempFileName, "must not be a file");
            this.runRebindFails(PersistMode.REBIND, tempFileName, "must not be a file");
            this.runRebindFails(PersistMode.CLEAN, tempFileName, "must not be a file");
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistenceFailsIfNotWritable() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        new File(this.persistenceDir).setWritable(false);
        try {
            this.runRebindFails(PersistMode.AUTO, this.persistenceDir, "not writable");
            this.runRebindFails(PersistMode.REBIND, this.persistenceDir, "not writable");
            this.runRebindFails(PersistMode.CLEAN, this.persistenceDir, "not writable");
        }
        finally {
            new File(this.persistenceDir).setWritable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistenceFailsIfNotReadable() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        new File(this.persistenceDir).setReadable(false);
        try {
            this.runRebindFails(PersistMode.AUTO, this.persistenceDir, "not readable");
            this.runRebindFails(PersistMode.REBIND, this.persistenceDir, "not readable");
            this.runRebindFails(PersistMode.CLEAN, this.persistenceDir, "not readable");
        }
        finally {
            new File(this.persistenceDir).setReadable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testCopyPersistedState() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        File destinationDir = Files.createTempDir();
        String destination = destinationDir.getAbsolutePath();
        String destinationLocation = null;
        try {
            BrooklynLauncher launcher = this.newLauncherDefault(PersistMode.AUTO).highAvailabilityMode(HighAvailabilityMode.MASTER).webconsole(false);
            launcher.copyPersistedState(destination, destinationLocation);
            launcher.terminate();
            File entities = new File(Os.mergePaths((String[])new String[]{destination}), "entities");
            Assert.assertTrue((boolean)entities.isDirectory(), (String)"entities directory should exist");
            Assert.assertEquals((int)entities.listFiles().length, (int)1, (String)("entities directory should contain one file (contained: " + Joiner.on((String)", ").join((Object[])entities.listFiles()) + ")"));
            File nodes = new File(Os.mergePaths((String[])new String[]{destination, "nodes"}));
            Assert.assertTrue((boolean)nodes.isDirectory(), (String)"nodes directory should exist");
            Assert.assertNotEquals((Object)nodes.listFiles().length, (Object)0, (String)"nodes directory should not be empty");
            this.newLauncherDefault(PersistMode.AUTO).webconsole(false).persistenceDir(destinationDir).start();
            this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        }
        finally {
            Os.deleteRecursively((File)destinationDir);
        }
    }
}

