/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.entity.Application;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.persister.PersistMode;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.launcher.BrooklynLauncher;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.test.Asserts;
import brooklyn.test.entity.LocalManagementContextForTests;
import brooklyn.test.entity.TestApplication;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import brooklyn.util.time.Duration;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class BrooklynLauncherRebindTestFixture {
    private static final Logger log = LoggerFactory.getLogger(BrooklynLauncherRebindTestFixture.class);
    protected String persistenceDir;
    protected String persistenceLocationSpec;
    protected List<BrooklynLauncher> launchers = MutableList.of();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.persistenceDir = this.newTempPersistenceContainerName();
    }

    protected abstract String newTempPersistenceContainerName();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (BrooklynLauncher l : this.launchers) {
            if (!l.isStarted()) continue;
            l.terminate();
            PersistenceObjectStore store = BrooklynLauncherRebindTestFixture.getPersistenceStore(l.getServerDetails().getManagementContext());
            if (store == null) continue;
            store.deleteCompletely();
        }
    }

    protected BrooklynLauncher newLauncherBase() {
        BrooklynLauncher l = BrooklynLauncher.newInstance().webconsole(false);
        this.launchers.add(l);
        return l;
    }

    protected BrooklynLauncher newLauncherDefault(PersistMode mode) {
        return this.newLauncherBase().managementContext((ManagementContext)this.newManagementContextForTests(null)).persistMode(mode).persistenceDir(this.persistenceDir).persistPeriod(Duration.millis((Number)10));
    }

    protected LocalManagementContextForTests newManagementContextForTests(BrooklynProperties props) {
        if (props == null) {
            return new LocalManagementContextForTests();
        }
        return new LocalManagementContextForTests(props);
    }

    protected ManagementContext lastMgmt() {
        return ((BrooklynLauncher)Iterables.getLast(this.launchers)).getServerDetails().getManagementContext();
    }

    @Test
    public void testRebindsToExistingApp() throws Exception {
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)((EntitySpec)EntitySpec.create(TestApplication.class).displayName("myorig")));
        this.newLauncherDefault(PersistMode.REBIND).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        Assert.assertNotNull((Object)Iterables.find((Iterable)this.lastMgmt().getApplications(), (Predicate)EntityPredicates.displayNameEqualTo((String)"myorig"), null), (String)("apps=" + this.lastMgmt().getApplications()));
    }

    @Test
    public void testRebindCanAddNewApps() throws Exception {
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)((EntitySpec)EntitySpec.create(TestApplication.class).displayName("myorig")));
        this.newLauncherDefault(PersistMode.REBIND).application((EntitySpec)EntitySpec.create(TestApplication.class).displayName("mynew")).start();
        Assert.assertEquals((int)this.lastMgmt().getApplications().size(), (int)2, (String)("apps=" + this.lastMgmt().getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)this.lastMgmt().getApplications(), (Predicate)EntityPredicates.displayNameEqualTo((String)"mynew"), null), (String)("apps=" + this.lastMgmt().getApplications()));
        StartableApplication app3 = (StartableApplication)this.lastMgmt().getEntityManager().createEntity((EntitySpec)EntitySpec.create(TestApplication.class).displayName("mynew2"));
        app3.start((Collection)ImmutableList.of());
    }

    @Test
    public void testAutoRebindsToExistingApp() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        this.newLauncherDefault(PersistMode.AUTO).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
    }

    @Test
    public void testCleanDoesNotRebindToExistingApp() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        this.newLauncherDefault(PersistMode.CLEAN).start();
        Assert.assertTrue((boolean)this.lastMgmt().getApplications().isEmpty(), (String)("apps=" + this.lastMgmt().getApplications()));
    }

    @Test
    public void testAutoRebindCreatesNewIfEmptyDir() throws Exception {
        this.newLauncherDefault(PersistMode.AUTO).application(EntitySpec.create(TestApplication.class)).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        this.assertMementoContainerNonEmptyForTypeEventually("entities");
    }

    @Test
    public void testRebindRespectsPersistenceDirSetInProperties() throws Exception {
        String persistenceDir2 = this.newTempPersistenceContainerName();
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newDefault();
        brooklynProperties.put(BrooklynServerConfig.PERSISTENCE_DIR, (Object)persistenceDir2);
        LocalManagementContextForTests mgmt = this.newManagementContextForTests(brooklynProperties);
        this.newLauncherBase().persistMode(PersistMode.AUTO).persistPeriod(Duration.millis((Number)10)).managementContext((ManagementContext)mgmt).start();
        this.checkPersistenceContainerNameIs(persistenceDir2);
    }

    @Test(groups={"Integration"})
    public void testRebindRespectsDefaultPersistenceDir() throws Exception {
        this.newLauncherDefault(PersistMode.AUTO).persistenceDir((String)null).start();
        this.checkPersistenceContainerNameIsDefault();
    }

    protected abstract void checkPersistenceContainerNameIsDefault();

    protected abstract void checkPersistenceContainerNameIs(String var1);

    @Test
    public void testPersistenceFailsIfNoDir() throws Exception {
        this.runRebindFails(PersistMode.REBIND, this.badContainerName(), "does not exist");
    }

    protected abstract String badContainerName();

    @Test
    public void testExplicitRebindFailsIfEmpty() throws Exception {
        this.runRebindFails(PersistMode.REBIND, this.persistenceDir, "directory is empty");
    }

    protected void runRebindFails(PersistMode persistMode, String dir, String errmsg) throws Exception {
        block2: {
            try {
                this.newLauncherDefault(persistMode).persistenceDir(dir).start();
            }
            catch (FatalConfigurationRuntimeException e) {
                if (e.toString().contains(errmsg)) break block2;
                throw e;
            }
        }
    }

    protected void populatePersistenceDir(String dir, EntitySpec<? extends StartableApplication> appSpec) throws Exception {
        BrooklynLauncher launcher = this.newLauncherDefault(PersistMode.CLEAN).highAvailabilityMode(HighAvailabilityMode.MASTER).persistenceDir(dir).application(appSpec).start();
        launcher.terminate();
        this.assertMementoContainerNonEmptyForTypeEventually("entities");
    }

    protected void assertOnlyApp(ManagementContext managementContext, Class<? extends Application> expectedType) {
        Assert.assertEquals((int)managementContext.getApplications().size(), (int)1, (String)("apps=" + managementContext.getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)managementContext.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class), null), (String)("apps=" + managementContext.getApplications()));
    }

    protected void assertMementoContainerNonEmptyForTypeEventually(final String type) {
        Asserts.succeedsEventually((Map)ImmutableMap.of((Object)"timeout", (Object)Duration.TEN_SECONDS), (Runnable)new Runnable(){

            @Override
            public void run() {
                BrooklynLauncherRebindTestFixture.getPersistenceStore(BrooklynLauncherRebindTestFixture.this.lastMgmt()).listContentsWithSubPath(type);
            }
        });
    }

    static PersistenceObjectStore getPersistenceStore(ManagementContext managementContext) {
        if (managementContext == null) {
            return null;
        }
        BrooklynMementoPersisterToObjectStore persister = (BrooklynMementoPersisterToObjectStore)managementContext.getRebindManager().getPersister();
        if (persister == null) {
            return null;
        }
        return persister.getObjectStore();
    }
}

