/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.brooklynnode.BrooklynEntityMirror;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.SameBrooklynNodeImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.launcher.SimpleYamlLauncherForTests;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.test.EntityTestUtils;
import brooklyn.test.HttpTestUtils;
import brooklyn.test.entity.TestApplication;
import brooklyn.test.entity.TestEntity;
import brooklyn.util.collections.Jsonya;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.http.HttpTool;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.net.Urls;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.time.Duration;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynNodeRestTest {
    private static final Logger log = LoggerFactory.getLogger(BrooklynNodeRestTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"WIP"})
    public void testBrooklynNodeRestDeployAndMirror() {
        final SimpleYamlLauncherForTests l = new SimpleYamlLauncherForTests();
        try {
            TestApplication app = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)l.getManagementContext());
            BrooklynNode bn = (BrooklynNode)app.createAndManageChild(EntitySpec.create(BrooklynNode.class, SameBrooklynNodeImpl.class));
            bn.start((Collection)MutableSet.of());
            URI uri = (URI)bn.getAttribute(BrooklynNode.WEB_CONSOLE_URI);
            Assert.assertNotNull((Object)uri);
            EntityTestUtils.assertAttributeEqualsEventually((Entity)bn, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            log.info("Created BrooklynNode: " + bn);
            Task t = bn.invoke(BrooklynNode.DEPLOY_BLUEPRINT, ConfigBag.newInstance().configure(BrooklynNode.DeployBlueprintEffector.BLUEPRINT_TYPE, (Object)TestApplication.class.getName()).configure(BrooklynNode.DeployBlueprintEffector.BLUEPRINT_CONFIG, (Object)MutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)"Y")).getAllConfig());
            log.info("Deployment result: " + t.getUnchecked());
            MutableSet apps = MutableSet.copyOf((Iterable)l.getManagementContext().getApplications());
            Assert.assertEquals((int)apps.size(), (int)2);
            apps.remove((Object)app);
            Application newApp = (Application)Iterables.getOnlyElement((Iterable)apps);
            Entities.dumpInfo((Entity)newApp);
            Assert.assertEquals((Object)newApp.getConfig((ConfigKey)new BasicConfigKey(Integer.class, "x")), (Object)1);
            String newAppId = newApp.getId();
            BrooklynEntityMirror mirror = (BrooklynEntityMirror)app.createAndManageChild(EntitySpec.create(BrooklynEntityMirror.class).configure(BrooklynEntityMirror.MIRRORED_ENTITY_URL, (Object)Urls.mergePaths((String[])new String[]{uri.toString(), "/v1/applications/" + newAppId + "/entities/" + newAppId})).configure(BrooklynEntityMirror.MIRRORED_ENTITY_ID, (Object)newAppId).configure(BrooklynEntityMirror.POLL_PERIOD, (Object)Duration.millis((Number)10)));
            Entities.dumpInfo((Entity)mirror);
            EntityTestUtils.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            ((EntityInternal)newApp).setAttribute(TestEntity.NAME, (Object)"foo");
            EntityTestUtils.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestEntity.NAME, (Object)"foo");
            log.info("Mirror successfully validated");
            HttpClient client = HttpTool.httpClientBuilder().build();
            HttpToolResponse result = HttpTool.httpPost((HttpClient)client, (URI)URI.create(Urls.mergePaths((String[])new String[]{uri.toString(), "/v1/applications/" + app.getId() + "/entities/" + bn.getId() + "/effectors/deployBlueprint"})), (Map)MutableMap.of((Object)"Content-Type", (Object)"application/json"), (byte[])Jsonya.newInstance().put((Object)"blueprintType", (Object)TestApplication.class.getName(), new Object[0]).put((Object)"blueprintConfig", (Object)MutableMap.of((Object)TestEntity.CONF_NAME.getName(), (Object)"foo"), new Object[0]).toString().getBytes());
            log.info("Deploy effector invoked, result: " + result);
            HttpTestUtils.assertHealthyStatusCode((int)result.getResponseCode());
            Repeater.create().every(Duration.millis((Number)10)).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return l.getManagementContext().getApplications().size() == 3;
                }
            }).limitTimeTo(Duration.TEN_SECONDS).runRequiringTrue();
            apps = MutableSet.copyOf((Iterable)l.getManagementContext().getApplications());
            apps.removeAll((Collection)MutableSet.of((Object)app, (Object)newApp));
            Application newApp2 = (Application)Iterables.getOnlyElement((Iterable)apps);
            Entities.dumpInfo((Entity)newApp2);
            EntityTestUtils.assertAttributeEqualsEventually((Entity)newApp2, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            Assert.assertEquals((String)((String)newApp2.getConfig(TestEntity.CONF_NAME)), (String)"foo");
        }
        finally {
            l.destroyAll();
        }
        log.info("DONE");
    }
}

