/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.launcher;

import brooklyn.BrooklynVersion;
import brooklyn.config.BrooklynServerPaths;
import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.internal.BrooklynInitialization;
import brooklyn.launcher.config.CustomResourceLocator;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.location.basic.PortRanges;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.rest.BrooklynRestApi;
import brooklyn.rest.BrooklynWebConfig;
import brooklyn.rest.filter.BrooklynPropertiesSecurityFilter;
import brooklyn.rest.filter.HaHotCheckResourceFilter;
import brooklyn.rest.filter.HaMasterCheckFilter;
import brooklyn.rest.filter.LoggingFilter;
import brooklyn.rest.filter.NoCacheFilter;
import brooklyn.rest.filter.RequestTaggingFilter;
import brooklyn.rest.util.ManagementContextProvider;
import brooklyn.util.BrooklynNetworkUtils;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.crypto.FluentKeySigner;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.io.FileUtil;
import brooklyn.util.javalang.Threads;
import brooklyn.util.logging.LoggingSetup;
import brooklyn.util.os.Os;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.web.ContextHandlerCollectionHotSwappable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sun.jersey.api.container.filter.GZIPContentEncodingFilter;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynWebServer {
    private static final Logger log = LoggerFactory.getLogger(BrooklynWebServer.class);
    public static final String BROOKLYN_WAR_URL = "classpath://brooklyn.war";
    protected Server server;
    private WebAppContext rootContext;
    @SetFromFlag(value="port")
    protected PortRange requestedPort = null;
    @SetFromFlag
    protected PortRange httpPort = PortRanges.fromString((String)"8081+");
    @SetFromFlag
    protected PortRange httpsPort = PortRanges.fromString((String)"8443+");
    protected volatile int actualPort = -1;
    protected InetAddress actualAddress = null;
    @SetFromFlag
    protected String war = "classpath://brooklyn.war";
    @SetFromFlag
    protected InetAddress bindAddress = null;
    @SetFromFlag
    protected InetAddress publicAddress = null;
    @SetFromFlag
    private Map<String, String> wars = new LinkedHashMap<String, String>();
    @SetFromFlag
    protected boolean ignoreWebappDeploymentFailures = false;
    @SetFromFlag
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private ManagementContext managementContext;
    @SetFromFlag
    private Boolean httpsEnabled;
    @SetFromFlag
    private String sslCertificate;
    @SetFromFlag
    private String keystoreUrl;
    @SetFromFlag
    @Deprecated
    private String keystorePath;
    @SetFromFlag
    private String keystorePassword;
    @SetFromFlag
    private String keystoreCertAlias;
    @SetFromFlag
    private String truststorePath;
    @SetFromFlag
    private String trustStorePassword;
    @SetFromFlag
    private String transportProtocols;
    @SetFromFlag
    private String transportCiphers;
    private File webappTempDir;
    private Class<BrooklynPropertiesSecurityFilter> securityFilterClazz;
    ContextHandlerCollectionHotSwappable handlers = new ContextHandlerCollectionHotSwappable();
    private Thread shutdownHook = null;

    public BrooklynWebServer(ManagementContext managementContext) {
        this(Maps.newLinkedHashMap(), managementContext);
    }

    public BrooklynWebServer(Map<?, ?> flags, ManagementContext managementContext) {
        this.managementContext = managementContext;
        Map leftovers = FlagUtils.setFieldsFromFlags(flags, (Object)this);
        if (!leftovers.isEmpty()) {
            log.warn("Ignoring unknown flags " + leftovers);
        }
        this.webappTempDir = BrooklynServerPaths.getBrooklynWebTmpDir((ManagementContext)managementContext);
    }

    public BrooklynWebServer(ManagementContext managementContext, int port) {
        this(managementContext, port, "brooklyn.war");
    }

    public BrooklynWebServer(ManagementContext managementContext, int port, String warUrl) {
        this((Map<?, ?>)MutableMap.of((Object)"port", (Object)port, (Object)"war", (Object)warUrl), managementContext);
    }

    public void setSecurityFilter(Class<BrooklynPropertiesSecurityFilter> filterClazz) {
        this.securityFilterClazz = filterClazz;
    }

    public BrooklynWebServer setPort(Object port) {
        if (this.getActualPort() > 0) {
            throw new IllegalStateException("Can't set port after port has been assigned to server (using " + this.getActualPort() + ")");
        }
        this.requestedPort = (PortRange)TypeCoercions.coerce((Object)port, PortRange.class);
        return this;
    }

    @VisibleForTesting
    File getWebappTempDir() {
        return this.webappTempDir;
    }

    public BrooklynWebServer setHttpsEnabled(Boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public boolean getHttpsEnabled() {
        return this.getConfig(this.httpsEnabled, BrooklynWebConfig.HTTPS_REQUIRED);
    }

    public PortRange getRequestedPort() {
        return this.requestedPort;
    }

    public int getActualPort() {
        return this.actualPort;
    }

    public InetAddress getAddress() {
        return this.actualAddress;
    }

    public String getRootUrl() {
        String address;
        String string = address = this.publicAddress != null ? this.publicAddress.getHostName() : this.getAddress().getHostName();
        if (this.getActualPort() > 0) {
            String protocol = this.getHttpsEnabled() ? "https" : "http";
            return protocol + "://" + address + ":" + this.getActualPort() + "/";
        }
        return null;
    }

    public BrooklynWebServer setWar(String url) {
        this.war = url;
        return this;
    }

    public BrooklynWebServer addWar(String path, String warUrl) {
        this.wars.put(path, warUrl);
        return this;
    }

    public BrooklynWebServer setBindAddress(InetAddress address) {
        this.bindAddress = address;
        return this;
    }

    public BrooklynWebServer setPublicAddress(InetAddress address) {
        this.publicAddress = address;
        return this;
    }

    public BrooklynWebServer addAttribute(String field, Object value) {
        return this.setAttribute(field, value);
    }

    public BrooklynWebServer setAttribute(String field, Object value) {
        this.attributes.put(field, value);
        return this;
    }

    public <T> BrooklynWebServer configure(ConfigKey<T> key, T value) {
        return this.setAttribute(key.getName(), value);
    }

    public BrooklynWebServer putAttributes(Map newAttrs) {
        if (newAttrs != null) {
            this.attributes.putAll(newAttrs);
        }
        return this;
    }

    public static void installAsServletFilter(ServletContextHandler context) {
        DefaultResourceConfig config = new DefaultResourceConfig();
        for (Object r : BrooklynRestApi.getAllResources()) {
            config.getSingletons().add(r);
        }
        config.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", GZIPContentEncodingFilter.class.getName());
        config.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", ImmutableList.of(GZIPContentEncodingFilter.class, NoCacheFilter.class));
        config.getProperties().put("com.sun.jersey.spi.container.ResourceFilters", HaHotCheckResourceFilter.class.getName());
        config.getProperties().put("com.sun.jersey.config.property.WebPageContentRegex", "(/?|[^?]*/assets/[^?]+\\.[A-Za-z0-9_]+)");
        config.getFeatures().put("com.sun.jersey.config.feature.FilterForwardOn404", true);
        FilterHolder filterHolder = new FilterHolder((Filter)new ServletContainer((Application)config));
        context.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
        ManagementContext mgmt = (ManagementContext)context.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        config.getSingletons().add(new ManagementContextProvider(mgmt));
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("" + this + " already running");
        }
        if (this.actualPort == -1) {
            PortRange portRange = this.getConfig(this.requestedPort, BrooklynWebConfig.WEB_CONSOLE_PORT);
            if (portRange == null) {
                portRange = this.getHttpsEnabled() ? this.httpsPort : this.httpPort;
            }
            this.actualPort = LocalhostMachineProvisioningLocation.obtainPort((InetAddress)this.getAddress(), (PortRange)portRange);
            if (this.actualPort == -1) {
                throw new IllegalStateException("Unable to provision port for web console (wanted " + portRange + ")");
            }
        }
        this.server = new Server();
        Object connector = this.getHttpsEnabled() ? new SslSelectChannelConnector(this.createContextFactory()) : new SelectChannelConnector();
        if (this.bindAddress != null) {
            connector.setHost(this.bindAddress.getHostName());
        }
        connector.setPort(this.actualPort);
        this.server.setConnectors(new Connector[]{connector});
        this.actualAddress = this.bindAddress == null || this.bindAddress.equals(InetAddress.getByAddress(new byte[]{0, 0, 0, 0})) ? BrooklynNetworkUtils.getLocalhostInetAddress() : this.bindAddress;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("brooklyn-jetty-server-" + this.actualPort + "-" + threadPool.getName());
        this.server.setThreadPool((ThreadPool)threadPool);
        if (log.isDebugEnabled()) {
            log.debug("Starting Brooklyn console at " + this.getRootUrl() + ", running " + this.war + (this.wars != null ? " and " + this.wars.values() : ""));
        }
        this.addShutdownHook();
        MutableMap allWars = MutableMap.copyOf(this.wars);
        String rootWar = (String)allWars.remove((Object)"/");
        if (rootWar == null) {
            rootWar = this.war;
        }
        for (Map.Entry entry : allWars.entrySet()) {
            String pathSpec = (String)entry.getKey();
            String warUrl = (String)entry.getValue();
            WebAppContext webapp = this.deploy(pathSpec, warUrl);
            webapp.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, this.newTimestampedDirName("war", 8))));
        }
        this.rootContext = this.deploy("/", rootWar);
        this.rootContext.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, "war-root")));
        this.rootContext.addFilter(RequestTaggingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        if (this.securityFilterClazz != null) {
            this.rootContext.addFilter(this.securityFilterClazz, "/*", EnumSet.allOf(DispatcherType.class));
        }
        this.rootContext.addFilter(LoggingFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        this.rootContext.addFilter(HaMasterCheckFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        BrooklynWebServer.installAsServletFilter((ServletContextHandler)this.rootContext);
        this.server.setHandler((Handler)this.handlers);
        this.server.start();
        BrooklynInitialization.reinitAll();
        if (this.managementContext instanceof ManagementContextInternal) {
            ((ManagementContextInternal)this.managementContext).setManagementNodeUri(new URI(this.getRootUrl()));
        }
        log.info("Started Brooklyn console at " + this.getRootUrl() + ", running " + rootWar + (allWars != null && !allWars.isEmpty() ? " and " + this.wars.values() : ""));
    }

    private SslContextFactory createContextFactory() throws KeyStoreException {
        SslContextFactory sslContextFactory = new SslContextFactory();
        String ksUrl = this.getKeystoreUrl();
        String ksPassword = this.getConfig(this.keystorePassword, BrooklynWebConfig.KEYSTORE_PASSWORD);
        String ksCertAlias = this.getConfig(this.keystoreCertAlias, BrooklynWebConfig.KEYSTORE_CERTIFICATE_ALIAS);
        String trProtos = this.getConfig(this.transportProtocols, BrooklynWebConfig.TRANSPORT_PROTOCOLS);
        String trCiphers = this.getConfig(this.transportCiphers, BrooklynWebConfig.TRANSPORT_CIPHERS);
        if (ksUrl != null) {
            sslContextFactory.setKeyStorePath(this.getLocalKeyStorePath(ksUrl));
            if (Strings.isEmpty((CharSequence)ksPassword)) {
                throw new IllegalArgumentException("Keystore password is required and non-empty if keystore is specified.");
            }
            sslContextFactory.setKeyStorePassword(ksPassword);
            if (Strings.isNonEmpty((CharSequence)ksCertAlias)) {
                sslContextFactory.setCertAlias(ksCertAlias);
            }
        } else {
            log.info("No keystore specified but https enabled; creating a default keystore");
            if (Strings.isEmpty((CharSequence)ksCertAlias)) {
                ksCertAlias = "web-console";
            }
            if (Strings.isEmpty((CharSequence)ksPassword)) {
                ksPassword = Identifiers.makeRandomId((int)8);
                log.debug("created random password " + ksPassword + " for ad hoc internal keystore");
            }
            KeyStore ks = SecureKeys.newKeyStore();
            KeyPair key = SecureKeys.newKeyPair();
            X509Certificate cert = new FluentKeySigner("brooklyn").newCertificateFor("web-console", key);
            ks.setKeyEntry(ksCertAlias, key.getPrivate(), ksPassword.toCharArray(), new Certificate[]{cert});
            sslContextFactory.setKeyStore(ks);
            sslContextFactory.setKeyStorePassword(ksPassword);
            sslContextFactory.setCertAlias(ksCertAlias);
        }
        if (!Strings.isEmpty((CharSequence)this.truststorePath)) {
            sslContextFactory.setTrustStore(this.checkFileExists(this.truststorePath, "truststore"));
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        if (Strings.isNonBlank((CharSequence)trProtos)) {
            sslContextFactory.setIncludeProtocols(this.parseArray(trProtos));
        }
        if (Strings.isNonBlank((CharSequence)trCiphers)) {
            sslContextFactory.setIncludeCipherSuites(this.parseArray(trCiphers));
        }
        return sslContextFactory;
    }

    private String[] parseArray(String list) {
        List arr = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)list);
        return arr.toArray(new String[arr.size()]);
    }

    private String getKeystoreUrl() {
        if (this.keystoreUrl != null) {
            if (Strings.isNonBlank((CharSequence)this.keystorePath) && !this.keystoreUrl.equals(this.keystorePath)) {
                log.warn("Deprecated 'keystorePath' supplied with different value than 'keystoreUrl', preferring the latter: " + this.keystorePath + " / " + this.keystoreUrl);
            }
            return this.keystoreUrl;
        }
        if (Strings.isNonBlank((CharSequence)this.keystorePath)) {
            log.warn("Deprecated 'keystorePath' used; callers should use 'keystoreUrl'");
            return this.keystorePath;
        }
        return (String)this.managementContext.getConfig().getConfig(BrooklynWebConfig.KEYSTORE_URL);
    }

    private <T> T getConfig(T override, ConfigKey<T> key) {
        if (override != null) {
            return override;
        }
        return (T)this.managementContext.getConfig().getConfig(key);
    }

    private String getLocalKeyStorePath(String keystoreUrl) {
        InputStream keystoreStream;
        ResourceUtils res = ResourceUtils.create((Object)this);
        res.checkUrlExists(keystoreUrl, BrooklynWebConfig.KEYSTORE_URL.getName());
        if (new File(keystoreUrl).exists()) {
            return keystoreUrl;
        }
        try {
            keystoreStream = res.getResourceFromUrl(keystoreUrl);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalArgumentException("Unable to access URL: " + keystoreUrl, e);
        }
        File tmp = Os.newTempFile((String)"brooklyn-keystore", (String)"ks");
        tmp.deleteOnExit();
        FileUtil.copyTo((InputStream)keystoreStream, (File)tmp);
        Streams.closeQuietly((Closeable)keystoreStream);
        return tmp.getAbsolutePath();
    }

    private String newTimestampedDirName(String prefix, int randomSuffixLength) {
        return prefix + "-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "-" + Identifiers.makeRandomId((int)randomSuffixLength);
    }

    private String checkFileExists(String path, String name) {
        if (!new File(path).exists()) {
            throw new IllegalArgumentException("Could not find " + name + ": " + path);
        }
        return path;
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            return;
        }
        String root = this.getRootUrl();
        if (this.shutdownHook != null) {
            Threads.removeShutdownHook((Thread)this.shutdownHook);
        }
        if (log.isDebugEnabled()) {
            log.debug("Stopping Brooklyn web console at " + root + " (" + this.war + (this.wars != null ? " and " + this.wars.values() : "") + ")");
        }
        this.server.stop();
        try {
            this.server.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        LocalhostMachineProvisioningLocation.releasePort((InetAddress)this.getAddress(), (int)this.actualPort);
        this.actualPort = -1;
        if (log.isDebugEnabled()) {
            log.debug("Stopped Brooklyn web console at " + root);
        }
    }

    public WebAppContext deploy(String pathSpec, String warUrl) {
        String cleanPathSpec = pathSpec;
        while (cleanPathSpec.startsWith("/")) {
            cleanPathSpec = cleanPathSpec.substring(1);
        }
        boolean isRoot = cleanPathSpec.isEmpty();
        WebAppContext context = new WebAppContext();
        context.setAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT, (Object)this.managementContext);
        for (Map.Entry<String, Object> attributeEntry : this.attributes.entrySet()) {
            context.setAttribute(attributeEntry.getKey(), attributeEntry.getValue());
        }
        try {
            File tmpWarFile = Os.writeToTempFile((InputStream)new CustomResourceLocator((ConfigMap)this.managementContext.getConfig(), ResourceUtils.create((Object)this)).getResourceFromUrl(warUrl), (String)(isRoot ? "ROOT" : "embedded-" + cleanPathSpec), (String)".war");
            context.setWar(tmpWarFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.warn("Failed to deploy webapp " + pathSpec + " from " + warUrl + (this.ignoreWebappDeploymentFailures ? "; launching run without WAR" : " (rethrowing)") + ": " + Exceptions.collapseText((Throwable)e));
            if (!this.ignoreWebappDeploymentFailures) {
                throw new IllegalStateException("Failed to deploy webapp " + pathSpec + " from " + warUrl + ": " + Exceptions.collapseText((Throwable)e), e);
            }
            log.debug("Detail on failure to deploy webapp: " + e, (Throwable)e);
            context.setWar("/dev/null");
        }
        context.setContextPath("/" + cleanPathSpec);
        context.setParentLoaderPriority(true);
        this.deploy(context);
        return context;
    }

    protected synchronized void addShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = Threads.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                log.debug("BrooklynWebServer detected shutdown: stopping web-console");
                try {
                    BrooklynWebServer.this.stop();
                }
                catch (Exception e) {
                    log.error("Failure shutting down web-console: " + e, (Throwable)e);
                }
            }
        });
    }

    public void deploy(WebAppContext context) {
        try {
            this.handlers.updateHandler(context);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getRootContext() {
        return this.rootContext;
    }

    static {
        CustomResourceLocator.registerAlternateLocator(new CustomResourceLocator.SearchingClassPathInDevMode(BROOKLYN_WAR_URL, "/usage/launcher/target", "/usage/jsgui/target/brooklyn-jsgui-" + BrooklynVersion.get() + ".war"));
        LoggingSetup.installJavaUtilLoggingBridge();
    }
}

