/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.blueprints;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherAbstract;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.persist.FileBasedObjectStore;
import org.apache.brooklyn.core.mgmt.rebind.RebindOptions;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestUtils;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.launcher.BrooklynViewerLauncher;
import org.apache.brooklyn.launcher.SimpleYamlLauncherForTests;
import org.apache.brooklyn.launcher.camp.BrooklynCampPlatformLauncher;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractBlueprintTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBlueprintTest.class);
    protected File mementoDir;
    protected ClassLoader classLoader = AbstractBlueprintTest.class.getClassLoader();
    protected ManagementContext mgmt;
    protected SimpleYamlLauncherForTests launcher;
    protected BrooklynLauncher viewer;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.mementoDir = Os.newTempDir(this.getClass());
        this.mgmt = this.createOrigManagementContext();
        LOG.info("Test " + this.getClass() + " persisting to " + this.mementoDir);
        this.launcher = new SimpleYamlLauncherForTests(){

            protected BrooklynCampPlatformLauncherAbstract newPlatformLauncher() {
                return new BrooklynCampPlatformLauncher(){

                    protected ManagementContext newManagementContext() {
                        return AbstractBlueprintTest.this.mgmt;
                    }
                };
            }
        };
        this.viewer = (BrooklynLauncher)((BrooklynLauncher)BrooklynViewerLauncher.newInstance().managementContext(this.mgmt)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            if (this.mgmt != null) {
                for (Application app : this.mgmt.getApplications()) {
                    LOG.debug("destroying app " + app + " (managed? " + Entities.isManaged((Entity)app) + "; mgmt is " + this.mgmt + ")");
                    try {
                        Entities.destroy((Entity)app);
                        LOG.debug("destroyed app " + app + "; mgmt now " + this.mgmt);
                    }
                    catch (Exception e) {
                        LOG.error("problems destroying app " + app, (Throwable)e);
                    }
                }
            }
            if (this.launcher != null) {
                this.launcher.destroyAll();
            }
            if (this.viewer != null) {
                this.viewer.terminate();
            }
            if (this.mgmt != null) {
                Entities.destroyAll((ManagementContext)this.mgmt);
            }
            if (this.mementoDir != null) {
                FileBasedObjectStore.deleteCompletely((File)this.mementoDir);
            }
        }
        catch (Throwable t) {
            LOG.error("Caught exception in tearDown method", t);
        }
        finally {
            this.mgmt = null;
            this.launcher = null;
        }
    }

    protected void runCatalogTest(String catalogFile, Reader yamlApp) throws Exception {
        this.runCatalogTest(catalogFile, yamlApp, (Predicate<? super Application>)Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCatalogTest(String catalogFile, Reader yamlApp, Predicate<? super Application> assertion) throws Exception {
        Reader catalogInput = Streams.reader((InputStream)new ResourceUtils((Object)this).getResourceFromUrl(catalogFile));
        String catalogContent = Streams.readFullyAndClose((Reader)catalogInput);
        Iterable items = this.launcher.getManagementContext().getCatalog().addItems(catalogContent);
        try {
            Application app = this.launcher.launchAppYaml(yamlApp);
            this.assertNoFires((Entity)app);
            Assert.assertTrue((boolean)assertion.apply((Object)app));
            Application newApp = this.rebind();
            this.assertNoFires((Entity)newApp);
            Assert.assertTrue((boolean)assertion.apply((Object)app));
        }
        finally {
            for (CatalogItem item : items) {
                this.launcher.getManagementContext().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
            }
        }
    }

    protected void runTest(String yamlFile) throws Exception {
        Application app = this.launcher.launchAppYaml(yamlFile);
        this.assertNoFires((Entity)app);
        Application newApp = this.rebind();
        this.assertNoFires((Entity)newApp);
    }

    protected void runTest(Reader yaml) throws Exception {
        Application app = this.launcher.launchAppYaml(yaml);
        this.assertNoFires((Entity)app);
        Application newApp = this.rebind();
        this.assertNoFires((Entity)newApp);
    }

    protected void assertNoFires(final Entity app) {
        EntityAsserts.assertAttributeEqualsEventually((Entity)app, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
        EntityAsserts.assertAttributeEqualsEventually((Entity)app, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
        Asserts.succeedsEventually((Runnable)new Runnable(){

            @Override
            public void run() {
                for (Entity entity : Entities.descendantsAndSelf((Entity)app)) {
                    Assert.assertNotEquals((Object)entity.getAttribute(Attributes.SERVICE_STATE_ACTUAL), (Object)Lifecycle.ON_FIRE);
                    Assert.assertNotEquals((Object)entity.getAttribute(Attributes.SERVICE_UP), (Object)false);
                    if (!(entity instanceof SoftwareProcess)) continue;
                    EntityAsserts.assertAttributeEquals((Entity)entity, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Object)Lifecycle.RUNNING);
                    EntityAsserts.assertAttributeEquals((Entity)entity, (AttributeSensor)Attributes.SERVICE_UP, (Object)Boolean.TRUE);
                }
            }
        });
    }

    protected Reader loadYaml(String url, String location) {
        String yaml = "location: " + location + "\n" + new ResourceUtils((Object)this).getResourceAsString(url);
        return new StringReader(yaml);
    }

    protected Application rebind() throws Exception {
        return this.rebind(RebindOptions.create());
    }

    protected Application rebind(RebindOptions options) throws Exception {
        ManagementContext origMgmt = this.mgmt;
        LocalManagementContext newMgmt = this.createNewManagementContext();
        Collection origApps = origMgmt.getApplications();
        options = RebindOptions.create((RebindOptions)options);
        if (options.classLoader == null) {
            options.classLoader(this.classLoader);
        }
        if (options.mementoDir == null) {
            options.mementoDir(this.mementoDir);
        }
        if (options.origManagementContext == null) {
            options.origManagementContext(origMgmt);
        }
        if (options.newManagementContext == null) {
            options.newManagementContext((ManagementContext)newMgmt);
        }
        for (Application origApp : origApps) {
            RebindTestUtils.stopPersistence((Application)origApp);
        }
        this.mgmt = options.newManagementContext;
        Application newApp = RebindTestUtils.rebind((RebindOptions)options);
        return newApp;
    }

    protected LocalManagementContext createOrigManagementContext() {
        return RebindTestUtils.managementContextBuilder((File)this.mementoDir, (ClassLoader)this.classLoader).persistPeriodMillis(1L).forLive(true).emptyCatalog(true).buildStarted();
    }

    protected LocalManagementContext createNewManagementContext() {
        return RebindTestUtils.managementContextBuilder((File)this.mementoDir, (ClassLoader)this.classLoader).persistPeriodMillis(1L).forLive(true).emptyCatalog(true).buildUnstarted();
    }
}

