/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.AbstractBrooklynLauncherRebindTestFixture;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BrooklynLauncherRebindTestFixture
extends AbstractBrooklynLauncherRebindTestFixture {
    private static final Logger log = LoggerFactory.getLogger(BrooklynLauncherRebindTestFixture.class);

    @Test
    public void testRebindsToExistingApp() throws Exception {
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)((EntitySpec)EntitySpec.create(TestApplication.class).displayName("myorig")));
        this.newLauncherDefault(PersistMode.REBIND).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        Assert.assertNotNull((Object)Iterables.find((Iterable)this.lastMgmt().getApplications(), (Predicate)EntityPredicates.displayNameEqualTo((String)"myorig"), null), (String)("apps=" + this.lastMgmt().getApplications()));
    }

    @Test
    public void testRebindCanAddNewApps() throws Exception {
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)((EntitySpec)EntitySpec.create(TestApplication.class).displayName("myorig")));
        ((BrooklynLauncher)this.newLauncherDefault(PersistMode.REBIND).application((EntitySpec)EntitySpec.create(TestApplication.class).displayName("mynew"))).start();
        Assert.assertEquals((int)this.lastMgmt().getApplications().size(), (int)2, (String)("apps=" + this.lastMgmt().getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)this.lastMgmt().getApplications(), (Predicate)EntityPredicates.displayNameEqualTo((String)"mynew"), null), (String)("apps=" + this.lastMgmt().getApplications()));
        StartableApplication app3 = (StartableApplication)this.lastMgmt().getEntityManager().createEntity((EntitySpec)EntitySpec.create(TestApplication.class).displayName("mynew2"));
        app3.start((Collection)ImmutableList.of());
    }

    @Test
    public void testAutoRebindsToExistingApp() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        this.newLauncherDefault(PersistMode.AUTO).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
    }

    @Test
    public void testCleanDoesNotRebindToExistingApp() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        this.newLauncherDefault(PersistMode.CLEAN).start();
        Assert.assertTrue((boolean)this.lastMgmt().getApplications().isEmpty(), (String)("apps=" + this.lastMgmt().getApplications()));
    }

    @Test
    public void testAutoRebindCreatesNewIfEmptyDir() throws Exception {
        ((BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).application(EntitySpec.create(TestApplication.class))).start();
        this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        this.assertMementoContainerNonEmptyForTypeEventually("entities");
    }

    @Test
    public void testRebindRespectsPersistenceDirSetInProperties() throws Exception {
        String persistenceDir2 = this.newTempPersistenceContainerName();
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newDefault();
        brooklynProperties.put(BrooklynServerConfig.PERSISTENCE_DIR, (Object)persistenceDir2);
        LocalManagementContextForTests mgmt = this.newManagementContextForTests(brooklynProperties);
        ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherBase().persistMode(PersistMode.AUTO)).persistPeriod(Duration.millis((Number)10))).managementContext((ManagementContext)mgmt)).start();
        this.checkPersistenceContainerNameIs(persistenceDir2);
    }

    @Test(groups={"Integration"})
    public void testRebindRespectsDefaultPersistenceDir() throws Exception {
        ((BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).persistenceDir((String)null)).start();
        this.checkPersistenceContainerNameIsDefault();
    }

    protected abstract void checkPersistenceContainerNameIsDefault();

    protected abstract void checkPersistenceContainerNameIs(String var1);

    @Test
    public void testPersistenceFailsIfNoDir() throws Exception {
        this.runRebindFails(PersistMode.REBIND, this.badContainerName(), "does not exist");
    }

    protected abstract String badContainerName();

    @Test
    public void testExplicitRebindFailsIfEmpty() throws Exception {
        this.runRebindFails(PersistMode.REBIND, this.persistenceDir, "directory is empty");
    }
}

