/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.entity.brooklynnode.BrooklynEntityMirror;
import org.apache.brooklyn.launcher.BrooklynWebServer;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.test.HttpTestUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class BrooklynEntityMirrorIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(BrooklynEntityMirrorIntegrationTest.class);
    private BrooklynWebServer server;
    private TestApplication serverApp;
    private ManagementContext serverMgmt;
    private TestApplication localApp;
    private ManagementContext localMgmt;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.localApp = TestApplication.Factory.newManagedInstanceForTests();
        this.localMgmt = this.localApp.getManagementContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.serverMgmt != null) {
            Entities.destroyAll((ManagementContext)this.serverMgmt);
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.localMgmt != null) {
            Entities.destroyAll((ManagementContext)this.localMgmt);
        }
        this.serverMgmt = null;
    }

    protected void setUpServer() {
        this.setUpServer((ManagementContext)new LocalManagementContextForTests(), true);
    }

    protected void setUpServer(ManagementContext mgmt, boolean skipSecurity) {
        try {
            if (this.serverMgmt != null) {
                throw new IllegalStateException("server already set up");
            }
            this.serverMgmt = mgmt;
            this.server = new BrooklynWebServer(mgmt);
            this.server.skipSecurity(skipSecurity);
            this.server.start();
            this.serverMgmt.getHighAvailabilityManager().disabled();
            this.serverApp = TestApplication.Factory.newManagedInstanceForTests((ManagementContext)this.serverMgmt);
            ((LocalManagementContextForTests)this.serverMgmt).noteStartupComplete();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected String getBaseUri() {
        return this.server.getRootUrl();
    }

    @Test(groups={"Integration"})
    public void testServiceMirroring() throws Exception {
        this.setUpServer();
        String catalogItemId = "test-catalog-item:1.0";
        String catalogItemIdGA = "test-catalog-item:1.0-GA";
        this.serverApp.sensors().set(TestApplication.MY_ATTRIBUTE, (Object)"austria");
        this.serverApp.setCatalogItemId(catalogItemId);
        String serviceId = this.serverApp.getId();
        Entity mirror = this.localApp.addChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BrooklynEntityMirror.class).configure(BrooklynEntityMirror.POLL_PERIOD, (Object)Duration.millis((Number)100))).configure(BrooklynEntityMirror.MIRRORED_ENTITY_ID, (Object)serviceId)).configure(BrooklynEntityMirror.MIRRORED_ENTITY_URL, (Object)(this.getBaseUri() + "/v1/applications/" + serviceId + "/entities/" + serviceId)));
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestApplication.MY_ATTRIBUTE, (Object)"austria");
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)BrooklynEntityMirror.MIRROR_CATALOG_ITEM_ID, (Object)catalogItemId);
        Assert.assertTrue((mirror.getAttribute(BrooklynEntityMirror.MIRROR_SUMMARY) != null ? 1 : 0) != 0, (String)"entity summary is null");
        log.info("Sensors mirrored are: " + ((EntityInternal)mirror).getAllAttributes());
        this.serverApp.sensors().set(TestApplication.MY_ATTRIBUTE, (Object)"bermuda");
        this.serverApp.setCatalogItemId(catalogItemIdGA);
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestApplication.MY_ATTRIBUTE, (Object)"bermuda");
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)BrooklynEntityMirror.MIRROR_CATALOG_ITEM_ID, (Object)catalogItemIdGA);
        this.serverApp.stop();
        BrooklynEntityMirrorIntegrationTest.assertUnmanagedEventually(mirror);
    }

    @Test(groups={"Integration"})
    public void testServiceMirroringHttps() throws Exception {
        LocalManagementContextForTests mgmtHttps = new LocalManagementContextForTests();
        mgmtHttps.getBrooklynProperties().put((Object)"brooklyn.webconsole.security.https.required", (Object)true);
        mgmtHttps.getBrooklynProperties().put((Object)"brooklyn.webconsole.security.users", (Object)"admin");
        mgmtHttps.getBrooklynProperties().put((Object)"brooklyn.webconsole.security.user.admin.password", (Object)"P5ssW0rd");
        this.setUpServer((ManagementContext)mgmtHttps, false);
        Assert.assertTrue((boolean)this.getBaseUri().startsWith("https:"), (String)("URL is not https: " + this.getBaseUri()));
        HttpTestUtils.assertHttpStatusCodeEquals((String)this.getBaseUri(), (int[])new int[]{401});
        this.serverApp.sensors().set(TestApplication.MY_ATTRIBUTE, (Object)"austria");
        String serviceId = this.serverApp.getId();
        Entity mirror = this.localApp.addChild((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BrooklynEntityMirror.class).configure(BrooklynEntityMirror.POLL_PERIOD, (Object)Duration.millis((Number)100))).configure(BrooklynEntityMirror.MANAGEMENT_USER, (Object)"admin")).configure(BrooklynEntityMirror.MANAGEMENT_PASSWORD, (Object)"P5ssW0rd")).configure(BrooklynEntityMirror.MIRRORED_ENTITY_ID, (Object)serviceId)).configure(BrooklynEntityMirror.MIRRORED_ENTITY_URL, (Object)(this.getBaseUri() + "/v1/applications/" + serviceId + "/entities/" + serviceId)));
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestApplication.MY_ATTRIBUTE, (Object)"austria");
        log.info("Sensors mirrored are: " + ((EntityInternal)mirror).getAllAttributes());
        this.serverApp.sensors().set(TestApplication.MY_ATTRIBUTE, (Object)"bermuda");
        EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestApplication.MY_ATTRIBUTE, (Object)"bermuda");
        this.serverApp.stop();
        BrooklynEntityMirrorIntegrationTest.assertUnmanagedEventually(mirror);
    }

    private static void assertUnmanagedEventually(final Entity entity) {
        Asserts.succeedsEventually((Runnable)new Runnable(){

            @Override
            public void run() {
                Assert.assertFalse((boolean)Entities.isManaged((Entity)entity));
            }
        });
    }
}

