/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.mgmt.ShutdownHandler;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.launcher.WebAppContextProvider;
import org.apache.brooklyn.launcher.config.CustomResourceLocator;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.NopSecurityHandler;
import org.apache.brooklyn.rest.RestApiSetup;
import org.apache.brooklyn.rest.filter.BrooklynPropertiesSecurityFilter;
import org.apache.brooklyn.rest.filter.CorsImplSupplierFilter;
import org.apache.brooklyn.rest.filter.CsrfTokenFilter;
import org.apache.brooklyn.rest.filter.EntitlementContextFilter;
import org.apache.brooklyn.rest.filter.HaHotCheckResourceFilter;
import org.apache.brooklyn.rest.filter.LoggingFilter;
import org.apache.brooklyn.rest.filter.NoCacheFilter;
import org.apache.brooklyn.rest.filter.RequestTaggingFilter;
import org.apache.brooklyn.rest.filter.RequestTaggingRsFilter;
import org.apache.brooklyn.rest.security.jaas.BrooklynLoginModule;
import org.apache.brooklyn.rest.security.jaas.JaasUtils;
import org.apache.brooklyn.rest.util.ManagementContextProvider;
import org.apache.brooklyn.rest.util.ShutdownHandlerProvider;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.BrooklynNetworkUtils;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.crypto.FluentKeySigner;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.javalang.Threads;
import org.apache.brooklyn.util.logging.LoggingSetup;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.brooklyn.util.web.ContextHandlerCollectionHotSwappable;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynWebServer {
    private static final Logger log = LoggerFactory.getLogger(BrooklynWebServer.class);
    public static final String BROOKLYN_WAR_URL = "classpath://brooklyn.war";
    protected Server server;
    private WebAppContext rootContext;
    @SetFromFlag(value="port")
    protected PortRange requestedPort = null;
    @SetFromFlag
    protected PortRange httpPort = PortRanges.fromString((String)"8081+");
    @SetFromFlag
    protected PortRange httpsPort = PortRanges.fromString((String)"8443+");
    protected volatile int actualPort = -1;
    protected InetAddress actualAddress = null;
    @SetFromFlag
    protected String war = "classpath://brooklyn.war";
    @SetFromFlag
    protected InetAddress bindAddress = null;
    @SetFromFlag
    protected InetAddress publicAddress = null;
    @SetFromFlag
    private Map<String, String> wars = new LinkedHashMap<String, String>();
    private Map<String, WebAppContextProvider> contextProviders = new LinkedHashMap<String, WebAppContextProvider>();
    @SetFromFlag
    protected boolean ignoreWebappDeploymentFailures = false;
    @SetFromFlag
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private ManagementContext managementContext;
    @SetFromFlag
    private Boolean httpsEnabled;
    @SetFromFlag
    private String sslCertificate;
    @SetFromFlag
    private String keystoreUrl;
    @SetFromFlag
    @Deprecated
    private String keystorePath;
    @SetFromFlag
    private String keystorePassword;
    @SetFromFlag
    private String keystoreCertAlias;
    @SetFromFlag
    private String truststorePath;
    @SetFromFlag
    private String trustStorePassword;
    @SetFromFlag
    private String transportProtocols;
    @SetFromFlag
    private String transportCiphers;
    private File webappTempDir;
    @Deprecated
    private Class<BrooklynPropertiesSecurityFilter> securityFilterClazz;
    @SetFromFlag
    private boolean skipSecurity = false;
    private ShutdownHandler shutdownHandler;
    ContextHandlerCollectionHotSwappable handlers = new ContextHandlerCollectionHotSwappable();
    private Thread shutdownHook = null;

    public BrooklynWebServer(ManagementContext managementContext) {
        this(Maps.newLinkedHashMap(), managementContext);
    }

    public BrooklynWebServer(Map<?, ?> flags, ManagementContext managementContext) {
        this.managementContext = managementContext;
        Map leftovers = FlagUtils.setFieldsFromFlags(flags, (Object)this);
        if (!leftovers.isEmpty()) {
            log.warn("Ignoring unknown flags " + leftovers);
        }
        this.webappTempDir = BrooklynServerPaths.getBrooklynWebTmpDir((ManagementContext)managementContext);
        JaasUtils.init((ManagementContext)managementContext);
    }

    public BrooklynWebServer(ManagementContext managementContext, int port) {
        this(managementContext, port, "brooklyn.war");
    }

    public BrooklynWebServer(ManagementContext managementContext, int port, String warUrl) {
        this((Map<?, ?>)MutableMap.of((Object)"port", (Object)port, (Object)"war", (Object)warUrl), managementContext);
    }

    @Deprecated
    public void setSecurityFilter(Class<BrooklynPropertiesSecurityFilter> filterClazz) {
        this.securityFilterClazz = filterClazz;
    }

    public BrooklynWebServer skipSecurity() {
        return this.skipSecurity(true);
    }

    public BrooklynWebServer skipSecurity(boolean skipSecurity) {
        this.skipSecurity = skipSecurity;
        return this;
    }

    public void setShutdownHandler(@Nullable ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public BrooklynWebServer setPort(Object port) {
        if (this.getActualPort() > 0) {
            throw new IllegalStateException("Can't set port after port has been assigned to server (using " + this.getActualPort() + ")");
        }
        this.requestedPort = (PortRange)TypeCoercions.coerce((Object)port, PortRange.class);
        return this;
    }

    @VisibleForTesting
    File getWebappTempDir() {
        return this.webappTempDir;
    }

    public BrooklynWebServer setHttpsEnabled(Boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public boolean getHttpsEnabled() {
        return this.getConfig(this.httpsEnabled, BrooklynWebConfig.HTTPS_REQUIRED);
    }

    public PortRange getRequestedPort() {
        return this.requestedPort;
    }

    public int getActualPort() {
        return this.actualPort;
    }

    public InetAddress getAddress() {
        if (this.actualAddress != null) {
            return this.actualAddress;
        }
        if (!this.shouldBindToAll()) {
            return this.bindAddress;
        }
        return BrooklynNetworkUtils.getLocalhostInetAddress();
    }

    public String getRootUrl() {
        String address;
        String string = address = this.publicAddress != null ? this.publicAddress.getHostName() : this.getAddress().getHostName();
        if (this.getActualPort() > 0) {
            String protocol = this.getHttpsEnabled() ? "https" : "http";
            return protocol + "://" + address + ":" + this.getActualPort() + "/";
        }
        return null;
    }

    public BrooklynWebServer setWar(String url) {
        this.war = url;
        return this;
    }

    public BrooklynWebServer addWar(String path, String warUrl) {
        this.addWar(new WebAppContextProvider(path, warUrl));
        return this;
    }

    public BrooklynWebServer addWar(WebAppContextProvider contextProvider) {
        this.contextProviders.put(contextProvider.getPath(), contextProvider);
        return this;
    }

    public BrooklynWebServer setBindAddress(InetAddress address) {
        this.bindAddress = address;
        return this;
    }

    public BrooklynWebServer setPublicAddress(InetAddress address) {
        this.publicAddress = address;
        return this;
    }

    @Deprecated
    public BrooklynWebServer addAttribute(String field, Object value) {
        return this.setAttribute(field, value);
    }

    public BrooklynWebServer setAttribute(String field, Object value) {
        this.attributes.put(field, value);
        return this;
    }

    public <T> BrooklynWebServer configure(ConfigKey<T> key, T value) {
        return this.setAttribute(key.getName(), value);
    }

    public BrooklynWebServer putAttributes(Map newAttrs) {
        if (newAttrs != null) {
            this.attributes.putAll(newAttrs);
        }
        return this;
    }

    public synchronized void start() throws Exception {
        ServerConnector connector;
        if (this.server != null) {
            throw new IllegalStateException("" + this + " already running");
        }
        if (this.actualPort == -1) {
            PortRange portRange = this.getConfig(this.requestedPort, BrooklynWebConfig.WEB_CONSOLE_PORT);
            if (portRange == null) {
                portRange = this.getHttpsEnabled() ? this.httpsPort : this.httpPort;
            }
            this.actualPort = LocalhostMachineProvisioningLocation.obtainPort((InetAddress)(this.shouldBindToAll() ? Networking.ANY_NIC : this.getAddress()), (PortRange)portRange, (Boolean)true);
            if (this.actualPort == -1) {
                throw new IllegalStateException("Unable to provision port for web console (wanted " + portRange + ")");
            }
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("brooklyn-jetty-server-" + this.actualPort + "-" + threadPool.getName());
        this.server = new Server((ThreadPool)threadPool);
        JAASLoginService loginService = new JAASLoginService();
        loginService.setName("webconsole");
        loginService.setLoginModuleName("webconsole");
        loginService.setRoleClassNames(new String[]{BrooklynLoginModule.RolePrincipal.class.getName()});
        this.server.addBean((Object)loginService);
        if (this.getHttpsEnabled()) {
            HttpConfiguration sslHttpConfig = new HttpConfiguration();
            sslHttpConfig.setSecureScheme("https");
            sslHttpConfig.setSecurePort(this.actualPort);
            SslContextFactory sslContextFactory = this.createContextFactory();
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(sslHttpConfig)});
        } else {
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
        }
        if (this.bindAddress != null) {
            connector.setHost(this.bindAddress.getHostName());
        }
        connector.setPort(this.actualPort);
        this.server.setConnectors(new Connector[]{connector});
        this.actualAddress = this.shouldBindToAll() ? null : this.bindAddress;
        if (log.isDebugEnabled()) {
            log.debug("Starting Brooklyn console at " + this.getRootUrl() + ", running " + this.war + (this.wars != null ? " and " + this.wars.values() : ""));
        }
        this.addShutdownHook();
        MutableMap allWars = MutableMap.copyOf(this.contextProviders);
        for (Map.Entry entry : this.wars.entrySet()) {
            allWars.put(entry.getKey(), (Object)new WebAppContextProvider((String)entry.getKey(), (String)entry.getValue()));
        }
        WebAppContextProvider rootWar = (WebAppContextProvider)allWars.remove((Object)"");
        if (rootWar == null) {
            rootWar = new WebAppContextProvider("/", this.war);
        }
        for (WebAppContextProvider contextProvider : allWars.values()) {
            WebAppContext webapp = this.deploy(contextProvider);
            webapp.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, this.newTimestampedDirName("war", 8))));
        }
        this.rootContext = this.deploy(rootWar);
        this.deployRestApi(this.rootContext);
        this.rootContext.setTempDirectory(Os.mkdirs((File)new File(this.webappTempDir, "war-root")));
        this.server.setHandler((Handler)this.handlers);
        try {
            this.server.start();
        }
        catch (BindException bindException) {
            log.warn("Initial server start-up failed binding (retrying after a delay): " + bindException);
            Time.sleep((Duration)Duration.millis((Number)500));
            this.server.start();
        }
        BrooklynInitialization.reinitAll();
        if (this.managementContext instanceof ManagementContextInternal) {
            ((ManagementContextInternal)this.managementContext).setManagementNodeUri(new URI(this.getRootUrl()));
        }
        log.info("Started Brooklyn console at " + this.getRootUrl() + ", running " + rootWar + (allWars != null && !allWars.isEmpty() ? " and " + this.wars.values() : ""));
    }

    private boolean shouldBindToAll() {
        try {
            return this.bindAddress == null || this.bindAddress.equals(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}));
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private WebAppContext deployRestApi(WebAppContext context) {
        ImmutableList.Builder providersListBuilder = ImmutableList.builder();
        providersListBuilder.add(new Object[]{new ManagementContextProvider(), new ShutdownHandlerProvider(this.shutdownHandler), new RequestTaggingRsFilter(), new NoCacheFilter(), new HaHotCheckResourceFilter(), new EntitlementContextFilter(), new CsrfTokenFilter()});
        if (BrooklynFeatureEnablement.isEnabled((String)"brooklyn.experimental.feature.corsCxfFeature")) {
            providersListBuilder.add((Object)new CorsImplSupplierFilter(this.managementContext));
        }
        RestApiSetup.installRest((ServletContextHandler)context, (Object[])providersListBuilder.build().toArray());
        RestApiSetup.installServletFilters((ServletContextHandler)context, (Class[])new Class[]{RequestTaggingFilter.class, LoggingFilter.class});
        if (this.securityFilterClazz != null) {
            RestApiSetup.installServletFilters((ServletContextHandler)context, (Class[])new Class[]{this.securityFilterClazz});
        }
        return context;
    }

    private SslContextFactory createContextFactory() throws KeyStoreException {
        SslContextFactory sslContextFactory = new SslContextFactory();
        String ksUrl = this.getKeystoreUrl();
        String ksPassword = this.getConfig(this.keystorePassword, BrooklynWebConfig.KEYSTORE_PASSWORD);
        String ksCertAlias = this.getConfig(this.keystoreCertAlias, BrooklynWebConfig.KEYSTORE_CERTIFICATE_ALIAS);
        String trProtos = this.getConfig(this.transportProtocols, BrooklynWebConfig.TRANSPORT_PROTOCOLS);
        String trCiphers = this.getConfig(this.transportCiphers, BrooklynWebConfig.TRANSPORT_CIPHERS);
        if (ksUrl != null) {
            sslContextFactory.setKeyStorePath(this.getLocalKeyStorePath(ksUrl));
            if (Strings.isEmpty((CharSequence)ksPassword)) {
                throw new IllegalArgumentException("Keystore password is required and non-empty if keystore is specified.");
            }
            sslContextFactory.setKeyStorePassword(ksPassword);
            if (Strings.isNonEmpty((CharSequence)ksCertAlias)) {
                sslContextFactory.setCertAlias(ksCertAlias);
            }
        } else {
            log.info("No keystore specified but https enabled; creating a default keystore");
            if (Strings.isEmpty((CharSequence)ksCertAlias)) {
                ksCertAlias = "web-console";
            }
            if (Strings.isEmpty((CharSequence)ksPassword)) {
                ksPassword = Identifiers.makeRandomId((int)8);
                log.debug("created random password " + ksPassword + " for ad hoc internal keystore");
            }
            KeyStore ks = SecureKeys.newKeyStore();
            KeyPair key = SecureKeys.newKeyPair();
            X509Certificate cert = new FluentKeySigner("brooklyn").newCertificateFor("web-console", key);
            ks.setKeyEntry(ksCertAlias, key.getPrivate(), ksPassword.toCharArray(), new Certificate[]{cert});
            sslContextFactory.setKeyStore(ks);
            sslContextFactory.setKeyStorePassword(ksPassword);
            sslContextFactory.setCertAlias(ksCertAlias);
        }
        if (!Strings.isEmpty((CharSequence)this.truststorePath)) {
            sslContextFactory.setTrustStorePath(this.checkFileExists(this.truststorePath, "truststore"));
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        if (Strings.isNonBlank((CharSequence)trProtos)) {
            sslContextFactory.setIncludeProtocols(this.parseArray(trProtos));
        }
        if (Strings.isNonBlank((CharSequence)trCiphers)) {
            sslContextFactory.setIncludeCipherSuites(this.parseArray(trCiphers));
        }
        return sslContextFactory;
    }

    private String[] parseArray(String list) {
        List arr = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)list);
        return arr.toArray(new String[arr.size()]);
    }

    private String getKeystoreUrl() {
        if (this.keystoreUrl != null) {
            if (Strings.isNonBlank((CharSequence)this.keystorePath) && !this.keystoreUrl.equals(this.keystorePath)) {
                log.warn("Deprecated 'keystorePath' supplied with different value than 'keystoreUrl', preferring the latter: " + this.keystorePath + " / " + this.keystoreUrl);
            }
            return this.keystoreUrl;
        }
        if (Strings.isNonBlank((CharSequence)this.keystorePath)) {
            log.warn("Deprecated 'keystorePath' used; callers should use 'keystoreUrl'");
            return this.keystorePath;
        }
        return (String)this.managementContext.getConfig().getConfig(BrooklynWebConfig.KEYSTORE_URL);
    }

    private <T> T getConfig(T override, ConfigKey<T> key) {
        if (override != null) {
            return override;
        }
        return (T)this.managementContext.getConfig().getConfig(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalKeyStorePath(String keystoreUrl) {
        InputStream keystoreStream;
        ResourceUtils res = ResourceUtils.create((Object)this);
        res.checkUrlExists(keystoreUrl, BrooklynWebConfig.KEYSTORE_URL.getName());
        if (new File(keystoreUrl).exists()) {
            return keystoreUrl;
        }
        try {
            keystoreStream = res.getResourceFromUrl(keystoreUrl);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalArgumentException("Unable to access URL: " + keystoreUrl, e);
        }
        File tmp = Os.newTempFile((String)"brooklyn-keystore", (String)"ks");
        tmp.deleteOnExit();
        try {
            FileUtil.copyTo((InputStream)keystoreStream, (File)tmp);
        }
        finally {
            Streams.closeQuietly((Closeable)keystoreStream);
        }
        return tmp.getAbsolutePath();
    }

    private String newTimestampedDirName(String prefix, int randomSuffixLength) {
        return prefix + "-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "-" + Identifiers.makeRandomId((int)randomSuffixLength);
    }

    private String checkFileExists(String path, String name) {
        if (!new File(path).exists()) {
            throw new IllegalArgumentException("Could not find " + name + ": " + path);
        }
        return path;
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            return;
        }
        String root = this.getRootUrl();
        if (this.shutdownHook != null) {
            Threads.removeShutdownHook((Thread)this.shutdownHook);
        }
        if (log.isDebugEnabled()) {
            log.debug("Stopping Brooklyn web console at " + root + " (" + this.war + (this.wars != null ? " and " + this.wars.values() : "") + ")");
        }
        this.server.stop();
        try {
            this.server.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        LocalhostMachineProvisioningLocation.releasePort((InetAddress)this.getAddress(), (int)this.actualPort);
        this.actualPort = -1;
        if (log.isDebugEnabled()) {
            log.debug("Stopped Brooklyn web console at " + root);
        }
    }

    protected synchronized void addShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = Threads.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                log.debug("BrooklynWebServer detected shutdown: stopping web-console");
                try {
                    BrooklynWebServer.this.stop();
                }
                catch (Exception e) {
                    log.error("Failure shutting down web-console: " + e, (Throwable)e);
                }
            }
        });
    }

    public WebAppContext deploy(String pathSpec, String war) {
        return this.deploy(new WebAppContextProvider(pathSpec, war));
    }

    public WebAppContext deploy(WebAppContextProvider contextProvider) {
        WebAppContext context = contextProvider.get(this.managementContext, this.attributes, this.ignoreWebappDeploymentFailures);
        this.initSecurity(context);
        this.deploy(context);
        return context;
    }

    private void initSecurity(WebAppContext context) {
        if (this.skipSecurity) {
            context.setSecurityHandler((SecurityHandler)new NopSecurityHandler());
        } else {
            context.addOverrideDescriptor(this.getClass().getResource("/web-security.xml").toExternalForm());
        }
    }

    public void deploy(WebAppContext context) {
        try {
            this.handlers.updateHandler(context);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getRootContext() {
        return this.rootContext;
    }

    static {
        CustomResourceLocator.registerAlternateLocator(new CustomResourceLocator.SearchingClassPathInDevMode(BROOKLYN_WAR_URL, "/brooklyn-server/launcher/target", "/brooklyn-ui/target/brooklyn-jsgui-" + BrooklynVersion.get() + ".war"));
        LoggingSetup.installJavaUtilLoggingBridge();
    }
}

