/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.mgmt.ShutdownHandler;
import org.apache.brooklyn.core.mgmt.internal.BrooklynShutdownHooks;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.LocalBrooklynNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.launcher.BrooklynServerDetails;
import org.apache.brooklyn.launcher.BrooklynWebServer;
import org.apache.brooklyn.launcher.WebAppContextProvider;
import org.apache.brooklyn.launcher.common.BasicLauncher;
import org.apache.brooklyn.launcher.common.BrooklynPropertiesFactoryHelper;
import org.apache.brooklyn.launcher.config.StopWhichAppsOnShutdown;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynLauncher
extends BasicLauncher<BrooklynLauncher> {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynLauncher.class);
    private boolean startWebApps = true;
    private PortRange port = null;
    private Boolean useHttps = null;
    private InetAddress bindAddress = null;
    private InetAddress publicAddress = null;
    private List<WebAppContextProvider> webApps = new LinkedList<WebAppContextProvider>();
    private Map<String, ?> webconsoleFlags = Maps.newLinkedHashMap();
    private Boolean skipSecurityFilter = null;
    private boolean ignoreWebErrors = false;
    private StopWhichAppsOnShutdown stopWhichAppsOnShutdown = StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED;
    private ShutdownHandler shutdownHandler;
    private Function<ManagementContext, Void> customizeManagement = null;
    private volatile BrooklynWebServer webServer;
    private String globalBrooklynPropertiesFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "brooklyn.properties"});
    private String localBrooklynPropertiesFile;
    private Supplier<Map<?, ?>> brooklynPropertiesSupplier;

    public static BrooklynLauncher newInstance() {
        return new BrooklynLauncher();
    }

    public BrooklynServerDetails getServerDetails() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot retrieve server details until started");
        }
        return new BrooklynServerDetails(this.webServer, this.getManagementContext());
    }

    public BrooklynLauncher webconsole(boolean startWebApps) {
        this.startWebApps = startWebApps;
        return this;
    }

    public BrooklynLauncher installSecurityFilter(Boolean val) {
        this.skipSecurityFilter = val == null ? null : Boolean.valueOf(val == false);
        return this;
    }

    public BrooklynLauncher webconsolePort(int port) {
        return this.webconsolePort(PortRanges.fromInteger((int)port));
    }

    public BrooklynLauncher webconsolePort(String port) {
        if (port == null) {
            return this.webconsolePort((PortRange)null);
        }
        return this.webconsolePort(PortRanges.fromString((String)port));
    }

    public BrooklynLauncher webconsolePort(PortRange port) {
        this.port = port;
        return this;
    }

    public BrooklynLauncher webconsoleHttps(Boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public BrooklynLauncher bindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public BrooklynLauncher publicAddress(InetAddress publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    public BrooklynLauncher webServerFlags(Map<String, ?> webServerFlags) {
        this.webconsoleFlags = webServerFlags;
        return this;
    }

    public BrooklynLauncher webapp(String contextPath, String warUrl) {
        this.webApps.add(new WebAppContextProvider(contextPath, warUrl));
        return this;
    }

    public BrooklynLauncher webapp(WebAppContextProvider contextProvider) {
        this.webApps.add(contextProvider);
        return this;
    }

    public BrooklynLauncher ignoreWebErrors(boolean ignoreWebErrors) {
        this.ignoreWebErrors = ignoreWebErrors;
        return this;
    }

    public BrooklynLauncher stopWhichAppsOnShutdown(StopWhichAppsOnShutdown stopWhich) {
        this.stopWhichAppsOnShutdown = stopWhich;
        return this;
    }

    public BrooklynLauncher customizeManagement(Function<ManagementContext, Void> customizeManagement) {
        this.customizeManagement = customizeManagement;
        return this;
    }

    public BrooklynLauncher shutdownOnExit(boolean val) {
        LOG.warn("Call to deprecated `shutdownOnExit`", new Throwable("source of deprecated call"));
        this.stopWhichAppsOnShutdown = StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED;
        return this;
    }

    public BrooklynLauncher shutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
        return this;
    }

    protected void initManagementContext() {
        this.initBrooklynPropertiesBuilder();
        super.initManagementContext();
        if (this.customizeManagement != null) {
            this.customizeManagement.apply((Object)this.getManagementContext());
        }
    }

    protected void initBrooklynPropertiesBuilder() {
        if (this.getBrooklynPropertiesBuilder() == null) {
            this.setBrooklynPropertiesBuilder(new BrooklynPropertiesFactoryHelper(this.globalBrooklynPropertiesFile, this.localBrooklynPropertiesFile, this.getBrooklynProperties(), this.getBrooklynPropertiesSupplier()).createPropertiesBuilder());
        }
    }

    private Supplier<Map<?, ?>> getBrooklynPropertiesSupplier() {
        return this.brooklynPropertiesSupplier;
    }

    protected void startingUp() {
        super.startingUp();
        if (this.startWebApps) {
            try {
                this.startWebApps();
            }
            catch (Exception e) {
                this.handleSubsystemStartupError(this.ignoreWebErrors, "core web apps", e);
            }
        }
    }

    protected void startWebApps() {
        Object bindAddressMsg;
        boolean skipSecurity;
        ManagementContext managementContext = this.getManagementContext();
        BrooklynProperties brooklynProperties = (BrooklynProperties)managementContext.getConfig();
        String securityProvider = (String)managementContext.getConfig().getConfig(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME);
        boolean anyoneSecurityProvider = AnyoneSecurityProvider.class.getName().equals(securityProvider);
        boolean noSecurityOptions = BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)managementContext.getConfig());
        boolean bl = skipSecurity = Boolean.TRUE.equals(this.skipSecurityFilter) || anyoneSecurityProvider || noSecurityOptions;
        if (Boolean.TRUE.equals(this.skipSecurityFilter)) {
            if (this.bindAddress == null) {
                LOG.info("Starting Brooklyn web-console with security explicitly disabled, on loopback because no bind address specified");
                this.bindAddress = Networking.LOOPBACK;
            } else {
                LOG.info("Starting Brooklyn web-console with security explicitly disabled, on bind address {}", (Object)this.bindAddress.getHostAddress());
            }
        } else if (anyoneSecurityProvider) {
            bindAddressMsg = this.bindAddress == null ? "<any>" : this.bindAddress.getHostAddress();
            LOG.info("Starting Brooklyn web-console with AnyoneSecurityProvider (no authentication), on bind address {}", bindAddressMsg);
        } else if (noSecurityOptions) {
            bindAddressMsg = this.bindAddress == null ? "<any>" : this.bindAddress.getHostAddress();
            LOG.info("Starting Brooklyn web-console with no security options (defaulting to no authentication), on bind address {}", bindAddressMsg);
        } else {
            bindAddressMsg = this.bindAddress == null ? "<any>" : this.bindAddress.getHostAddress();
            Map securityProps = brooklynProperties.submap(ConfigPredicates.nameStartsWith((String)"brooklyn.webconsole.security")).asMapWithStringKeys();
            LOG.debug("Starting Brooklyn (bind address {}), using security properties: {}", bindAddressMsg, (Object)Sanitizer.sanitize((Map)securityProps));
        }
        if (this.bindAddress == null) {
            this.bindAddress = Networking.ANY_NIC;
        }
        LOG.debug("Starting Brooklyn web-console with bindAddress " + this.bindAddress + " and properties " + brooklynProperties);
        try {
            this.webServer = new BrooklynWebServer(this.webconsoleFlags, managementContext);
            this.webServer.setBindAddress(this.bindAddress);
            this.webServer.setPublicAddress(this.publicAddress);
            if (this.port != null) {
                this.webServer.setPort(this.port);
            }
            if (this.useHttps != null) {
                this.webServer.setHttpsEnabled(this.useHttps);
            }
            this.webServer.setShutdownHandler(this.shutdownHandler);
            this.webServer.putAttributes(brooklynProperties.asMapWithStringKeys());
            this.webServer.skipSecurity(skipSecurity);
            for (WebAppContextProvider webapp : this.webApps) {
                this.webServer.addWar(webapp);
            }
            this.webServer.start();
        }
        catch (Exception e) {
            LOG.warn("Failed to start Brooklyn web-console (rethrowing) on " + this.bindAddress + " (port constraint " + this.port + "): " + Exceptions.collapseText((Throwable)e));
            throw new FatalRuntimeException("Failed to start Brooklyn web-console: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
    }

    protected void startBrooklynNode() {
        if (this.webServer == null || !this.startWebApps) {
            LOG.info("Skipping BrooklynNode entity creation, BrooklynWebServer not running");
            return;
        }
        super.startBrooklynNode();
    }

    protected EntitySpec<LocalBrooklynNode> customizeBrooklynNodeSpec(EntitySpec<LocalBrooklynNode> brooklynNodeSpec) {
        return (EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)((EntitySpec)brooklynNodeSpec.configure((ConfigKey.HasConfigKey)SoftwareProcess.RUN_DIR, (Object)System.getenv("ROOT"))).configure((ConfigKey.HasConfigKey)SoftwareProcess.INSTALL_DIR, (Object)System.getenv("BROOKLYN_HOME"))).configure((ConfigKey.HasConfigKey)BrooklynNode.ENABLED_HTTP_PROTOCOLS, (Object)ImmutableList.of((Object)(this.webServer.getHttpsEnabled() ? "https" : "http")))).configure((ConfigKey.HasConfigKey)(this.webServer.getHttpsEnabled() ? BrooklynNode.HTTPS_PORT : BrooklynNode.HTTP_PORT), (Object)PortRanges.fromInteger((int)this.webServer.getActualPort()))).configure((ConfigKey.HasConfigKey)BrooklynNode.WEB_CONSOLE_BIND_ADDRESS, (Object)this.bindAddress)).configure((ConfigKey.HasConfigKey)BrooklynNode.WEB_CONSOLE_PUBLIC_ADDRESS, (Object)this.publicAddress)).configure((ConfigKey.HasConfigKey)BrooklynNode.NO_WEB_CONSOLE_AUTHENTICATION, (Object)Boolean.TRUE.equals(this.skipSecurityFilter));
    }

    protected void startApps() {
        if (this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.ALL || this.stopWhichAppsOnShutdown == StopWhichAppsOnShutdown.ALL_IF_NOT_PERSISTED && this.getPersistMode() == PersistMode.DISABLED) {
            BrooklynShutdownHooks.invokeStopAppsOnShutdown((ManagementContext)this.getManagementContext());
        }
        for (Application app : this.getApplications()) {
            if (!(app instanceof Startable) || this.stopWhichAppsOnShutdown != StopWhichAppsOnShutdown.THESE && (this.stopWhichAppsOnShutdown != StopWhichAppsOnShutdown.THESE_IF_NOT_PERSISTED || this.getPersistMode() != PersistMode.DISABLED)) continue;
            BrooklynShutdownHooks.invokeStopOnShutdown((Entity)app);
        }
        super.startApps();
    }

    public void terminate() {
        if (!this.isStarted()) {
            return;
        }
        if (this.webServer != null) {
            try {
                this.webServer.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping web-server; continuing with termination", (Throwable)e);
            }
        }
        ManagementContext managementContext = this.getManagementContext();
        if (this.getPersistMode() != PersistMode.DISABLED) {
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                if (managementContext.getHighAvailabilityManager() != null && managementContext.getHighAvailabilityManager().getPersister() != null) {
                    managementContext.getHighAvailabilityManager().getPersister().waitForWritesCompleted(Duration.TEN_SECONDS);
                }
                managementContext.getRebindManager().waitForPendingComplete(Duration.TEN_SECONDS, true);
                LOG.info("Finished waiting for persist; took " + Time.makeTimeStringRounded((Stopwatch)stopwatch));
            }
            catch (RuntimeInterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Persistence interrupted during shutdown: " + (Object)((Object)e), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Persistence interrupted during shutdown: " + e, (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Timeout after 10 seconds waiting for persistence to write all data; continuing");
            }
        }
        if (managementContext instanceof ManagementContextInternal) {
            ((ManagementContextInternal)managementContext).terminate();
        }
        for (Location loc : this.getLocations()) {
            if (!(loc instanceof Closeable)) continue;
            Streams.closeQuietly((Closeable)((Closeable)loc));
        }
    }

    public BrooklynLauncher globalBrooklynPropertiesFile(String file) {
        this.globalBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher localBrooklynPropertiesFile(String file) {
        this.localBrooklynPropertiesFile = file;
        return this;
    }

    public BrooklynLauncher brooklynPropertiesSupplier(Supplier<Map<?, ?>> brooklynPropertiesSupplier) {
        this.brooklynPropertiesSupplier = brooklynPropertiesSupplier;
        return this;
    }
}

