/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.jsgui;

import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.server.BrooklynServiceAttributes;
import org.apache.brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import org.apache.brooklyn.rest.jsgui.BrooklynJavascriptGuiLauncher;
import org.apache.brooklyn.util.core.osgi.Compat;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BrooklynJavascriptGuiLauncherTest {
    Server server = null;

    @AfterMethod(alwaysRun=true)
    public void stopServer() throws Exception {
        if (this.server != null) {
            ManagementContext mgmt = this.getManagementContextFromJettyServerAttributes(this.server);
            this.server.stop();
            if (mgmt != null) {
                Entities.destroyAll((ManagementContext)mgmt);
            }
            this.server = null;
        }
    }

    @Test
    public void testJavascriptWithoutRest() throws Exception {
        this.server = BrooklynJavascriptGuiLauncher.startJavascriptWithoutRest();
        this.checkUrlContains("/index.html", "Brooklyn");
    }

    @Test
    public void testJavascriptWithRest() throws Exception {
        this.server = BrooklynJavascriptGuiLauncher.startJavascriptAndRest();
        BrooklynRestApiLauncherTestFixture.forceUseOfDefaultCatalogWithJavaClassPath((Server)this.server);
        BrooklynRestApiLauncherTestFixture.enableAnyoneLogin((Server)this.server);
        this.checkEventuallyHealthy();
        this.checkUrlContains("/index.html", "Brooklyn");
        this.checkUrlContains("/v1/catalog/entities", "BrooklynNode");
    }

    protected void checkUrlContains(String path, String text) {
        HttpAsserts.assertContentEventuallyContainsText((String)(this.rootUrl() + path), (String)text, (String[])new String[0]);
    }

    protected void checkEventuallyHealthy() {
        HttpAsserts.assertHttpStatusCodeEventuallyEquals((String)this.rootUrl(), (int)200);
    }

    protected String rootUrl() {
        return "http://localhost:" + ((NetworkConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    private ManagementContext getManagementContextFromJettyServerAttributes(Server server) {
        return BrooklynJavascriptGuiLauncherTest.getManagementContext((ContextHandler)server.getHandler());
    }

    public static ManagementContext getManagementContext(ContextHandler jettyServerHandler) {
        ManagementContext managementContext = Compat.getInstance().getManagementContext();
        if (managementContext == null && jettyServerHandler != null) {
            managementContext = (ManagementContext)jettyServerHandler.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        }
        return managementContext;
    }
}

