/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.jsgui;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.apache.brooklyn.rest.BrooklynRestApiLauncher;
import org.apache.brooklyn.rest.NopSecurityHandler;
import org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynJavascriptGuiLauncher {
    private static final Logger log = LoggerFactory.getLogger(BrooklynJavascriptGuiLauncher.class);
    static final int FAVOURITE_PORT = 8080;

    public static void main(String[] args) throws Exception {
        BrooklynJavascriptGuiLauncher.startJavascriptAndRest();
        log.info("Press Ctrl-C to quit.");
    }

    public static Server startJavascriptAndRest() throws Exception {
        return BrooklynRestApiLauncher.launcherServlet().securityProvider(AnyoneSecurityProvider.class).start();
    }

    public static Server startJavascriptWithoutRest() throws Exception {
        WebAppContext context = new WebAppContext(BrooklynRestApiLauncher.findJsguiWebappInSource().isPresent() ? (String)BrooklynRestApiLauncher.findJsguiWebappInSource().get() : (ResourceUtils.create(BrooklynJavascriptGuiLauncher.class).doesUrlExist("classpath://brooklyn.war") ? Os.writeToTempFile((InputStream)ResourceUtils.create(BrooklynJavascriptGuiLauncher.class).getResourceFromUrl("classpath://brooklyn.war"), (String)"brooklyn", (String)"war").getAbsolutePath() : BrooklynJavascriptGuiLauncher.throwingReturning("could not find jsgui war or source", "missing-brooklyn.war")), "/");
        context.setSecurityHandler((SecurityHandler)new NopSecurityHandler());
        Server server = new Server(new InetSocketAddress(Networking.LOOPBACK, Networking.nextAvailablePort((int)8080)));
        BrooklynRestApiLauncher.initJaasLoginService((Server)server);
        server.setHandler((Handler)context);
        server.start();
        log.info("JS GUI server started (no REST) at  http://localhost:" + ((NetworkConnector)server.getConnectors()[0]).getLocalPort() + "/");
        return server;
    }

    private static <T> T throwingReturning(String error, T result) {
        throw new IllegalStateException(error);
    }
}

