/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.launcher.BrooklynServerDetails;
import org.apache.brooklyn.launcher.BrooklynWebServer;
import org.apache.brooklyn.test.support.TestResourceUnavailableException;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class WebAppRunnerTest {
    public static final Logger log = LoggerFactory.getLogger(WebAppRunnerTest.class);
    List<LocalManagementContext> managementContexts = Lists.newCopyOnWriteArrayList();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (LocalManagementContext managementContext : this.managementContexts) {
            Entities.destroyAll((ManagementContext)managementContext);
        }
        this.managementContexts.clear();
    }

    LocalManagementContext newManagementContext(BrooklynProperties brooklynProperties) {
        LocalManagementContext result = new LocalManagementContext(brooklynProperties);
        this.managementContexts.add(result);
        return result;
    }

    BrooklynWebServer createWebServer(Map properties) {
        MutableMap bigProps = MutableMap.copyOf((Map)properties);
        MutableMap attributes = MutableMap.copyOf((Map)((Map)bigProps.get("attributes")));
        bigProps.put("attributes", attributes);
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newEmpty();
        brooklynProperties.putAll((Map)bigProps);
        brooklynProperties.put((Object)"brooklyn.webconsole.security.https.required", (Object)"false");
        return new BrooklynWebServer((Map)bigProps, (ManagementContext)this.newManagementContext(brooklynProperties)).skipSecurity();
    }

    @Test
    public void testStartWar1() throws Exception {
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)"8091+"));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:" + server.getActualPort() + "/");
        }
        finally {
            server.stop();
        }
    }

    public static void assertBrooklynEventuallyAt(String url) {
        HttpAsserts.assertContentEventuallyContainsText((String)url, (String)"Brooklyn Web Console", (String[])new String[0]);
    }

    @Test
    public void testStartSecondaryWar() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)"8091+", (Object)"war", (Object)"brooklyn.war", (Object)"wars", (Object)MutableMap.of((Object)"hello", (Object)"hello-world.war")));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:" + server.getActualPort() + "/");
            HttpAsserts.assertContentEventuallyContainsText((String)("http://localhost:" + server.getActualPort() + "/hello"), (String)"This is the home page for a sample application", (String[])new String[0]);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testStartSecondaryWarAfter() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        BrooklynWebServer server = this.createWebServer((Map)MutableMap.of((Object)"port", (Object)"8091+", (Object)"war", (Object)"brooklyn.war"));
        Assert.assertNotNull((Object)server);
        try {
            server.start();
            server.deploy("/hello", "hello-world.war");
            WebAppRunnerTest.assertBrooklynEventuallyAt("http://localhost:" + server.getActualPort() + "/");
            HttpAsserts.assertContentEventuallyContainsText((String)("http://localhost:" + server.getActualPort() + "/hello"), (String)"This is the home page for a sample application", (String[])new String[0]);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testStartWithLauncher() throws Exception {
        TestResourceUnavailableException.throwIfResourceUnavailable(this.getClass(), (String)"/hello-world.war");
        BrooklynLauncher launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)BrooklynLauncher.newInstance().brooklynProperties(BrooklynProperties.Factory.newEmpty())).brooklynProperties("brooklyn.webconsole.security.provider", (Object)"org.apache.brooklyn.rest.security.provider.AnyoneSecurityProvider")).webapp("/hello", "hello-world.war").start();
        BrooklynServerDetails details = launcher.getServerDetails();
        try {
            details.getWebServer().deploy("/hello2", "hello-world.war");
            WebAppRunnerTest.assertBrooklynEventuallyAt(details.getWebServerUrl());
            HttpAsserts.assertContentEventuallyContainsText((String)(details.getWebServerUrl() + "hello"), (String)"This is the home page for a sample application", (String[])new String[0]);
            HttpAsserts.assertContentEventuallyContainsText((String)(details.getWebServerUrl() + "hello2"), (String)"This is the home page for a sample application", (String[])new String[0]);
            HttpAsserts.assertHttpStatusCodeEventuallyEquals((String)(details.getWebServerUrl() + "hello0"), (int)404);
        }
        finally {
            details.getWebServer().stop();
            ((ManagementContextInternal)details.getManagementContext()).terminate();
        }
    }
}

