/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.AbstractCleanOrphanedStateTest;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CleanOrphanedLocationsTest
extends AbstractCleanOrphanedStateTest {
    @Test
    public void testDeletesOrphanedLocations() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation loc2 = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().locations(loc.getId(), loc2.getId()));
    }

    @Test
    public void testDeletesOrphanedLocationThatLinksToReachable() throws Exception {
        Location referantLoc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        Location refereeLoc = this.mgmt().getLocationManager().createLocation((LocationSpec)LocationSpec.create(SshMachineLocation.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)referantLoc));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)referantLoc));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().locations(refereeLoc.getId()));
    }

    @Test
    public void testDeletesOrphanedSubGraph() throws Exception {
        Location loc1 = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        Location loc2 = this.mgmt().getLocationManager().createLocation((LocationSpec)LocationSpec.create(SshMachineLocation.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc1));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().locations(loc1.getId(), loc2.getId()));
    }

    @Test
    public void testHandlesDanglingReference() throws Exception {
        SshMachineLocation todelete = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)todelete));
        ((TestApplication)this.origApp).sensors().set(Sensors.newSensor(Object.class, (String)"mysensor"), (Object)loc);
        ((TestApplication)this.origApp).config().set(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc);
        ((TestApplication)this.origApp).tags().addTag((Object)loc);
        loc.config().set(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)todelete);
        Locations.unmanage((Location)todelete);
        Assert.assertFalse((boolean)this.getRawData().getLocations().containsKey(todelete.getId()));
        this.assertTransformIsNoop();
    }

    @Test
    public void testHandlesDanglingReferencesInLocationListSurroundingValidReference() throws Exception {
        SshMachineLocation todelete = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation todelete2 = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)todelete, (Object)loc, (Object)todelete2));
        Locations.unmanage((Location)todelete);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInEntityLocs() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation loc2 = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)loc, (Object)loc2));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInSensor() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).sensors().set(Sensors.newSensor(Object.class, (String)"mysensor"), (Object)loc);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInConfig() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).config().set(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInComplexTypeSensor() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation loc2 = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).sensors().set(Sensors.newSensor(Object.class, (String)"mysensor"), (Object)ImmutableMap.of((Object)"mykey", (Object)loc, (Object)loc2, (Object)"myval"));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInTag() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).tags().addTag((Object)loc);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedInConfigKeyDefault() throws Exception {
        SshMachineLocation loc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).config().set(ConfigKeys.newConfigKey(MachineLocation.class, (String)"myconfig", (String)"my description", (Object)loc), (Object)null);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsAncestorsOfReachableLocation() throws Exception {
        SshMachineLocation grandparentLoc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation parentLoc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).parent((Location)grandparentLoc));
        SshMachineLocation childLoc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).parent((Location)parentLoc));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)childLoc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsDescendantsOfReachableLocation() throws Exception {
        SshMachineLocation grandparentLoc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        SshMachineLocation parentLoc = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).parent((Location)grandparentLoc));
        this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class).parent((Location)parentLoc));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)grandparentLoc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsReferencesOfReachableLocation() throws Exception {
        Location referantLoc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        Location refereeLoc = this.mgmt().getLocationManager().createLocation((LocationSpec)LocationSpec.create(SshMachineLocation.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)referantLoc));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)refereeLoc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsTransitiveReferencesOfReachableLocation() throws Exception {
        Location loc3 = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        Location loc2 = this.mgmt().getLocationManager().createLocation((LocationSpec)LocationSpec.create(SshMachineLocation.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc3));
        Location loc1 = this.mgmt().getLocationManager().createLocation((LocationSpec)LocationSpec.create(SshMachineLocation.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc2));
        ((TestApplication)this.origApp).addLocations((Collection)ImmutableList.of((Object)loc1));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedByEnricher() throws Exception {
        Location loc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).enrichers().add((EnricherSpec)EnricherSpec.create(AbstractCleanOrphanedStateTest.MyEnricher.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedByEnricherInFlag() throws Exception {
        Location loc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).enrichers().add((EnricherSpec)EnricherSpec.create(AbstractCleanOrphanedStateTest.MyEnricher.class).configure((CharSequence)"myobj", (Object)loc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedByPolicy() throws Exception {
        Location loc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        ((TestApplication)this.origApp).policies().add((PolicySpec)PolicySpec.create(AbstractCleanOrphanedStateTest.MyPolicy.class).configure(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc));
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsLocationsReferencedByFeed() throws Exception {
        Location loc = this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        AbstractCleanOrphanedStateTest.MyFeed feed = new AbstractCleanOrphanedStateTest.MyFeed();
        feed.config().set(ConfigKeys.newConfigKey(Object.class, (String)"myconfig"), (Object)loc);
        ((TestApplication)this.origApp).feeds().add((Feed)feed);
        this.assertTransformIsNoop();
    }

    @Test
    public void testKeepsPortForwardManager() throws Exception {
        PortForwardManager pfm = (PortForwardManager)this.mgmt().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
        BrooklynMementoRawData transformedData = this.assertTransformIsNoop();
        Assert.assertTrue((boolean)transformedData.getLocations().containsKey(pfm.getId()));
    }

    @Test
    public void testKeepsPortForwardManagerAssociatedMachines() throws Exception {
        SshMachineLocation machine = (SshMachineLocation)this.mgmt().getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
        PortForwardManager pfm = (PortForwardManager)this.mgmt().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
        pfm.associate("mypublicid", HostAndPort.fromParts((String)"mypublicip", (int)1234), (Location)machine, 22);
        BrooklynMementoRawData transformedData = this.assertTransformIsNoop();
        Assert.assertTrue((boolean)transformedData.getLocations().containsKey(pfm.getId()));
        Assert.assertTrue((boolean)transformedData.getLocations().containsKey(machine.getId()));
    }
}

