/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.launcher.AbstractCleanOrphanedStateTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CleanOrphanedAdjunctsTest
extends AbstractCleanOrphanedStateTest {
    @Test
    public void testDeletesOrphanedEnricher() throws Exception {
        Entity entity = ((TestApplication)this.origApp).addChild(EntitySpec.create(TestEntity.class).impl(AbstractCleanOrphanedStateTest.MyEntity.class));
        AbstractCleanOrphanedStateTest.MyEnricher enricher = (AbstractCleanOrphanedStateTest.MyEnricher)entity.enrichers().add(EnricherSpec.create(AbstractCleanOrphanedStateTest.MyEnricher.class));
        AbstractCleanOrphanedStateTest.MementoTweaker tweaker = new AbstractCleanOrphanedStateTest.MementoTweaker(new AbstractCleanOrphanedStateTest.Deletions().entities(entity.getId()));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().enrichers(enricher.getId()), tweaker);
    }

    @Test
    public void testDeletesOrphanedPolicies() throws Exception {
        Entity entity = ((TestApplication)this.origApp).addChild(EntitySpec.create(TestEntity.class).impl(AbstractCleanOrphanedStateTest.MyEntity.class));
        AbstractCleanOrphanedStateTest.MyPolicy policy = (AbstractCleanOrphanedStateTest.MyPolicy)entity.policies().add(PolicySpec.create(AbstractCleanOrphanedStateTest.MyPolicy.class));
        AbstractCleanOrphanedStateTest.MementoTweaker tweaker = new AbstractCleanOrphanedStateTest.MementoTweaker(new AbstractCleanOrphanedStateTest.Deletions().entities(entity.getId()));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().policies(policy.getId()), tweaker);
    }

    @Test
    public void testDeletesOrphanedFeeds() throws Exception {
        EntityInternal entity = (EntityInternal)((TestApplication)this.origApp).addChild(EntitySpec.create(TestEntity.class).impl(AbstractCleanOrphanedStateTest.MyEntity.class));
        Feed feed = entity.feeds().add((Feed)new AbstractCleanOrphanedStateTest.MyFeed());
        AbstractCleanOrphanedStateTest.MementoTweaker tweaker = new AbstractCleanOrphanedStateTest.MementoTweaker(new AbstractCleanOrphanedStateTest.Deletions().entities(entity.getId()));
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().feeds(feed.getId()), tweaker);
    }

    @Test
    public void testKeepsReachableAdjuncts() throws Exception {
        AbstractCleanOrphanedStateTest.MyPolicy policy = (AbstractCleanOrphanedStateTest.MyPolicy)((TestApplication)this.origApp).policies().add(PolicySpec.create(AbstractCleanOrphanedStateTest.MyPolicy.class));
        AbstractCleanOrphanedStateTest.MyEnricher enricher = (AbstractCleanOrphanedStateTest.MyEnricher)((TestApplication)this.origApp).enrichers().add(EnricherSpec.create(AbstractCleanOrphanedStateTest.MyEnricher.class));
        Feed feed = ((TestApplication)this.origApp).feeds().add((Feed)new AbstractCleanOrphanedStateTest.MyFeed());
        BrooklynMementoRawData origData = this.getRawData();
        Assert.assertTrue((boolean)origData.getPolicies().containsKey(policy.getId()));
        Assert.assertTrue((boolean)origData.getEnrichers().containsKey(enricher.getId()));
        Assert.assertTrue((boolean)origData.getFeeds().containsKey(feed.getId()));
        this.assertTransformIsNoop(origData);
    }
}

