/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.os.Os;
import org.apache.commons.collections.IteratorUtils;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BrooklynLauncherRebindCatalogTest {
    private static final String TEST_VERSION = "test-version";
    private static final String CATALOG_INITIAL = "classpath://rebind-test-catalog.bom";
    private static final String CATALOG_ADDITIONS = "rebind-test-catalog-additions.bom";
    private static final Iterable<String> EXPECTED_DEFAULT_IDS = ImmutableSet.of((Object)"one:test-version", (Object)"two:test-version");
    private static final Iterable<String> EXPECTED_ADDED_IDS = ImmutableSet.of((Object)"three:test-version", (Object)"four:test-version");
    private List<BrooklynLauncher> launchers = Lists.newCopyOnWriteArrayList();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (BrooklynLauncher launcher : this.launchers) {
            launcher.terminate();
        }
        this.launchers.clear();
    }

    private BrooklynLauncher newLauncherForTests(String persistenceDir) {
        CatalogInitialization catalogInitialization = new CatalogInitialization(CATALOG_INITIAL, false, null, false);
        BrooklynLauncher launcher = ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)BrooklynLauncher.newInstance().brooklynProperties(LocalManagementContextForTests.builder((boolean)true).buildProperties())).catalogInitialization(catalogInitialization)).persistMode(PersistMode.AUTO)).persistenceDir(persistenceDir)).webconsole(false);
        this.launchers.add(launcher);
        return launcher;
    }

    @Test
    public void testRebindDoesNotEffectCatalog() {
        String persistenceDir = this.newTempPersistenceContainerName();
        BrooklynLauncher launcher = this.newLauncherForTests(persistenceDir);
        launcher.start();
        BrooklynCatalog catalog = launcher.getServerDetails().getManagementContext().getCatalog();
        this.assertCatalogConsistsOfIds(catalog.getCatalogItems(), EXPECTED_DEFAULT_IDS);
        catalog.deleteCatalogItem("one", TEST_VERSION);
        catalog.deleteCatalogItem("two", TEST_VERSION);
        Assert.assertEquals((int)Iterables.size((Iterable)catalog.getCatalogItems()), (int)0);
        catalog.addItems(new ResourceUtils((Object)this).getResourceAsString(CATALOG_ADDITIONS));
        this.assertCatalogConsistsOfIds(catalog.getCatalogItems(), EXPECTED_ADDED_IDS);
        launcher.terminate();
        BrooklynLauncher newLauncher = this.newLauncherForTests(persistenceDir);
        newLauncher.start();
        this.assertCatalogConsistsOfIds(newLauncher.getServerDetails().getManagementContext().getCatalog().getCatalogItems(), EXPECTED_ADDED_IDS);
    }

    private void assertCatalogConsistsOfIds(Iterable<CatalogItem<Object, Object>> catalogItems, Iterable<String> ids) {
        Iterable idsFromItems = Iterables.transform(catalogItems, (Function)new Function<CatalogItem<?, ?>, String>(){

            @Nullable
            public String apply(CatalogItem<?, ?> catalogItem) {
                return catalogItem.getCatalogItemId();
            }
        });
        Assert.assertTrue((boolean)BrooklynLauncherRebindCatalogTest.compareIterablesWithoutOrderMatters(ids, idsFromItems), (String)String.format("Expected %s, found %s", ids, idsFromItems));
    }

    protected String newTempPersistenceContainerName() {
        File persistenceDirF = Files.createTempDir();
        Os.deleteOnExitRecursively((File)persistenceDirF);
        return persistenceDirF.getAbsolutePath();
    }

    private static <T> boolean compareIterablesWithoutOrderMatters(Iterable<T> a, Iterable<T> b) {
        List bList;
        List aList = IteratorUtils.toList(a.iterator());
        return aList.containsAll(bList = IteratorUtils.toList(b.iterator())) && bList.containsAll(aList);
    }
}

