/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecordPersister;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestUtils;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BrooklynLauncherHighAvailabilityTest {
    private static final Logger log = LoggerFactory.getLogger(BrooklynLauncherHighAvailabilityTest.class);
    private static final Duration TIMEOUT = Duration.THIRTY_SECONDS;
    private BrooklynLauncher primary;
    private BrooklynLauncher secondary;
    private BrooklynLauncher tertiary;
    private File persistenceDir;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.persistenceDir = Files.createTempDir();
        Os.deleteOnExitRecursively((File)this.persistenceDir);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.primary != null) {
            this.primary.terminate();
        }
        this.primary = null;
        if (this.secondary != null) {
            this.secondary.terminate();
        }
        this.secondary = null;
        if (this.tertiary != null) {
            this.tertiary.terminate();
        }
        this.tertiary = null;
        if (this.persistenceDir != null) {
            RebindTestUtils.deleteMementoDir((File)this.persistenceDir);
        }
        this.persistenceDir = null;
    }

    @Test
    public void testStandbyTakesOverWhenPrimaryTerminatedGracefully() throws Exception {
        this.doTestStandbyTakesOver(true);
    }

    @Test(invocationCount=10, groups={"Integration"})
    public void testStandbyTakesOverWhenPrimaryTerminatedGracefullyManyTimes() throws Exception {
        this.testStandbyTakesOverWhenPrimaryTerminatedGracefully();
    }

    @Test(groups={"Integration"})
    public void testStandbyTakesOverWhenPrimaryFails() throws Exception {
        this.doTestStandbyTakesOver(false);
    }

    protected void doTestStandbyTakesOver(boolean stopGracefully) throws Exception {
        log.info("STARTING standby takeover test");
        this.primary = BrooklynLauncher.newInstance();
        ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.primary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.AUTO)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).haHeartbeatPeriod(Duration.millis((Number)10))).haHeartbeatTimeout(Duration.millis((Number)1000))).application(EntitySpec.create(TestApplication.class))).start();
        ManagementContext primaryManagementContext = this.primary.getServerDetails().getManagementContext();
        log.info("started mgmt primary " + primaryManagementContext);
        this.assertOnlyApp(this.primary.getServerDetails().getManagementContext(), TestApplication.class);
        primaryManagementContext.getRebindManager().getPersister().waitForWritesCompleted(TIMEOUT);
        this.secondary = BrooklynLauncher.newInstance();
        ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.secondary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.AUTO)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).haHeartbeatPeriod(Duration.millis((Number)10))).haHeartbeatTimeout(Duration.millis((Number)1000))).start();
        ManagementContext secondaryManagementContext = this.secondary.getServerDetails().getManagementContext();
        log.info("started mgmt secondary " + secondaryManagementContext);
        if (stopGracefully) {
            ((ManagementContextInternal)primaryManagementContext).terminate();
        } else {
            ManagementPlaneSyncRecordPersister planePersister = ((ManagementContextInternal)primaryManagementContext).getHighAvailabilityManager().getPersister();
            planePersister.stop();
            ((ManagementContextInternal)primaryManagementContext).terminate();
        }
        this.assertOnlyAppEventually(secondaryManagementContext, TestApplication.class);
        this.tertiary = BrooklynLauncher.newInstance();
        ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.tertiary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.STANDBY)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).haHeartbeatPeriod(Duration.millis((Number)10))).haHeartbeatTimeout(Duration.millis((Number)1000))).start();
        ManagementContext tertiaryManagementContext = this.tertiary.getServerDetails().getManagementContext();
        log.info("started mgmt tertiary " + primaryManagementContext);
        this.assertNoApps(this.tertiary.getServerDetails().getManagementContext());
        if (stopGracefully) {
            ((ManagementContextInternal)secondaryManagementContext).terminate();
        } else {
            ManagementPlaneSyncRecordPersister planePersister = ((ManagementContextInternal)secondaryManagementContext).getHighAvailabilityManager().getPersister();
            planePersister.stop();
            ((ManagementContextInternal)secondaryManagementContext).terminate();
        }
        this.assertOnlyAppEventually(tertiaryManagementContext, TestApplication.class);
    }

    public void testHighAvailabilityMasterModeFailsIfAlreadyHasMaster() throws Exception {
        this.primary = BrooklynLauncher.newInstance();
        ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.primary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.AUTO)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).application(EntitySpec.create(TestApplication.class))).start();
        try {
            this.secondary = BrooklynLauncher.newInstance();
            ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.secondary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.MASTER)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testHighAvailabilityStandbyModeFailsIfNoExistingMaster() throws Exception {
        try {
            this.primary = BrooklynLauncher.newInstance();
            ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.primary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.STANDBY)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).ignorePersistenceErrors(false)).application(EntitySpec.create(TestApplication.class))).start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testHighAvailabilityHotStandbyModeFailsIfNoExistingMaster() throws Exception {
        try {
            this.primary = BrooklynLauncher.newInstance();
            ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.primary.webconsole(false).brooklynProperties(LocalManagementContextForTests.setEmptyCatalogAsDefault((BrooklynProperties)BrooklynProperties.Factory.newEmpty()))).highAvailabilityMode(HighAvailabilityMode.HOT_STANDBY)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10))).ignorePersistenceErrors(false)).application(EntitySpec.create(TestApplication.class))).start();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void assertOnlyApp(ManagementContext managementContext, Class<? extends Application> expectedType) {
        Assert.assertEquals((int)managementContext.getApplications().size(), (int)1, (String)("apps=" + managementContext.getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)managementContext.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class), null), (String)("apps=" + managementContext.getApplications()));
    }

    private void assertNoApps(ManagementContext managementContext) {
        if (!managementContext.getApplications().isEmpty()) {
            log.warn("FAILED assertion (rethrowing), apps=" + managementContext.getApplications());
        }
        Assert.assertTrue((boolean)managementContext.getApplications().isEmpty(), (String)("apps=" + managementContext.getApplications()));
    }

    private void assertOnlyAppEventually(final ManagementContext managementContext, final Class<? extends Application> expectedType) {
        Asserts.succeedsEventually((Runnable)new Runnable(){

            @Override
            public void run() {
                BrooklynLauncherHighAvailabilityTest.this.assertOnlyApp(managementContext, expectedType);
            }
        });
    }
}

