/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.AbstractBrooklynLauncherRebindTestFixture;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.os.Os;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynLauncherCleanStateTest
extends AbstractBrooklynLauncherRebindTestFixture {
    @Override
    protected String newTempPersistenceContainerName() {
        File persistenceDirF = Files.createTempDir();
        Os.deleteOnExitRecursively((File)persistenceDirF);
        return persistenceDirF.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testCleanStateState() throws Exception {
        final AtomicReference appToKeep = new AtomicReference();
        final AtomicReference locToKeep = new AtomicReference();
        final AtomicReference locToDelete = new AtomicReference();
        this.populatePersistenceDir(this.persistenceDir, new Function<ManagementContext, Void>(){

            public Void apply(ManagementContext mgmt) {
                TestApplication app = (TestApplication)mgmt.getEntityManager().createEntity(EntitySpec.create(TestApplication.class));
                SshMachineLocation loc = (SshMachineLocation)mgmt.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
                SshMachineLocation loc2 = (SshMachineLocation)mgmt.getLocationManager().createLocation(LocationSpec.create(SshMachineLocation.class));
                app.addLocations((Collection)ImmutableList.of((Object)loc));
                appToKeep.set(app);
                locToKeep.set(loc);
                locToDelete.set(loc2);
                return null;
            }
        });
        File destinationDir = Files.createTempDir();
        String destination = destinationDir.getAbsolutePath();
        String destinationLocation = null;
        try {
            BrooklynLauncher launcher = ((BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).highAvailabilityMode(HighAvailabilityMode.MASTER)).webconsole(false);
            launcher.cleanOrphanedState(destination, destinationLocation);
            launcher.terminate();
            File entities = new File(Os.mergePaths((String[])new String[]{destination}), "entities");
            Assert.assertTrue((boolean)entities.isDirectory(), (String)"entities directory should exist");
            Assert.assertEquals((int)entities.listFiles().length, (int)1, (String)("entities directory should contain one file (contained: " + Joiner.on((String)", ").join((Object[])entities.listFiles()) + ")"));
            File nodes = new File(Os.mergePaths((String[])new String[]{destination, "nodes"}));
            Assert.assertTrue((boolean)nodes.isDirectory(), (String)"nodes directory should exist");
            Assert.assertNotEquals((Object)nodes.listFiles().length, (Object)0, (String)"nodes directory should not be empty");
            ((BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).webconsole(false).persistenceDir(destinationDir)).start();
            Entity restoredApp = (Entity)Iterables.getOnlyElement((Iterable)this.lastMgmt().getEntityManager().getEntities());
            Location restoredLoc = (Location)Iterables.getOnlyElement((Iterable)this.lastMgmt().getLocationManager().getLocations());
            Assert.assertEquals((String)restoredApp.getId(), (String)((Entity)appToKeep.get()).getId());
            Assert.assertEquals((String)restoredLoc.getId(), (String)((Location)locToKeep.get()).getId());
        }
        finally {
            Os.deleteRecursively((File)destinationDir);
        }
    }
}

