/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestFixtureWithApp;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestUtils;
import org.apache.brooklyn.core.mgmt.rebind.transformer.impl.DeleteOrphanedStateTransformer;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.test.entity.TestEntityImpl;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.testng.Assert;

public abstract class AbstractCleanOrphanedStateTest
extends RebindTestFixtureWithApp {
    protected BrooklynMementoRawData assertTransformIsNoop() throws Exception {
        return this.assertTransformIsNoop(this.getRawData());
    }

    protected BrooklynMementoRawData assertTransformIsNoop(BrooklynMementoRawData origData) throws Exception {
        return this.assertTransformIsNoop(origData, (Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData>)Functions.identity());
    }

    protected BrooklynMementoRawData assertTransformIsNoop(Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData> origDataTweaker) throws Exception {
        return this.assertTransformIsNoop(this.getRawData(), origDataTweaker);
    }

    protected BrooklynMementoRawData assertTransformIsNoop(BrooklynMementoRawData origData, Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData> origDataTweaker) throws Exception {
        BrooklynMementoRawData origDataTweaked = (BrooklynMementoRawData)origDataTweaker.apply((Object)origData);
        BrooklynMementoRawData transformedData = this.transformRawData(origDataTweaked);
        this.assertRawData(transformedData, origDataTweaked);
        return transformedData;
    }

    protected BrooklynMementoRawData assertTransformDeletes(Deletions deletions) throws Exception {
        return this.assertTransformDeletes(deletions, (Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData>)Functions.identity());
    }

    protected BrooklynMementoRawData assertTransformDeletes(Deletions deletions, BrooklynMementoRawData origData) throws Exception {
        return this.assertTransformDeletes(deletions, origData, (Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData>)Functions.identity());
    }

    protected BrooklynMementoRawData assertTransformDeletes(Deletions deletions, Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData> origDataTweaker) throws Exception {
        return this.assertTransformDeletes(deletions, this.getRawData(), origDataTweaker);
    }

    protected BrooklynMementoRawData assertTransformDeletes(Deletions deletions, BrooklynMementoRawData origData, Function<? super BrooklynMementoRawData, ? extends BrooklynMementoRawData> origDataTweaker) throws Exception {
        BrooklynMementoRawData origDataTweaked = (BrooklynMementoRawData)origDataTweaker.apply((Object)origData);
        BrooklynMementoRawData transformedData = this.transformRawData(origDataTweaked);
        this.assertRawData(transformedData, origDataTweaked, deletions);
        return transformedData;
    }

    protected BrooklynMementoRawData getRawData() throws Exception {
        RebindTestUtils.waitForPersisted((Application)this.origApp);
        return this.mgmt().getRebindManager().retrieveMementoRawData();
    }

    protected BrooklynMementoRawData transformRawData(BrooklynMementoRawData rawData) throws Exception {
        DeleteOrphanedStateTransformer transformer = DeleteOrphanedStateTransformer.builder().build();
        return transformer.transform(rawData);
    }

    protected void assertRawData(BrooklynMementoRawData actual, BrooklynMementoRawData expected) {
        Assert.assertEquals(actual.getCatalogItems().keySet(), expected.getCatalogItems().keySet(), (String)"catalog ids differ");
        Assert.assertEquals((Map)actual.getCatalogItems(), (Map)expected.getCatalogItems());
        Assert.assertEquals(actual.getEntities().keySet(), expected.getEntities().keySet(), (String)"entity ids differ");
        Assert.assertEquals((Map)actual.getEntities(), (Map)expected.getEntities());
        Assert.assertEquals(actual.getLocations().keySet(), expected.getLocations().keySet(), (String)"location ids differ");
        Assert.assertEquals((Map)actual.getLocations(), (Map)expected.getLocations());
        Assert.assertEquals(actual.getEnrichers().keySet(), expected.getEnrichers().keySet(), (String)"enricher ids differ");
        Assert.assertEquals((Map)actual.getEnrichers(), (Map)expected.getEnrichers());
        Assert.assertEquals(actual.getPolicies().keySet(), expected.getPolicies().keySet(), (String)"policy ids differ");
        Assert.assertEquals((Map)actual.getPolicies(), (Map)expected.getPolicies());
        Assert.assertEquals(actual.getFeeds().keySet(), expected.getFeeds().keySet(), (String)"feed ids differ");
        Assert.assertEquals((Map)actual.getFeeds(), (Map)expected.getFeeds());
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)actual, (Object)expected));
    }

    protected void assertRawData(BrooklynMementoRawData actual, BrooklynMementoRawData orig, Deletions deletions) {
        BrooklynMementoRawData expected = new MementoTweaker(deletions).apply(orig);
        this.assertRawData(actual, expected);
        Assert.assertTrue((boolean)orig.getEntities().keySet().containsAll(deletions.entities));
        Assert.assertTrue((boolean)orig.getLocations().keySet().containsAll(deletions.locations));
        Assert.assertTrue((boolean)orig.getEnrichers().keySet().containsAll(deletions.enrichers));
        Assert.assertTrue((boolean)orig.getPolicies().keySet().containsAll(deletions.policies));
        Assert.assertTrue((boolean)orig.getFeeds().keySet().containsAll(deletions.feeds));
    }

    public static class MyEntity
    extends TestEntityImpl {
        protected void initEnrichers() {
        }
    }

    public static class MyFeed
    extends AbstractFeed {
    }

    public static class MyPolicy
    extends AbstractPolicy {
    }

    public static class MyEnricher
    extends AbstractEnricher {
        @SetFromFlag(value="myobj")
        Object obj;
    }

    protected static class Deletions {
        final Set<String> entities = Sets.newLinkedHashSet();
        final Set<String> locations = Sets.newLinkedHashSet();
        final Set<String> feeds = Sets.newLinkedHashSet();
        final Set<String> enrichers = Sets.newLinkedHashSet();
        final Set<String> policies = Sets.newLinkedHashSet();

        protected Deletions() {
        }

        protected Deletions entities(String ... vals) {
            if (vals != null) {
                this.entities.addAll(Arrays.asList(vals));
            }
            return this;
        }

        protected Deletions locations(String ... vals) {
            if (vals != null) {
                this.locations.addAll(Arrays.asList(vals));
            }
            return this;
        }

        protected Deletions locations(Iterable<String> vals) {
            if (vals != null) {
                Iterables.addAll(this.locations, vals);
            }
            return this;
        }

        protected Deletions feeds(String ... vals) {
            if (vals != null) {
                this.feeds.addAll(Arrays.asList(vals));
            }
            return this;
        }

        protected Deletions enrichers(String ... vals) {
            if (vals != null) {
                this.enrichers.addAll(Arrays.asList(vals));
            }
            return this;
        }

        protected Deletions policies(String ... vals) {
            if (vals != null) {
                this.policies.addAll(Arrays.asList(vals));
            }
            return this;
        }
    }

    public static class MementoTweaker
    implements Function<BrooklynMementoRawData, BrooklynMementoRawData> {
        private Deletions deletions;

        public MementoTweaker(Deletions deletions) {
            this.deletions = deletions;
        }

        public BrooklynMementoRawData apply(BrooklynMementoRawData input) {
            return BrooklynMementoRawData.builder().brooklynVersion(input.getBrooklynVersion()).catalogItems(input.getCatalogItems()).entities((Map)MutableMap.builder().putAll(input.getEntities()).removeAll(this.deletions.entities).build()).locations((Map)MutableMap.builder().putAll(input.getLocations()).removeAll(this.deletions.locations).build()).feeds((Map)MutableMap.builder().putAll(input.getFeeds()).removeAll(this.deletions.feeds).build()).enrichers((Map)MutableMap.builder().putAll(input.getEnrichers()).removeAll(this.deletions.enrichers).build()).policies((Map)MutableMap.builder().putAll(input.getPolicies()).removeAll(this.deletions.policies).build()).build();
        }
    }
}

