/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.entity.brooklynnode.BrooklynEntityMirror;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.SameBrooklynNodeImpl;
import org.apache.brooklyn.launcher.SimpleYamlLauncherForTests;
import org.apache.brooklyn.test.HttpTestUtils;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynNodeRestTest {
    private static final Logger log = LoggerFactory.getLogger(BrooklynNodeRestTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"WIP"})
    public void testBrooklynNodeRestDeployAndMirror() {
        final SimpleYamlLauncherForTests l = new SimpleYamlLauncherForTests();
        try {
            TestApplication app = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)l.getManagementContext());
            BrooklynNode bn = (BrooklynNode)app.createAndManageChild(EntitySpec.create(BrooklynNode.class, SameBrooklynNodeImpl.class));
            bn.start((Collection)MutableSet.of());
            URI uri = (URI)bn.getAttribute(BrooklynNode.WEB_CONSOLE_URI);
            Assert.assertNotNull((Object)uri);
            EntityAsserts.assertAttributeEqualsEventually((Entity)bn, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            log.info("Created BrooklynNode: " + bn);
            Task t = bn.invoke(BrooklynNode.DEPLOY_BLUEPRINT, ConfigBag.newInstance().configure(BrooklynNode.DeployBlueprintEffector.BLUEPRINT_TYPE, (Object)TestApplication.class.getName()).configure(BrooklynNode.DeployBlueprintEffector.BLUEPRINT_CONFIG, (Object)MutableMap.of((Object)"x", (Object)1, (Object)"y", (Object)"Y")).getAllConfig());
            log.info("Deployment result: " + t.getUnchecked());
            MutableSet apps = MutableSet.copyOf((Iterable)l.getManagementContext().getApplications());
            Assert.assertEquals((int)apps.size(), (int)2);
            apps.remove((Object)app);
            Application newApp = (Application)Iterables.getOnlyElement((Iterable)apps);
            Entities.dumpInfo((Entity)newApp);
            Assert.assertEquals((Object)newApp.getConfig((ConfigKey)new BasicConfigKey(Integer.class, "x")), (Object)1);
            String newAppId = newApp.getId();
            BrooklynEntityMirror mirror = (BrooklynEntityMirror)app.createAndManageChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(BrooklynEntityMirror.class).configure(BrooklynEntityMirror.MIRRORED_ENTITY_URL, (Object)Urls.mergePaths((String[])new String[]{uri.toString(), "/v1/applications/" + newAppId + "/entities/" + newAppId}))).configure(BrooklynEntityMirror.MIRRORED_ENTITY_ID, (Object)newAppId)).configure(BrooklynEntityMirror.POLL_PERIOD, (Object)Duration.millis((Number)10)));
            Entities.dumpInfo((Entity)mirror);
            EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            ((EntityInternal)newApp).sensors().set(TestEntity.NAME, (Object)"foo");
            EntityAsserts.assertAttributeEqualsEventually((Entity)mirror, (AttributeSensor)TestEntity.NAME, (Object)"foo");
            log.info("Mirror successfully validated");
            HttpClient client = HttpTool.httpClientBuilder().build();
            HttpToolResponse result = HttpTool.httpPost((HttpClient)client, (URI)URI.create(Urls.mergePaths((String[])new String[]{uri.toString(), "/v1/applications/" + app.getId() + "/entities/" + bn.getId() + "/effectors/deployBlueprint"})), (Map)MutableMap.of((Object)"Content-Type", (Object)"application/json"), (byte[])Jsonya.newInstance().put((Object)"blueprintType", (Object)TestApplication.class.getName(), new Object[0]).put((Object)"blueprintConfig", (Object)MutableMap.of((Object)TestEntity.CONF_NAME.getName(), (Object)"foo"), new Object[0]).toString().getBytes());
            log.info("Deploy effector invoked, result: " + result);
            HttpTestUtils.assertHealthyStatusCode((int)result.getResponseCode());
            Repeater.create().every(Duration.millis((Number)10)).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return l.getManagementContext().getApplications().size() == 3;
                }
            }).limitTimeTo(Duration.TEN_SECONDS).runRequiringTrue();
            apps = MutableSet.copyOf((Iterable)l.getManagementContext().getApplications());
            apps.removeAll((Collection)MutableSet.of((Object)app, (Object)newApp));
            Application newApp2 = (Application)Iterables.getOnlyElement((Iterable)apps);
            Entities.dumpInfo((Entity)newApp2);
            EntityAsserts.assertAttributeEqualsEventually((Entity)newApp2, (AttributeSensor)Attributes.SERVICE_UP, (Object)true);
            Assert.assertEquals((String)((String)newApp2.getConfig(TestEntity.CONF_NAME)), (String)"foo");
        }
        finally {
            l.destroyAll();
        }
        log.info("DONE");
    }
}

