/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.blueprints;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.cloudsoft.winrm4j.winrm.WinRmTool;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcess;
import org.apache.brooklyn.entity.software.base.test.location.WindowsTestFixture;
import org.apache.brooklyn.launcher.blueprints.AbstractBlueprintTest;
import org.apache.brooklyn.location.winrm.AdvertiseWinrmLoginPolicy;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Windows7zipBlueprintLiveTest
extends AbstractBlueprintTest {
    private static final Logger LOG = LoggerFactory.getLogger(Windows7zipBlueprintLiveTest.class);
    protected MachineProvisioningLocation<WinRmMachineLocation> location;
    protected WinRmMachineLocation machine;

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.location = WindowsTestFixture.setUpWindowsLocation((ManagementContext)this.mgmt);
        this.machine = (WinRmMachineLocation)this.location.obtain((Map)ImmutableMap.of());
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            if (this.location != null && this.machine != null) {
                this.location.release((MachineLocation)this.machine);
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Test(groups={"Live"})
    public void test7zip() throws Exception {
        String yamlApp = Joiner.on((String)"\n").join((Object)"location:", (Object)"  byon:", new Object[]{"    hosts:", "    - winrm: " + this.machine.getAddress().getHostAddress() + ":5985", "      password: " + (String)this.machine.config().get(WinRmMachineLocation.PASSWORD), "      user: Administrator", "      osFamily: windows", "services:", "- type: org.apache.brooklyn.windows.7zip:1.0"});
        Predicate<Application> asserter = new Predicate<Application>(){

            public boolean apply(Application app) {
                VanillaWindowsProcess entity = (VanillaWindowsProcess)Iterables.getOnlyElement((Iterable)Entities.descendantsAndSelf((Entity)app, VanillaWindowsProcess.class));
                String winRMAddress = (String)entity.getAttribute(AdvertiseWinrmLoginPolicy.VM_USER_CREDENTIALS);
                String ipPort = Strings.getFirstWordAfter((String)winRMAddress, (String)"@");
                String user = Strings.getFirstWord((String)winRMAddress);
                String password = Strings.getFirstWordAfter((String)winRMAddress, (String)":");
                WinRmTool winRmTool = WinRmTool.connect((String)ipPort, (String)user, (String)password);
                WinRmToolResponse winRmResponse = winRmTool.executePs((List)ImmutableList.of((Object)"(Get-Item \"C:\\\\Program Files\\\\7-Zip\\\\7z.exe\").name"));
                LOG.info("winRmResponse: code=" + winRmResponse.getStatusCode() + "; out=" + winRmResponse.getStdOut() + "; err=" + winRmResponse.getStdErr());
                return "7z.exe\r\n".equals(winRmResponse.getStdOut());
            }
        };
        this.runCatalogTest("7zip-catalog.yaml", new StringReader(yamlApp), (Predicate<? super Application>)asserter);
    }
}

