/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.rebind.PersistenceExceptionHandlerImpl;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.launcher.AbstractCleanOrphanedStateTest;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CleanOrphanedLocationsIntegrationTest
extends AbstractCleanOrphanedStateTest {
    private static final Logger LOG = LoggerFactory.getLogger(CleanOrphanedLocationsIntegrationTest.class);
    private final String PERSISTED_STATE_PATH_WITH_ORPHANED_LOCATIONS = "/orphaned-locations-test-data/data-with-orphaned-locations";
    private final String PERSISTED_STATE_PATH_WITH_MULTIPLE_LOCATIONS_OCCURRENCE = "/orphaned-locations-test-data/fake-multiple-location-for-multiple-search-tests";
    private final String PERSISTED_STATE_PATH_WITHOUT_ORPHANED_LOCATIONS = "/orphaned-locations-test-data/data-without-orphaned-locations";
    private String persistenceDirWithOrphanedLocations;
    private String persistenceDirWithoutOrphanedLocations;
    private String persistenceDirWithMultipleLocationsOccurrence;
    private File destinationDir;
    private Set<ManagementContext> mgmts;
    private ManagementContext mgmt;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.persistenceDirWithOrphanedLocations = ((Object)((Object)this)).getClass().getResource("/orphaned-locations-test-data/data-with-orphaned-locations").getFile();
        this.persistenceDirWithoutOrphanedLocations = ((Object)((Object)this)).getClass().getResource("/orphaned-locations-test-data/data-without-orphaned-locations").getFile();
        this.persistenceDirWithMultipleLocationsOccurrence = ((Object)((Object)this)).getClass().getResource("/orphaned-locations-test-data/fake-multiple-location-for-multiple-search-tests").getFile();
        this.destinationDir = Os.newTempDir(((Object)((Object)this)).getClass());
        this.mgmts = Sets.newLinkedHashSet();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        for (ManagementContext mgmt : this.mgmts) {
            try {
                if (mgmt == null) continue;
                Entities.destroyAll((ManagementContext)mgmt);
            }
            catch (Throwable t) {
                LOG.error("Caught exception in tearDown method", t);
            }
        }
        if (this.destinationDir != null) {
            Os.deleteRecursively((File)this.destinationDir);
        }
        this.mgmts.clear();
    }

    private void initManagementContextAndPersistence(String persistenceDir) {
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.builderDefault().build();
        brooklynProperties.put((Object)BrooklynServerConfig.MGMT_BASE_DIR.getName(), (Object)"");
        brooklynProperties.put(BrooklynServerConfig.OSGI_CACHE_DIR, (Object)("target/" + (String)BrooklynServerConfig.OSGI_CACHE_DIR.getDefaultValue()));
        this.mgmt = LocalManagementContextForTests.newInstance((BrooklynProperties)brooklynProperties);
        this.mgmts.add(this.mgmt);
        persistenceDir = BrooklynServerPaths.newMainPersistencePathResolver((StringConfigMap)brooklynProperties).dir(persistenceDir).resolve();
        PersistenceObjectStore objectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.mgmt, null, (String)persistenceDir, (PersistMode)PersistMode.AUTO, (HighAvailabilityMode)HighAvailabilityMode.HOT_STANDBY);
        BrooklynMementoPersisterToObjectStore persister = new BrooklynMementoPersisterToObjectStore(objectStore, (StringConfigMap)((ManagementContextInternal)this.mgmt).getBrooklynProperties(), this.mgmt.getCatalogClassLoader());
        RebindManager rebindManager = this.mgmt.getRebindManager();
        PersistenceExceptionHandler persistenceExceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
        ((RebindManagerImpl)rebindManager).setPeriodicPersistPeriod(Duration.ONE_SECOND);
        rebindManager.setPersister((BrooklynMementoPersister)persister, persistenceExceptionHandler);
    }

    @Test
    public void testSelectionWithOrphanedLocationsInData() throws Exception {
        MutableSet orphanedLocations = MutableSet.of((Object)"msyp655po0", (Object)"ppamsemxgo");
        this.initManagementContextAndPersistence(this.persistenceDirWithOrphanedLocations);
        BrooklynMementoRawData mementoRawData = this.mgmt.getRebindManager().retrieveMementoRawData();
        this.assertTransformDeletes(new AbstractCleanOrphanedStateTest.Deletions().locations((Iterable<String>)orphanedLocations), mementoRawData);
    }

    @Test
    public void testSelectionWithoutOrphanedLocationsInData() throws Exception {
        this.initManagementContextAndPersistence(this.persistenceDirWithoutOrphanedLocations);
        BrooklynMementoRawData mementoRawData = this.mgmt.getRebindManager().retrieveMementoRawData();
        this.assertTransformIsNoop(mementoRawData);
    }

    @Test
    public void testCleanedCopiedPersistedState() throws Exception {
        BrooklynLauncher launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)BrooklynLauncher.newInstance().webconsole(false).brooklynProperties(OsgiManager.USE_OSGI, (Object)false)).persistMode(PersistMode.AUTO)).persistenceDir(this.persistenceDirWithOrphanedLocations)).highAvailabilityMode(HighAvailabilityMode.DISABLED);
        ManagementContext mgmtForCleaning = null;
        try {
            launcher.cleanOrphanedState(this.destinationDir.getAbsolutePath(), null);
            mgmtForCleaning = launcher.getManagementContext();
        }
        catch (Throwable throwable) {
            launcher.terminate();
            if (mgmtForCleaning != null) {
                Entities.destroyAll(mgmtForCleaning);
            }
            throw throwable;
        }
        launcher.terminate();
        if (mgmtForCleaning != null) {
            Entities.destroyAll((ManagementContext)mgmtForCleaning);
        }
        this.initManagementContextAndPersistence(this.destinationDir.getAbsolutePath());
        BrooklynMementoRawData mementoRawDataFromCleanedState = this.mgmt.getRebindManager().retrieveMementoRawData();
        Asserts.assertTrue((mementoRawDataFromCleanedState.getEntities().size() != 0 ? 1 : 0) != 0);
        Asserts.assertTrue((mementoRawDataFromCleanedState.getLocations().size() != 0 ? 1 : 0) != 0);
        this.initManagementContextAndPersistence(this.persistenceDirWithoutOrphanedLocations);
        BrooklynMementoRawData mementoRawData = this.mgmt.getRebindManager().retrieveMementoRawData();
        this.assertRawData(mementoRawData, mementoRawDataFromCleanedState);
    }

    @Test
    public void testMultipleLocationOccurrenceInEntity() throws Exception {
        this.initManagementContextAndPersistence(this.persistenceDirWithMultipleLocationsOccurrence);
        BrooklynMementoRawData mementoRawData = this.mgmt.getRebindManager().retrieveMementoRawData();
        this.assertTransformIsNoop(mementoRawData);
    }
}

