/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.launcher.BrooklynWebServer;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BrooklynWebServerTest {
    public static final Logger log = LoggerFactory.getLogger(BrooklynWebServer.class);
    private BrooklynProperties brooklynProperties;
    private BrooklynWebServer webServer;
    private List<LocalManagementContext> managementContexts = Lists.newCopyOnWriteArrayList();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.brooklynProperties = BrooklynProperties.Factory.newEmpty();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (LocalManagementContext managementContext : this.managementContexts) {
            Entities.destroyAll((ManagementContext)managementContext);
        }
        this.managementContexts.clear();
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    private LocalManagementContext newManagementContext(BrooklynProperties brooklynProperties) {
        LocalManagementContextForTests result = new LocalManagementContextForTests(brooklynProperties);
        this.managementContexts.add((LocalManagementContext)result);
        return result;
    }

    @Test
    public void verifyHttp() throws Exception {
        this.webServer = new BrooklynWebServer((ManagementContext)this.newManagementContext(this.brooklynProperties));
        this.webServer.skipSecurity();
        try {
            this.webServer.start();
            HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().build(), (HttpUriRequest)new HttpGet(this.webServer.getRootUrl()));
            Assert.assertEquals((int)response.getResponseCode(), (int)200);
        }
        finally {
            this.webServer.stop();
        }
    }

    @Test
    public void verifySecurityInitialized() throws Exception {
        this.webServer = new BrooklynWebServer((ManagementContext)this.newManagementContext(this.brooklynProperties));
        this.webServer.start();
        try {
            HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().build(), (HttpUriRequest)new HttpGet(this.webServer.getRootUrl()));
            Assert.assertEquals((int)response.getResponseCode(), (int)401);
        }
        finally {
            this.webServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifySecurityInitializedExplicitUser() throws Exception {
        this.webServer = new BrooklynWebServer((ManagementContext)this.newManagementContext(this.brooklynProperties));
        this.webServer.start();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("myuser", "somepass"));
        HttpClient client = HttpTool.httpClientBuilder().credentials((Credentials)new UsernamePasswordCredentials("myuser", "somepass")).uri(this.webServer.getRootUrl()).build();
        try {
            HttpToolResponse response = HttpTool.execAndConsume((HttpClient)client, (HttpUriRequest)new HttpGet(this.webServer.getRootUrl()));
            Assert.assertEquals((int)response.getResponseCode(), (int)401);
        }
        finally {
            this.webServer.stop();
        }
    }

    @DataProvider(name="keystorePaths")
    public Object[][] getKeystorePaths() {
        return new Object[][]{{this.getFile("server.ks")}, {new File(this.getFile("server.ks")).toURI().toString()}, {"classpath://server.ks"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="keystorePaths")
    public void verifyHttps(String keystoreUrl) throws Exception {
        ImmutableMap flags = ImmutableMap.builder().put((Object)"httpsEnabled", (Object)true).put((Object)"keystoreUrl", (Object)keystoreUrl).put((Object)"keystorePassword", (Object)"password").build();
        this.webServer = new BrooklynWebServer((Map)flags, (ManagementContext)this.newManagementContext(this.brooklynProperties));
        this.webServer.skipSecurity().start();
        try {
            KeyStore keyStore = this.load("client.ks", "password");
            KeyStore trustStore = this.load("client.ts", "password");
            SSLSocketFactory socketFactory = new SSLSocketFactory("TLS", keyStore, "password", trustStore, (SecureRandom)null, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().port(this.webServer.getActualPort()).https(true).socketFactory((SchemeSocketFactory)socketFactory).build(), (HttpUriRequest)new HttpGet(this.webServer.getRootUrl()));
            Assert.assertEquals((int)response.getResponseCode(), (int)200);
        }
        finally {
            this.webServer.stop();
        }
    }

    @Test
    public void verifyHttpsFromConfig() throws Exception {
        this.brooklynProperties.put(BrooklynWebConfig.HTTPS_REQUIRED, (Object)true);
        this.brooklynProperties.put(BrooklynWebConfig.KEYSTORE_URL, (Object)this.getFile("server.ks"));
        this.brooklynProperties.put(BrooklynWebConfig.KEYSTORE_PASSWORD, (Object)"password");
        this.verifyHttpsFromConfig(this.brooklynProperties);
    }

    @Test
    public void verifyHttpsCiphers() throws Exception {
        this.brooklynProperties.put(BrooklynWebConfig.HTTPS_REQUIRED, (Object)true);
        this.brooklynProperties.put(BrooklynWebConfig.TRANSPORT_PROTOCOLS, (Object)"XXX");
        this.brooklynProperties.put(BrooklynWebConfig.TRANSPORT_CIPHERS, (Object)"XXX");
        try {
            this.verifyHttpsFromConfig(this.brooklynProperties);
            Assert.fail((String)"Expected to fail due to unsupported ciphers during connection negotiation");
        }
        catch (Exception e) {
            Assert.assertTrue((Exceptions.getFirstThrowableOfType((Throwable)e, SocketException.class) != null || Exceptions.getFirstThrowableOfType((Throwable)e, SSLHandshakeException.class) != null ? 1 : 0) != 0, (String)"Expected to fail due to inability to negotiate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyHttpsFromConfig(BrooklynProperties brooklynProperties) throws Exception {
        this.webServer = new BrooklynWebServer((Map)MutableMap.of(), (ManagementContext)this.newManagementContext(brooklynProperties));
        this.webServer.skipSecurity();
        this.webServer.start();
        try {
            KeyStore keyStore = this.load("client.ks", "password");
            KeyStore trustStore = this.load("client.ts", "password");
            SSLSocketFactory socketFactory = new SSLSocketFactory("TLS", keyStore, "password", trustStore, (SecureRandom)null, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().port(this.webServer.getActualPort()).https(true).socketFactory((SchemeSocketFactory)socketFactory).build(), (HttpUriRequest)new HttpGet(this.webServer.getRootUrl()));
            Assert.assertEquals((int)response.getResponseCode(), (int)200);
        }
        finally {
            this.webServer.stop();
        }
    }

    private KeyStore load(String name, String password) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream instream = new FileInputStream(new File(this.getFile(name)));
        keystore.load(instream, password.toCharArray());
        return keystore;
    }

    @Test
    public void testGetFileFromUrl() throws Exception {
        String url = "file:///tmp/special%40file%20with%20spaces";
        String file = "/tmp/special@file with spaces";
        Assert.assertEquals((String)this.getFile(new URL(url)), (String)new File(file).getAbsolutePath());
    }

    private String getFile(String classpathResource) {
        return this.getFile(this.getClass().getResource("/" + classpathResource));
    }

    private String getFile(URL url) {
        try {
            return new File(url.toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

