/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.core.test.entity.TestApplicationImpl;
import org.apache.brooklyn.core.test.entity.TestEntity;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.launcher.common.BrooklynPropertiesFactoryHelperTest;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.util.http.HttpAsserts;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BrooklynLauncherTest {
    private BrooklynLauncher launcher;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.launcher != null) {
            this.launcher.terminate();
        }
        this.launcher = null;
    }

    @Test(groups={"Integration"})
    public void testStartsWebServerOnExpectectedPort() throws Exception {
        this.launcher = (BrooklynLauncher)this.newLauncherForTests(true).webconsolePort("10000+").installSecurityFilter(Boolean.valueOf(false)).start();
        String webServerUrlStr = this.launcher.getServerDetails().getWebServerUrl();
        URI webServerUri = new URI(webServerUrlStr);
        Assert.assertEquals((Collection)this.launcher.getApplications(), (Collection)ImmutableList.of());
        Assert.assertTrue((webServerUri.getPort() >= 10000 && webServerUri.getPort() < 10100 ? 1 : 0) != 0, (String)("port=" + webServerUri.getPort() + "; uri=" + webServerUri));
        HttpAsserts.assertUrlReachable((String)webServerUrlStr);
    }

    @Test(groups={"Integration"})
    public void testWebServerTempDirRespectsDataDirConfig() throws Exception {
        String dataDirName = ".brooklyn-foo" + Strings.makeRandomId((int)4);
        String dataDir = "~/" + dataDirName;
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).brooklynProperties(BrooklynServerConfig.MGMT_BASE_DIR, (Object)dataDir)).start();
        ManagementContext managementContext = this.launcher.getServerDetails().getManagementContext();
        String expectedTempDir = Os.mergePaths((String[])new String[]{Os.home(), dataDirName, "planes", managementContext.getManagementPlaneId(), managementContext.getManagementNodeId(), "jetty"});
        File webappTempDir = this.launcher.getServerDetails().getWebServer().getWebappTempDir();
        Assert.assertEquals((String)webappTempDir.getAbsolutePath(), (String)expectedTempDir);
    }

    @Test(groups={"Integration"})
    public void testStartsWebServerWithoutAuthentication() throws Exception {
        this.launcher = (BrooklynLauncher)this.newLauncherForTests(true).start();
        String uri = this.launcher.getServerDetails().getWebServerUrl();
        HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().build(), (HttpUriRequest)new HttpGet(uri));
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(groups={"Integration"})
    public void testStartsWebServerWithCredentials() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsolePort("10000+").brooklynProperties(BrooklynWebConfig.USERS, (Object)"myname")).brooklynProperties(BrooklynWebConfig.PASSWORD_FOR_USER((String)"myname"), (Object)"mypassword")).start();
        String uri = this.launcher.getServerDetails().getWebServerUrl();
        HttpToolResponse response = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().build(), (HttpUriRequest)new HttpGet(uri));
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
        HttpToolResponse response2 = HttpTool.execAndConsume((HttpClient)HttpTool.httpClientBuilder().uri(uri).credentials((Credentials)new UsernamePasswordCredentials("myname", "mypassword")).build(), (HttpUriRequest)new HttpGet(uri));
        Assert.assertEquals((int)response2.getResponseCode(), (int)200);
    }

    @Test
    public void testCanDisableWebServerStartup() throws Exception {
        this.launcher = (BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).start();
        Assert.assertNull((Object)this.launcher.getServerDetails().getWebServer());
        Assert.assertNull((Object)this.launcher.getServerDetails().getWebServerUrl());
        Assert.assertTrue((boolean)((ManagementContextInternal)this.launcher.getServerDetails().getManagementContext()).errors().isEmpty());
    }

    @Test
    public void testStartsAppInstance() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).application(EntitySpec.create(TestApplicationImpl.class))).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromSpec() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).application(EntitySpec.create(TestApplication.class))).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromBuilder() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).application(new ApplicationBuilder(EntitySpec.create(TestApplication.class)){

            protected void doBuild() {
            }
        })).start();
        this.assertOnlyApp(this.launcher, TestApplication.class);
    }

    @Test
    public void testStartsAppFromYAML() throws Exception {
        String yaml = "name: example-app\nservices:\n- serviceType: org.apache.brooklyn.core.test.entity.TestEntity\n  name: test-app";
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).application(yaml)).start();
        Assert.assertEquals((int)this.launcher.getApplications().size(), (int)1, (String)("apps=" + this.launcher.getApplications()));
        Application app = (Application)Iterables.getOnlyElement((Iterable)this.launcher.getApplications());
        Assert.assertEquals((int)app.getChildren().size(), (int)1, (String)("children=" + app.getChildren()));
        Assert.assertTrue((boolean)(Iterables.getOnlyElement((Iterable)app.getChildren()) instanceof TestEntity));
    }

    @Test
    public void testStartsAppInSuppliedLocations() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).location("localhost")).application(EntitySpec.create(TestApplication.class))).start();
        Application app = (Application)Iterables.find((Iterable)this.launcher.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class));
        this.assertOnlyLocation(app, LocalhostMachineProvisioningLocation.class);
    }

    @Test
    public void testUsesSuppliedManagementContext() throws Exception {
        LocalManagementContext myManagementContext = LocalManagementContextForTests.newInstance();
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(false).webconsole(false).managementContext((ManagementContext)myManagementContext)).start();
        Assert.assertSame((Object)this.launcher.getServerDetails().getManagementContext(), (Object)myManagementContext);
    }

    @Test
    public void testUsesSuppliedBrooklynProperties() throws Exception {
        BrooklynProperties props = LocalManagementContextForTests.builder((boolean)true).buildProperties();
        props.put((Object)"mykey", (Object)"myval");
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(false).webconsole(false).brooklynProperties(props)).start();
        Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    @Test
    public void testUsesSupplementaryBrooklynProperties() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).brooklynProperties("mykey", (Object)"myval")).start();
        Assert.assertEquals((String)this.launcher.getServerDetails().getManagementContext().getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    @Test
    public void testReloadBrooklynPropertiesRestoresProgrammaticProperties() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).webconsole(false).brooklynProperties("mykey", (Object)"myval")).start();
        LocalManagementContext managementContext = (LocalManagementContext)this.launcher.getServerDetails().getManagementContext();
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
        managementContext.getBrooklynProperties().put((Object)"mykey", (Object)"newval");
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"newval");
        managementContext.reloadBrooklynProperties();
        Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadBrooklynPropertiesFromFile() throws Exception {
        File globalPropertiesFile = File.createTempFile("local-brooklyn-properties-test", ".properties");
        FileUtil.setFilePermissionsTo600((File)globalPropertiesFile);
        try {
            String property = "mykey=myval";
            Files.append((CharSequence)(BrooklynPropertiesFactoryHelperTest.getMinimalLauncherPropertiesString() + property), (File)globalPropertiesFile, (Charset)Charsets.UTF_8);
            this.launcher = (BrooklynLauncher)this.newLauncherForTests(false).webconsole(false).globalBrooklynPropertiesFile(globalPropertiesFile.getAbsolutePath()).start();
            LocalManagementContext managementContext = (LocalManagementContext)this.launcher.getServerDetails().getManagementContext();
            Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"myval");
            property = "mykey=newval";
            Files.write((CharSequence)(BrooklynPropertiesFactoryHelperTest.getMinimalLauncherPropertiesString() + property), (File)globalPropertiesFile, (Charset)Charsets.UTF_8);
            managementContext.reloadBrooklynProperties();
            Assert.assertEquals((String)managementContext.getConfig().getFirst(new String[]{"mykey"}), (String)"newval");
        }
        finally {
            globalPropertiesFile.delete();
        }
    }

    @Test
    public void testErrorsCaughtByApiAndRestApiWorks() throws Exception {
        this.launcher = (BrooklynLauncher)((BrooklynLauncher)this.newLauncherForTests(true).catalogInitialization(new CatalogInitialization(null, false, null, false).addPopulationCallback((Function)new Function<CatalogInitialization, Void>(){

            public Void apply(CatalogInitialization input) {
                throw new RuntimeException("deliberate-exception-for-testing");
            }
        }))).installSecurityFilter(Boolean.valueOf(false)).start();
        ManagementContext mgmt = this.launcher.getServerDetails().getManagementContext();
        Assert.assertFalse((boolean)((ManagementContextInternal)mgmt).errors().isEmpty());
        Assert.assertTrue((boolean)((Throwable)((ManagementContextInternal)mgmt).errors().get(0)).toString().contains("deliberate"), (String)("" + ((ManagementContextInternal)mgmt).errors()));
        HttpAsserts.assertContentMatches((String)Urls.mergePaths((String[])new String[]{this.launcher.getServerDetails().getWebServerUrl(), "v1/server/up"}), (String)"true");
        HttpAsserts.assertContentMatches((String)Urls.mergePaths((String[])new String[]{this.launcher.getServerDetails().getWebServerUrl(), "v1/server/healthy"}), (String)"false");
    }

    private BrooklynLauncher newLauncherForTests(boolean minimal) {
        Preconditions.checkArgument((this.launcher == null ? 1 : 0) != 0, (Object)"can only be used if no launcher yet");
        BrooklynLauncher launcher = BrooklynLauncher.newInstance();
        if (minimal) {
            launcher.brooklynProperties(LocalManagementContextForTests.builder((boolean)true).buildProperties());
        }
        return launcher;
    }

    private void assertOnlyApp(BrooklynLauncher launcher, Class<? extends Application> expectedType) {
        Assert.assertEquals((int)launcher.getApplications().size(), (int)1, (String)("apps=" + launcher.getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)launcher.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class), null), (String)("apps=" + launcher.getApplications()));
    }

    private void assertOnlyLocation(Application app, Class<? extends Location> expectedType) {
        Assert.assertEquals((int)app.getLocations().size(), (int)1, (String)("locs=" + app.getLocations()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)app.getLocations(), (Predicate)Predicates.instanceOf(LocalhostMachineProvisioningLocation.class), null), (String)("locs=" + app.getLocations()));
    }
}

