/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import java.util.Map;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.jclouds.JcloudsBlobStoreBasedObjectStore;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.launcher.BrooklynLauncherRebindTestFixture;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"Live"})
public class BrooklynLauncherRebindToCloudObjectStoreTest
extends BrooklynLauncherRebindTestFixture {
    public BrooklynLauncherRebindToCloudObjectStoreTest() {
        this.persistenceLocationSpec = "named:brooklyn-jclouds-objstore-test-1";
    }

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.persistenceDir = this.newTempPersistenceContainerName();
    }

    @Override
    protected BrooklynLauncher newLauncherBase() {
        return (BrooklynLauncher)super.newLauncherBase().persistenceLocation(this.persistenceLocationSpec);
    }

    @Override
    protected LocalManagementContextForTests newManagementContextForTests(BrooklynProperties props) {
        BrooklynProperties p2 = BrooklynProperties.Factory.newDefault();
        if (props != null) {
            p2.putAll((Map)props);
        }
        return new LocalManagementContextForTests(p2);
    }

    @Override
    protected String newTempPersistenceContainerName() {
        return "test-" + JavaClassNames.callerStackElement((int)0).getClassName() + "-" + Identifiers.makeRandomId((int)4);
    }

    @Override
    protected String badContainerName() {
        return "container-does-not-exist-" + Identifiers.makeRandomId((int)4);
    }

    @Override
    protected void checkPersistenceContainerNameIs(String expected) {
        Assert.assertEquals((String)BrooklynLauncherRebindToCloudObjectStoreTest.getPersistenceContainerName(this.lastMgmt()), (String)expected);
    }

    static String getPersistenceContainerName(ManagementContext managementContext) {
        BrooklynMementoPersisterToObjectStore persister = (BrooklynMementoPersisterToObjectStore)managementContext.getRebindManager().getPersister();
        JcloudsBlobStoreBasedObjectStore store = (JcloudsBlobStoreBasedObjectStore)persister.getObjectStore();
        return store.getContainerName();
    }

    @Override
    protected void checkPersistenceContainerNameIsDefault() {
        this.checkPersistenceContainerNameIs("brooklyn-persisted-state");
    }

    @Override
    @Test(groups={"Live"})
    public void testRebindsToExistingApp() throws Exception {
        super.testRebindsToExistingApp();
    }

    @Override
    @Test(groups={"Live"})
    public void testRebindCanAddNewApps() throws Exception {
        super.testRebindCanAddNewApps();
    }

    @Override
    @Test(groups={"Live"})
    public void testAutoRebindsToExistingApp() throws Exception {
        super.testAutoRebindsToExistingApp();
    }

    @Override
    @Test(groups={"Live", "WIP"})
    public void testCleanDoesNotRebindToExistingApp() throws Exception {
        super.testCleanDoesNotRebindToExistingApp();
    }

    @Override
    @Test(groups={"Live"})
    public void testAutoRebindCreatesNewIfEmptyDir() throws Exception {
        super.testAutoRebindCreatesNewIfEmptyDir();
    }

    @Override
    @Test(groups={"Live"})
    public void testRebindRespectsPersistenceDirSetInProperties() throws Exception {
        super.testRebindRespectsPersistenceDirSetInProperties();
    }

    @Override
    @Test(groups={"Live"})
    public void testRebindRespectsDefaultPersistenceDir() throws Exception {
        super.testRebindRespectsDefaultPersistenceDir();
    }

    @Override
    @Test(groups={"Live"})
    public void testPersistenceFailsIfNoDir() throws Exception {
        super.testPersistenceFailsIfNoDir();
    }

    @Override
    @Test(groups={"Live"})
    public void testExplicitRebindFailsIfEmpty() throws Exception {
        super.testExplicitRebindFailsIfEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Live"})
    public void testCopyPersistedState() throws Exception {
        EntitySpec appSpec = EntitySpec.create(TestApplication.class);
        this.populatePersistenceDir(this.persistenceDir, (EntitySpec<? extends StartableApplication>)appSpec);
        String destinationDir = this.newTempPersistenceContainerName();
        String destinationLocation = this.persistenceLocationSpec;
        try {
            BrooklynLauncher launcher = (BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).webconsole(false).persistenceLocation(this.persistenceLocationSpec);
            BrooklynMementoRawData memento = launcher.retrieveState();
            launcher.persistState(memento, destinationDir, destinationLocation);
            launcher.terminate();
            Assert.assertEquals((int)memento.getEntities().size(), (int)1, (String)("entityMementos=" + memento.getEntities().keySet()));
            ((BrooklynLauncher)((BrooklynLauncher)this.newLauncherDefault(PersistMode.AUTO).webconsole(false).persistenceDir(destinationDir)).persistenceLocation(destinationLocation)).start();
            this.assertOnlyApp(this.lastMgmt(), TestApplication.class);
        }
        finally {
            Os.deleteRecursively((String)destinationDir);
        }
    }
}

