/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.core.entity.StartableApplication;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.core.test.entity.TestApplication;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractBrooklynLauncherRebindTestFixture {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrooklynLauncherRebindTestFixture.class);
    protected String persistenceDir;
    protected String persistenceLocationSpec;
    protected List<BrooklynLauncher> launchers = MutableList.of();

    protected abstract String newTempPersistenceContainerName();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.persistenceDir = this.newTempPersistenceContainerName();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (BrooklynLauncher l : this.launchers) {
            if (!l.isStarted()) continue;
            l.terminate();
            PersistenceObjectStore store = AbstractBrooklynLauncherRebindTestFixture.getPersistenceStore(l.getServerDetails().getManagementContext());
            if (store == null) continue;
            store.deleteCompletely();
        }
    }

    protected BrooklynLauncher newLauncherBase() {
        BrooklynLauncher l = BrooklynLauncher.newInstance().webconsole(false);
        this.launchers.add(l);
        return l;
    }

    protected BrooklynLauncher newLauncherDefault(PersistMode mode) {
        return (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherBase().managementContext((ManagementContext)this.newManagementContextForTests(null))).persistMode(mode)).persistenceDir(this.persistenceDir)).persistPeriod(Duration.millis((Number)10));
    }

    protected LocalManagementContextForTests newManagementContextForTests(BrooklynProperties props) {
        if (props == null) {
            return new LocalManagementContextForTests();
        }
        return new LocalManagementContextForTests(props);
    }

    protected ManagementContext lastMgmt() {
        return ((BrooklynLauncher)Iterables.getLast(this.launchers)).getServerDetails().getManagementContext();
    }

    protected void runRebindFails(PersistMode persistMode, String dir, String errmsg) throws Exception {
        block2: {
            try {
                ((BrooklynLauncher)this.newLauncherDefault(persistMode).persistenceDir(dir)).start();
            }
            catch (FatalConfigurationRuntimeException e) {
                if (e.toString().contains(errmsg)) break block2;
                throw e;
            }
        }
    }

    protected void populatePersistenceDir(String dir, EntitySpec<? extends StartableApplication> appSpec) throws Exception {
        BrooklynLauncher launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherDefault(PersistMode.CLEAN).highAvailabilityMode(HighAvailabilityMode.MASTER)).persistenceDir(dir)).application(appSpec)).start();
        launcher.terminate();
        this.assertMementoContainerNonEmptyForTypeEventually("entities");
    }

    protected void populatePersistenceDir(String dir, Function<ManagementContext, Void> populator) throws Exception {
        BrooklynLauncher launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)this.newLauncherDefault(PersistMode.CLEAN).highAvailabilityMode(HighAvailabilityMode.MASTER)).persistenceDir(dir)).start();
        populator.apply((Object)launcher.getManagementContext());
        launcher.terminate();
        this.assertMementoContainerNonEmptyForTypeEventually("entities");
    }

    protected void assertOnlyApp(ManagementContext managementContext, Class<? extends Application> expectedType) {
        Assert.assertEquals((int)managementContext.getApplications().size(), (int)1, (String)("apps=" + managementContext.getApplications()));
        Assert.assertNotNull((Object)Iterables.find((Iterable)managementContext.getApplications(), (Predicate)Predicates.instanceOf(TestApplication.class), null), (String)("apps=" + managementContext.getApplications()));
    }

    protected void assertMementoContainerNonEmptyForTypeEventually(final String type) {
        Asserts.succeedsEventually((Map)ImmutableMap.of((Object)"timeout", (Object)Duration.TEN_SECONDS), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractBrooklynLauncherRebindTestFixture.getPersistenceStore(AbstractBrooklynLauncherRebindTestFixture.this.lastMgmt()).listContentsWithSubPath(type);
            }
        });
    }

    static PersistenceObjectStore getPersistenceStore(ManagementContext managementContext) {
        if (managementContext == null) {
            return null;
        }
        BrooklynMementoPersisterToObjectStore persister = (BrooklynMementoPersisterToObjectStore)managementContext.getRebindManager().getPersister();
        if (persister == null) {
            return null;
        }
        return persister.getObjectStore();
    }
}

