/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.basic;

import com.google.common.collect.Iterables;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.launcher.SimpleYamlLauncherForTests;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VanillaSoftwareYamlTest {
    private static final Logger log = LoggerFactory.getLogger(VanillaSoftwareYamlTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testVanillaSoftwareYaml() {
        SimpleYamlLauncherForTests l = new SimpleYamlLauncherForTests();
        try {
            Application app = l.launchAppYaml("vanilla-software-blueprint.yaml");
            log.info("started " + app);
            String runDir = (String)((Entity)Iterables.getOnlyElement((Iterable)app.getChildren())).getAttribute((AttributeSensor)SoftwareProcess.RUN_DIR);
            final String filePath = Os.mergePaths((String[])new String[]{runDir, "DATE"});
            String fileContents = new ResourceUtils((Object)this).getResourceAsString(filePath);
            Long d1 = Long.parseLong(Strings.getFirstWordAfter((String)fileContents, (String)"utc"));
            Assert.assertTrue((Math.abs(d1 * 1000L - System.currentTimeMillis()) < 15000L ? 1 : 0) != 0, (String)("Time UTC does not match system; " + d1 + " v " + System.currentTimeMillis()));
            Asserts.succeedsEventually((Runnable)new Runnable(){

                @Override
                public void run() {
                    String fileContents = new ResourceUtils((Object)this).getResourceAsString(filePath);
                    Assert.assertTrue((boolean)fileContents.contains("checkRunning"));
                }
            });
            app.invoke(Startable.STOP, null).getUnchecked();
            Asserts.succeedsEventually((Runnable)new Runnable(){

                @Override
                public void run() {
                    String fileContents = new ResourceUtils((Object)this).getResourceAsString(filePath);
                    Assert.assertTrue((boolean)fileContents.contains("stop"));
                }
            });
        }
        finally {
            l.destroyAll();
        }
        log.info("DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"Integration"})
    public void testVanillaSoftwareYamlWithChildStartedAfter() {
        SimpleYamlLauncherForTests l = new SimpleYamlLauncherForTests();
        try {
            Application app = l.launchAppYaml("vanilla-software-with-child-blueprint.yaml");
            log.info("started " + app);
            Entity p1 = (Entity)Iterables.getOnlyElement((Iterable)app.getChildren());
            Long d1 = Long.parseLong(Strings.getFirstWordAfter((String)new ResourceUtils((Object)this).getResourceAsString(Os.mergePaths((String[])new String[]{(String)p1.getAttribute((AttributeSensor)SoftwareProcess.RUN_DIR), "DATE"})), (String)"utc"));
            Entity p2 = (Entity)Iterables.getOnlyElement((Iterable)p1.getChildren());
            Long d2 = Long.parseLong(Strings.getFirstWordAfter((String)new ResourceUtils((Object)this).getResourceAsString(Os.mergePaths((String[])new String[]{(String)p2.getAttribute((AttributeSensor)SoftwareProcess.RUN_DIR), "DATE"})), (String)"utc"));
            Assert.assertTrue((d2 - d1 > 2L && d2 - d1 < 10L ? 1 : 0) != 0, (String)("p2 should have started 3s after parent, but it did not (" + (d2 - d1) + "s difference"));
        }
        finally {
            l.destroyAll();
        }
        log.info("DONE");
    }
}

