/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.common;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.test.entity.LocalManagementContextForTests;
import org.apache.brooklyn.launcher.common.BrooklynPropertiesFactoryHelper;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.StringFunctions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrooklynPropertiesFactoryHelperTest {
    @Test(groups={"UNIX"})
    public void testChecksGlobalBrooklynPropertiesPermissionsX00() throws Exception {
        File propsFile = File.createTempFile("testChecksGlobalBrooklynPropertiesPermissionsX00", ".properties");
        propsFile.setReadable(true, false);
        try {
            new BrooklynPropertiesFactoryHelper(propsFile.getAbsolutePath(), null).createPropertiesBuilder();
            Assert.fail((String)"Should have thrown");
        }
        catch (FatalRuntimeException e) {
            if (!e.toString().contains("Invalid permissions for file")) {
                throw e;
            }
        }
        finally {
            propsFile.delete();
        }
    }

    @Test(groups={"UNIX"})
    public void testChecksLocalBrooklynPropertiesPermissionsX00() throws Exception {
        File propsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00", ".properties");
        propsFile.setReadable(true, false);
        try {
            new BrooklynPropertiesFactoryHelper(propsFile.getAbsolutePath(), null).createPropertiesBuilder();
            Assert.fail((String)"Should have thrown");
        }
        catch (FatalRuntimeException e) {
            if (!e.toString().contains("Invalid permissions for file")) {
                throw e;
            }
        }
        finally {
            propsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"UNIX"})
    public void testStartsWithSymlinkedBrooklynPropertiesPermissionsX00() throws Exception {
        File dir = com.google.common.io.Files.createTempDir();
        Path globalPropsFile = Files.createFile(Paths.get(dir.toString(), "globalProps.properties"), new FileAttribute[0]);
        Path globalSymlink = Files.createSymbolicLink(Paths.get(dir.toString(), "globalLink"), globalPropsFile, new FileAttribute[0]);
        Path localPropsFile = Files.createFile(Paths.get(dir.toString(), "localPropsFile.properties"), new FileAttribute[0]);
        Path localSymlink = Files.createSymbolicLink(Paths.get(dir.toString(), "localLink"), localPropsFile, new FileAttribute[0]);
        com.google.common.io.Files.write((CharSequence)(BrooklynPropertiesFactoryHelperTest.getMinimalLauncherPropertiesString() + "key_in_global=1"), (File)globalPropsFile.toFile(), (Charset)Charset.defaultCharset());
        com.google.common.io.Files.write((CharSequence)"key_in_local=2", (File)localPropsFile.toFile(), (Charset)Charset.defaultCharset());
        FileUtil.setFilePermissionsTo600((File)globalPropsFile.toFile());
        FileUtil.setFilePermissionsTo600((File)localPropsFile.toFile());
        try {
            BrooklynProperties props = new BrooklynPropertiesFactoryHelper(globalSymlink.toAbsolutePath().toString(), localSymlink.toAbsolutePath().toString()).createPropertiesBuilder().build();
            Assert.assertEquals((String)props.getFirst(new String[]{"key_in_global"}), (String)"1");
            Assert.assertEquals((String)props.getFirst(new String[]{"key_in_local"}), (String)"2");
        }
        finally {
            Os.deleteRecursively((File)dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartsWithBrooklynPropertiesPermissionsX00() throws Exception {
        File globalPropsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00_global", ".properties");
        com.google.common.io.Files.write((CharSequence)(BrooklynPropertiesFactoryHelperTest.getMinimalLauncherPropertiesString() + "key_in_global=1"), (File)globalPropsFile, (Charset)Charset.defaultCharset());
        File localPropsFile = File.createTempFile("testChecksLocalBrooklynPropertiesPermissionsX00_local", ".properties");
        com.google.common.io.Files.write((CharSequence)"key_in_local=2", (File)localPropsFile, (Charset)Charset.defaultCharset());
        FileUtil.setFilePermissionsTo600((File)globalPropsFile);
        FileUtil.setFilePermissionsTo600((File)localPropsFile);
        try {
            BrooklynProperties props = new BrooklynPropertiesFactoryHelper(globalPropsFile.getAbsolutePath(), localPropsFile.getAbsolutePath()).createPropertiesBuilder().build();
            Assert.assertEquals((String)props.getFirst(new String[]{"key_in_global"}), (String)"1");
            Assert.assertEquals((String)props.getFirst(new String[]{"key_in_local"}), (String)"2");
        }
        finally {
            globalPropsFile.delete();
            localPropsFile.delete();
        }
    }

    public static String getMinimalLauncherPropertiesString() throws IOException {
        BrooklynProperties p1 = LocalManagementContextForTests.builder((boolean)true).buildProperties();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)Maps.transformValues((Map)p1.asMapWithStringKeys(), (Function)StringFunctions.toStringFunction()));
        StringWriter w = new StringWriter();
        p.store(w, "test");
        ((Writer)w).close();
        return ((Object)w).toString() + "\n";
    }
}

