/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.command.support;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsUtil;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.stream.Streams;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;

public abstract class CloudExplorerSupport
implements Callable<Void> {
    private ManagementContext managementContext;
    public static final String ALL_LOCATIONS_DESC = "All locations (i.e. all locations in brooklyn.properties for which there are credentials)";
    public boolean allLocations;
    public static final String LOCATION_DESC = "A location spec (e.g. referring to a named location in brooklyn.properties file)";
    public String location;
    public static final String AUTOCONFIRM_DESC = "Automatically answer yes to any questions";
    public boolean autoconfirm = false;
    @VisibleForTesting
    protected PrintStream stdout = System.out;
    @VisibleForTesting
    protected PrintStream stderr = System.err;
    @VisibleForTesting
    protected InputStream stdin = System.in;

    public CloudExplorerSupport(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
        this.managementContext = managementContext;
        this.allLocations = allLocations;
        this.location = location;
        this.autoconfirm = autoconfirm;
    }

    protected abstract void doCall(JcloudsLocation var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        ArrayList locs = Lists.newArrayList();
        if (this.location != null && this.allLocations) {
            throw new FatalConfigurationRuntimeException("Must not specify --location and --all-locations");
        }
        if (this.location != null) {
            JcloudsLocation loc = (JcloudsLocation)this.managementContext.getLocationRegistry().getLocationManaged(this.location);
            locs.add(loc);
        } else if (this.allLocations) {
            Map definedLocations = this.managementContext.getLocationRegistry().getDefinedLocations();
            for (LocationDefinition locationDef : definedLocations.values()) {
                Location loc = this.managementContext.getLocationManager().createLocation((LocationSpec)this.managementContext.getLocationRegistry().getLocationSpec(locationDef).get());
                if (!(loc instanceof JcloudsLocation)) continue;
                boolean found = false;
                for (JcloudsLocation existing : locs) {
                    if (!this.equalTargets(existing, (JcloudsLocation)loc)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                locs.add((JcloudsLocation)loc);
            }
        } else {
            throw new FatalConfigurationRuntimeException("Must specify one of --location or --all-locations");
        }
        for (JcloudsLocation loc : locs) {
            this.stdout.println("Location {");
            this.stdout.println("\tprovider: " + loc.getProvider());
            this.stdout.println("\tdisplayName: " + loc.getDisplayName());
            this.stdout.println("\tidentity: " + loc.getIdentity());
            if (loc.getEndpoint() != null) {
                this.stdout.println("\tendpoint: " + loc.getEndpoint());
            }
            if (loc.getRegion() != null) {
                this.stdout.println("\tregion: " + loc.getRegion());
            }
            try {
                this.doCall(loc, "\t");
            }
            finally {
                this.stdout.println("}");
            }
        }
        return null;
    }

    protected boolean equalTargets(JcloudsLocation loc1, JcloudsLocation loc2) {
        return Objects.equal((Object)loc1.getProvider(), (Object)loc2.getProvider()) && Objects.equal((Object)loc1.getIdentity(), (Object)loc2.getIdentity()) && Objects.equal((Object)loc1.getEndpoint(), (Object)loc2.getEndpoint()) && Objects.equal((Object)loc1.getRegion(), (Object)loc2.getRegion());
    }

    protected boolean confirm(String msg, String indent) throws Exception {
        boolean confirmed;
        if (this.autoconfirm) {
            this.stdout.println(indent + "Auto-confirmed: " + msg);
            return true;
        }
        this.stdout.println(indent + "Enter y/n. Are you sure you want to " + msg);
        int in = this.stdin.read();
        boolean bl = confirmed = Character.toLowerCase(in) == 121;
        if (confirmed) {
            this.stdout.println(indent + "Confirmed; will " + msg);
        } else {
            this.stdout.println(indent + "Declined; will not " + msg);
        }
        return confirmed;
    }

    public static class GetBlob
    extends Blobstore {
        public static final String NAME = "blob";
        public static final String DESCRIPTION = "list blob details for a given container and blob";
        public static final String CONTAINER_ARGUMENT_NAME = "--container";
        public static final String CONTAINER_ARGUMENT_DESC = "name of the container of the blob";
        public static final String BLOB_ARGUMENT_NAME = "--blob";
        public static final String BLOB_ARGUMENT_DESC = "name of the blob in the container";
        public String container;
        public String blob;

        public GetBlob(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm, String container, String blob) {
            super(managementContext, allLocations, location, autoconfirm);
            this.container = container;
            this.blob = blob;
        }

        @Override
        protected void doCall(BlobStore blobStore, String indent) throws Exception {
            Blob content = blobStore.getBlob(this.container, this.blob);
            this.stdout.println(indent + "Blob " + this.container + " : " + this.blob + " {");
            this.stdout.println(indent + "\tHeaders {");
            for (Map.Entry entry : content.getAllHeaders().entries()) {
                this.stdout.println(indent + "\t\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            this.stdout.println(indent + "\t}");
            this.stdout.println(indent + "\tmetadata : " + content.getMetadata());
            this.stdout.println(indent + "\tpayload : " + Streams.readFullyStringAndClose((InputStream)content.getPayload().openStream()));
            this.stdout.println(indent + "}");
        }
    }

    public static class BlobstoreListContainer
    extends Blobstore {
        public static final String NAME = "list-container";
        public static final String DESCRIPTION = "list container details for one or more container names";
        public static final String ARGUMENT_NAME = "container-names";
        public static final String ARGUMENT_DESC = "names of the containers to list";
        private List<String> names;

        public BlobstoreListContainer(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm, List<String> names) {
            super(managementContext, allLocations, location, autoconfirm);
            this.names = names;
        }

        @Override
        protected void doCall(BlobStore blobStore, String indent) throws Exception {
            for (String containerName : this.names) {
                PageSet contents = blobStore.list(containerName);
                this.stdout.println(indent + "Container " + containerName + " {");
                for (StorageMetadata content : contents) {
                    this.stdout.println(indent + "\t" + content);
                }
                this.stdout.println(indent + "}");
            }
        }
    }

    public static class BlobstoreListContainers
    extends Blobstore {
        public static final String NAME = "list-containers";
        public static final String DESCRIPTION = "list containers";

        public BlobstoreListContainers(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(BlobStore blobstore, String indent) throws Exception {
            PageSet containers = blobstore.list();
            this.stdout.println(indent + "Containers {");
            for (StorageMetadata container : containers) {
                this.stdout.println(indent + "\t" + container);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static abstract class Blobstore
    extends CloudExplorerSupport {
        public Blobstore(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        protected abstract void doCall(BlobStore var1, String var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            String identity = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.ACCESS_IDENTITY), (Object)"identity must not be null");
            String credential = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL), (Object)"credential must not be null");
            String provider = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.CLOUD_PROVIDER), (Object)"provider must not be null");
            String endpoint = (String)loc.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
            try (BlobStoreContext context = JcloudsUtil.newBlobstoreContext((String)provider, (String)endpoint, (String)identity, (String)credential);){
                BlobStore blobStore = context.getBlobStore();
                this.doCall(blobStore, indent);
            }
        }
    }

    public static class TerminateInstances
    extends ComputeExploration {
        public static final String NAME = "terminate-instances";
        public static final String DESCRIPTION = "terminate instances for one or more instance IDs";
        public static final String ARGUMENT_NAME = "instanceIds";
        public static final String ARGUMENT_DESC = "IDs of the instances to terminate";
        private List<String> names;

        public TerminateInstances(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm, List<String> names) {
            super(managementContext, allLocations, location, autoconfirm);
            this.names = names;
        }

        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            for (String instanceId : this.names) {
                NodeMetadata instance = computeService.getNodeMetadata(instanceId);
                if (instance == null) {
                    this.stderr.println(indent + "Cannot terminate instance; could not find " + instanceId);
                    continue;
                }
                boolean confirmed = this.confirm(indent, "terminate " + instanceId + " (" + instance + ")");
                if (!confirmed) continue;
                computeService.destroyNode(instanceId);
            }
        }
    }

    public static class ComputeDefaultTemplate
    extends CloudExplorerSupport {
        public static final String NAME = "default-template";
        public static final String DESCRIPTION = "compute default template";

        public ComputeDefaultTemplate(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            ComputeService computeService = loc.getComputeService();
            ConfigBag setup = loc.config().getBag();
            Collection customizers = loc.getCustomizers(setup);
            Template template = loc.buildTemplate(computeService, setup, customizers);
            Image image = template.getImage();
            Hardware hardware = template.getHardware();
            org.jclouds.domain.Location location = template.getLocation();
            TemplateOptions options = template.getOptions();
            this.stdout.println(indent + "Default template {");
            this.stdout.println(indent + "\tImage: " + image);
            this.stdout.println(indent + "\tHardware: " + hardware);
            this.stdout.println(indent + "\tLocation: " + location);
            this.stdout.println(indent + "\tOptions: " + options);
            this.stdout.println(indent + "}");
        }
    }

    public static class GetImage
    extends ComputeExploration {
        public static final String NAME = "get-image";
        public static final String DESCRIPTION = "get image details for one or more imageIds";
        public static final String ARGUMENT_NAME = "imageIds";
        public static final String ARGUMENT_DESC = "IDs of the images to retrieve";
        private List<String> names;

        public GetImage(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm, List<String> arguments) {
            super(managementContext, allLocations, location, autoconfirm);
            this.names = arguments;
        }

        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            for (String imageId : this.names) {
                Image image = computeService.getImage(imageId);
                if (image == null) {
                    return;
                }
                this.stdout.println(indent + "Image " + imageId + " {");
                this.stdout.println(indent + "\t" + image);
                this.stdout.println(indent + "}");
            }
        }
    }

    public static class ListHardwareProfiles
    extends ComputeExploration {
        public static final String NAME = "list-hardware-profiles";
        public static final String DESCRIPTION = "list hardware profiles";

        public ListHardwareProfiles(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            Set hardware = computeService.listHardwareProfiles();
            this.stdout.println(indent + "Hardware Profiles {");
            for (Hardware image : hardware) {
                this.stdout.println(indent + "\t" + image);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static class ListImages
    extends ComputeExploration {
        public static final String NAME = "list-images";
        public static final String DESCRIPTION = "list images";

        public ListImages(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            Set images = computeService.listImages();
            this.stdout.println(indent + "Images {");
            for (Image image : images) {
                this.stdout.println(indent + "\t" + image);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static class ListInstances
    extends ComputeExploration {
        public static final String NAME = "list-instances";
        public static final String DESCRIPTION = "list instances";

        public ListInstances(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            Set instances = computeService.listNodes();
            this.stdout.println(indent + "Instances {");
            for (ComputeMetadata instance : instances) {
                this.stdout.println(indent + "\t" + instance);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static abstract class ComputeExploration
    extends CloudExplorerSupport {
        protected abstract void doCall(ComputeService var1, String var2) throws Exception;

        public ComputeExploration(ManagementContext managementContext, boolean allLocations, String location, boolean autoconfirm) {
            super(managementContext, allLocations, location, autoconfirm);
        }

        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            ComputeService computeService = loc.getComputeService();
            this.doCall(computeService, indent);
        }
    }
}

