/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.jsgui;

import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.entity.basic.Entities;
import brooklyn.management.ManagementContext;
import brooklyn.rest.BrooklynRestApiLauncherTestFixture;
import brooklyn.rest.jsgui.BrooklynJavascriptGuiLauncher;
import brooklyn.test.HttpTestUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class BrooklynJavascriptGuiLauncherTest {
    Server server = null;

    @AfterMethod(alwaysRun=true)
    public void stopServer() throws Exception {
        if (this.server != null) {
            ManagementContext mgmt = this.getManagementContextFromJettyServerAttributes(this.server);
            this.server.stop();
            if (mgmt != null) {
                Entities.destroyAll((ManagementContext)mgmt);
            }
            this.server = null;
        }
    }

    @Test
    public void testJavascriptWithoutRest() throws Exception {
        this.server = BrooklynJavascriptGuiLauncher.startJavascriptWithoutRest();
        this.checkUrlContains("/index.html", "Brooklyn");
    }

    @Test
    public void testJavascriptWithRest() throws Exception {
        this.server = BrooklynJavascriptGuiLauncher.startJavascriptAndRest();
        BrooklynRestApiLauncherTestFixture.forceUseOfDefaultCatalogWithJavaClassPath((Server)this.server);
        BrooklynRestApiLauncherTestFixture.enableAnyoneLogin((Server)this.server);
        this.checkEventuallyHealthy();
        this.checkUrlContains("/index.html", "Brooklyn");
        this.checkUrlContains("/v1/catalog/entities", "Tomcat");
    }

    protected void checkUrlContains(String path, String text) {
        HttpTestUtils.assertContentEventuallyContainsText((String)(this.rootUrl() + path), (String)text, (String[])new String[0]);
    }

    protected void checkEventuallyHealthy() {
        HttpTestUtils.assertHttpStatusCodeEventuallyEquals((String)this.rootUrl(), (int)200);
    }

    protected String rootUrl() {
        return "http://localhost:" + this.server.getConnectors()[0].getLocalPort();
    }

    private ManagementContext getManagementContextFromJettyServerAttributes(Server server) {
        return (ManagementContext)((ContextHandler)server.getHandler()).getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
    }
}

