/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.jmx.jmxmp;

import brooklyn.util.crypto.FluentKeySigner;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.jmx.jmxmp.JmxmpAgent;
import brooklyn.util.jmx.jmxmp.JmxmpClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.management.remote.JMXConnectorServer;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JmxmpAgentSslTest {
    KeyPair caRootKey;
    FluentKeySigner caRootSigner;
    X509Certificate caRootCert;
    KeyPair caChildKey;
    X509Certificate caChildCert;
    FluentKeySigner caChildSigner;
    KeyPair grandchildKey;
    X509Certificate grandchildCert;
    KeyPair child2Key;
    X509Certificate child2Cert;
    KeyPair selfSign1Key;
    X509Certificate selfSign1Cert;
    KeyPair selfSign2Key;
    X509Certificate selfSign2Cert;
    KeyStore serverKeystore;
    KeyStore serverTruststore;
    KeyStore clientTruststore;
    KeyStore clientKeystore;
    JMXConnectorServer server;

    @BeforeMethod
    public void setup() throws Exception {
        this.caRootSigner = new FluentKeySigner("ca-root").selfsign();
        this.caRootKey = this.caRootSigner.getKey();
        this.caRootCert = this.caRootSigner.getAuthorityCertificate();
        this.caChildKey = SecureKeys.newKeyPair();
        this.caChildCert = this.caRootSigner.newCertificateFor("ca-child", this.caChildKey);
        this.caChildSigner = new FluentKeySigner("ca-child", this.caChildKey).authorityKeyIdentifier((AuthorityKeyIdentifier)new AuthorityKeyIdentifierStructure(this.caChildCert));
        this.grandchildKey = SecureKeys.newKeyPair();
        this.grandchildCert = this.caChildSigner.newCertificateFor("grandchild", this.grandchildKey);
        this.child2Key = SecureKeys.newKeyPair();
        this.child2Cert = this.caRootSigner.newCertificateFor("child-2", this.child2Key);
        this.selfSign1Key = SecureKeys.newKeyPair();
        this.selfSign1Cert = new FluentKeySigner("self-1", this.selfSign1Key).newCertificateFor("self-1", this.selfSign1Key);
        this.selfSign2Key = SecureKeys.newKeyPair();
        this.selfSign2Cert = new FluentKeySigner("self-2", this.selfSign2Key).newCertificateFor("self-2", this.selfSign2Key);
        this.serverKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.serverKeystore.load(null, null);
        this.serverTruststore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.serverTruststore.load(null, null);
        this.clientTruststore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.clientTruststore.load(null, null);
        this.clientKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.clientKeystore.load(null, null);
    }

    @AfterMethod
    public void teardown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.server = null;
    }

    private Properties saveStoresAndGetConnectorProperties() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException {
        String keystoreFile = File.createTempFile("server-keystore", ".jmx.test").getAbsolutePath();
        String truststoreFile = File.createTempFile("server-truststore", ".jmx.test").getAbsolutePath();
        if (this.serverKeystore != null) {
            this.serverKeystore.store(new FileOutputStream(keystoreFile), new char[0]);
        }
        if (this.serverTruststore != null) {
            this.serverTruststore.store(new FileOutputStream(truststoreFile), new char[0]);
        }
        Properties p = new Properties();
        p.put("brooklyn.jmxmp.ssl.keyStore", keystoreFile);
        p.put("brooklyn.jmxmp.ssl.trustStore", truststoreFile);
        p.put("com.sun.management.jmxremote.ssl", "true");
        p.put("brooklyn.jmxmp.ssl.authenticate", "true");
        return p;
    }

    @Test
    public void testNoAuth() throws Exception {
        this.serverKeystore = null;
        this.serverTruststore = null;
        this.clientKeystore = null;
        this.clientTruststore = null;
        Properties p = this.saveStoresAndGetConnectorProperties();
        p.put("com.sun.management.jmxremote.ssl", "false");
        p.put("brooklyn.jmxmp.ssl.authenticate", "false");
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connect("service:jmx:jmxmp://localhost:11099", new LinkedHashMap());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testAuthWithoutSslFails() throws Exception {
        this.serverKeystore = null;
        this.serverTruststore = null;
        this.clientKeystore = null;
        this.clientTruststore = null;
        Properties p = this.saveStoresAndGetConnectorProperties();
        p.put("com.sun.management.jmxremote.ssl", "false");
        p.put("brooklyn.jmxmp.ssl.authenticate", "true");
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connect("service:jmx:jmxmp://localhost:11099", new LinkedHashMap());
    }

    @Test
    public void testAllGoodSignatures() throws Exception {
        this.serverKeystore.setKeyEntry("child-2", this.child2Key.getPrivate(), new char[0], new Certificate[]{this.child2Cert, this.caRootCert});
        this.serverTruststore.setCertificateEntry("ca-child", this.caChildCert);
        this.clientKeystore.setKeyEntry("grandchild", this.grandchildKey.getPrivate(), new char[0], new Certificate[]{this.grandchildCert});
        this.clientTruststore.setCertificateEntry("ca-root", this.caRootCert);
        Properties p = this.saveStoresAndGetConnectorProperties();
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connectTls("service:jmx:jmxmp://localhost:11099", this.clientKeystore, "", this.clientTruststore);
    }

    @Test(expectedExceptions={Exception.class})
    public void testWrongServerKey() throws Exception {
        this.serverKeystore.setKeyEntry("self-1", this.selfSign1Key.getPrivate(), new char[0], new Certificate[]{this.selfSign1Cert});
        this.serverTruststore.setCertificateEntry("ca-child", this.caChildCert);
        this.clientKeystore.setKeyEntry("grandchild", this.grandchildKey.getPrivate(), new char[0], new Certificate[]{this.grandchildCert});
        this.clientTruststore.setCertificateEntry("ca-root", this.caRootCert);
        Properties p = this.saveStoresAndGetConnectorProperties();
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connectTls("service:jmx:jmxmp://localhost:11099", this.clientKeystore, "", this.clientTruststore);
    }

    @Test(expectedExceptions={Exception.class})
    public void testLyingServerChain() throws Exception {
        this.serverKeystore.setKeyEntry("self-1", this.selfSign1Key.getPrivate(), new char[0], new Certificate[]{this.selfSign1Cert, this.caChildCert});
        this.serverTruststore.setCertificateEntry("ca-child", this.caChildCert);
        this.clientKeystore.setKeyEntry("grandchild", this.grandchildKey.getPrivate(), new char[0], new Certificate[]{this.grandchildCert, this.caChildCert});
        this.clientTruststore.setCertificateEntry("ca-root", this.caRootCert);
        Properties p = this.saveStoresAndGetConnectorProperties();
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connectTls("service:jmx:jmxmp://localhost:11099", this.clientKeystore, "", this.clientTruststore);
    }

    @Test(expectedExceptions={Exception.class})
    public void testWrongClientKey() throws Exception {
        this.serverKeystore.setKeyEntry("child-2", this.child2Key.getPrivate(), new char[0], new Certificate[]{this.child2Cert, this.caRootCert});
        this.serverTruststore.setCertificateEntry("ca-child", this.caChildCert);
        this.clientKeystore.setKeyEntry("self-1", this.selfSign1Key.getPrivate(), new char[0], new Certificate[]{this.selfSign1Cert});
        this.clientTruststore.setCertificateEntry("ca-root", this.caRootCert);
        Properties p = this.saveStoresAndGetConnectorProperties();
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connectTls("service:jmx:jmxmp://localhost:11099", this.clientKeystore, "", this.clientTruststore);
    }

    @Test(expectedExceptions={Exception.class})
    public void testLyingClientChain() throws Exception {
        this.serverKeystore.setKeyEntry("child-2", this.child2Key.getPrivate(), new char[0], new Certificate[]{this.child2Cert, this.caRootCert});
        this.serverTruststore.setCertificateEntry("ca-child", this.caChildCert);
        this.clientKeystore.setKeyEntry("self-1", this.selfSign1Key.getPrivate(), new char[0], new Certificate[]{this.selfSign1Cert, this.caChildCert});
        this.clientTruststore.setCertificateEntry("ca-root", this.caRootCert);
        Properties p = this.saveStoresAndGetConnectorProperties();
        this.server = new JmxmpAgent().startJmxmpConnector(p);
        new JmxmpClient().connectTls("service:jmx:jmxmp://localhost:11099", this.clientKeystore, "", this.clientTruststore);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

