/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import org.apache.brooklyn.cli.BaseCliIntegrationTest;
import org.testng.annotations.Test;

public class CliIntegrationTest
extends BaseCliIntegrationTest {
    @Test(groups={"Integration", "Broken"})
    public void testLaunchCliHelp() throws Throwable {
        Process brooklyn = this.startBrooklyn("help");
        BaseCliIntegrationTest.BrooklynCliTest test = new BaseCliIntegrationTest.BrooklynCliTest(brooklyn){

            @Override
            public void checkConsole() {
                this.assertConsoleOutput("usage: brooklyn");
                this.assertConsoleOutput("The most commonly used brooklyn commands are:");
                this.assertConsoleOutput("help     Display help for available commands", "info     Display information about brooklyn", "launch   Starts a brooklyn application");
                this.assertConsoleOutput("See 'brooklyn help <command>' for more information on a specific command.");
                this.assertConsoleErrorEmpty();
            }
        };
        this.testBrooklyn(brooklyn, test, 0);
    }

    @Test(groups={"Integration", "Broken"})
    public void testLaunchCliApp() throws Throwable {
        Process brooklyn = this.startBrooklyn("--verbose", "launch", "--stopOnKeyPress", "--app", "org.apache.brooklyn.cli.BaseCliIntegrationTest$TestApplication", "--location", "localhost", "--noConsole");
        BaseCliIntegrationTest.BrooklynCliTest test = new BaseCliIntegrationTest.BrooklynCliTest(brooklyn){

            @Override
            public void checkConsole() {
                this.assertConsoleOutput("Launching brooklyn app:");
                this.assertNoConsoleOutput("Initiating Jersey application");
                this.assertConsoleOutput("Started application BasicApplicationImpl");
                this.assertConsoleOutput("Server started. Press return to stop.");
                this.assertConsoleErrorEmpty();
            }
        };
        this.testBrooklyn(brooklyn, test, 0, true);
    }

    @Test(groups={"Integration", "Broken"})
    public void testLaunchCliAppParamError() throws Throwable {
        Process brooklyn = this.startBrooklyn("launch", "nothing", "--app");
        BaseCliIntegrationTest.BrooklynCliTest test = new BaseCliIntegrationTest.BrooklynCliTest(brooklyn){

            @Override
            public void checkConsole() {
                this.assertConsoleError("Parse error: Required values for option 'application class or file' not provided");
                this.assertConsoleError("NAME", "SYNOPSIS", "OPTIONS", "COMMANDS");
                this.assertConsoleOutputEmpty();
            }
        };
        this.testBrooklyn(brooklyn, test, 1);
    }

    @Test(groups={"Integration"})
    public void testLaunchCliAppCommandError() throws Throwable {
        Process brooklyn = this.startBrooklyn("biscuit");
        BaseCliIntegrationTest.BrooklynCliTest test = new BaseCliIntegrationTest.BrooklynCliTest(brooklyn){

            @Override
            public void checkConsole() {
                this.assertConsoleError("Parse error: No command specified");
                this.assertConsoleError("NAME", "SYNOPSIS", "OPTIONS", "COMMANDS");
                this.assertConsoleOutputEmpty();
            }
        };
        this.testBrooklyn(brooklyn, test, 1);
    }

    @Test(groups={"Integration", "Broken"})
    public void testLaunchCliAppLaunchError() throws Throwable {
        String app = "org.eample.DoesNotExist";
        Process brooklyn = this.startBrooklyn("launch", "--app", "org.eample.DoesNotExist", "--location", "nowhere");
        BaseCliIntegrationTest.BrooklynCliTest test = new BaseCliIntegrationTest.BrooklynCliTest(brooklyn){

            @Override
            public void checkConsole() {
                this.assertConsoleOutput("org.eample.DoesNotExist", "not found");
                this.assertConsoleError("ERROR", "Fatal", "getting resource", "org.eample.DoesNotExist");
            }
        };
        this.testBrooklyn(brooklyn, test, 2);
    }
}

